/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.hana.model.HANADataSourceInfo;
import org.jkiss.dbeaver.ext.hana.model.HANASQLDialect;
import org.jkiss.dbeaver.ext.hana.model.HANAStructureAssistant;
import org.jkiss.dbeaver.ext.hana.model.HANAUserPasswordManager;
import org.jkiss.dbeaver.ext.hana.model.plan.HANAPlanAnalyser;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class HANADataSource
extends GenericDataSource
implements DBCQueryPlanner {
    private static final Log log = Log.getLog(HANADataSource.class);
    private HashMap<String, String> sysViewColumnUnits;
    private boolean isPasswordExpireWarningShown;

    public HANADataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new HANASQLDialect());
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        HANADataSourceInfo info = new HANADataSourceInfo(metaData);
        return info;
    }

    public DBPDataKind resolveDataKind(String typeName, int valueType) {
        if ("HALF_VECTOR".equalsIgnoreCase(typeName) || "REAL_VECTOR".equalsIgnoreCase(typeName)) {
            return DBPDataKind.ARRAY;
        }
        return super.resolveDataKind(typeName, valueType);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new HANAStructureAssistant(this));
        }
        if (adapter == DBAUserPasswordManager.class) {
            return adapter.cast(new HANAUserPasswordManager(this));
        }
        return (T)super.getAdapter(adapter);
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        HANAPlanAnalyser plan = new HANAPlanAnalyser(this, query);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            String appName = DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose);
            props.put("SESSIONVARIABLE:APPLICATION", appName);
        }
        if (this.getContainer().isConnectionReadOnly()) {
            props.put("READONLY", "TRUE");
        }
        props.put("SESSIONVARIABLE:SPATIAL_OUTPUT_REPRESENTATION", "EWKB");
        props.put("SESSIONVARIABLE:SPATIAL_WKB_EMPTY_POINT_REPRESENTATION", "NAN_COORDINATES");
        return props;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection connection = super.openConnection(monitor, context, purpose);
        try {
            Statement statement = connection.createStatement();
            statement.execute("SELECT * FROM SYS.DUMMY");
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 414) {
                if (this.changeExpiredPassword(monitor, context, purpose)) {
                    return this.openConnection(monitor, context, purpose);
                }
            }
            log.debug((Object)"password expired check failed ", (Throwable)e);
        }
        try {
            SQLWarning warning = connection.getWarnings();
            while (warning != null) {
                if (warning.getErrorCode() == 431 && !this.isPasswordExpireWarningShown) {
                    this.isPasswordExpireWarningShown = true;
                    DBWorkbench.getPlatformUI().showWarningMessageBox("Warning", warning.getMessage());
                }
                warning = warning.getNextWarning();
            }
        }
        catch (SQLException e) {
            log.debug((Object)"password expire check failed", (Throwable)e);
        }
        return connection;
    }

    private boolean changeExpiredPassword(DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose) {
        DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
        DBAPasswordChangeInfo passwordInfo = DBWorkbench.getPlatformUI().promptUserPasswordChange("Password has expired. Set new password.", connectionInfo.getUserName(), connectionInfo.getUserPassword(), false, false);
        if (passwordInfo == null) {
            return false;
        }
        try {
            if (passwordInfo.getNewPassword() == null) {
                throw new DBException("You can't set empty password");
            }
            Connection connection = super.openConnection(monitor, context, purpose);
            Statement statement = connection.createStatement();
            statement.execute("ALTER USER " + connectionInfo.getUserName() + " PASSWORD " + DBUtils.getQuotedIdentifier((DBPDataSource)this, (String)passwordInfo.getNewPassword()));
            connectionInfo.setUserPassword(passwordInfo.getNewPassword());
            this.getContainer().getConnectionConfiguration().setUserPassword(passwordInfo.getNewPassword());
            this.getContainer().persistConfiguration();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Error changing password", "Error changing expired password", (Throwable)e);
            return false;
        }
        return true;
    }

    public void initializeSysViewColumnUnits(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.sysViewColumnUnits != null) {
            return;
        }
        this.sysViewColumnUnits = new HashMap();
        String stmt = "SELECT VIEW_NAME||'.'||VIEW_COLUMN_NAME, UNIT FROM SYS.M_MONITOR_COLUMNS WHERE UNIT IS NOT NULL";
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read generic metadata");){
            try {
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet resultSet = dbStat.executeQuery();){
                        while (resultSet.next()) {
                            this.sysViewColumnUnits.put(resultSet.getString(1), resultSet.getString(2));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                log.debug((Object)("Error getting SYS column units: " + e.getMessage()));
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    String getSysViewColumnUnit(String objectName, String columnName) {
        return this.sysViewColumnUnits.get(objectName + "." + columnName);
    }
}

