/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import com.hierynomus.sshj.common.KeyDecryptionFailedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.userauth.keyprovider.PEMKey;
import net.schmizz.sshj.userauth.keyprovider.StandardPEMKeyReader;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.userauth.password.Resource;
import org.bouncycastle.openssl.PEMDecryptor;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;

class EncryptedPEMKeyReader
extends StandardPEMKeyReader {
    private static final String PROC_TYPE_ENCRYPTED_HEADER = "Proc-Type: 4,ENCRYPTED";
    private static final Pattern DEK_INFO_PATTERN = Pattern.compile("^DEK-Info: ([A-Z0-9\\-]+),([A-F0-9]{16,32})$");
    private static final int DEK_INFO_ALGORITHM_GROUP = 1;
    private static final int DEK_INFO_IV_GROUP = 2;
    private final PasswordFinder passwordFinder;
    private final Resource<?> resource;

    EncryptedPEMKeyReader(PasswordFinder passwordFinder, Resource<?> resource) {
        this.passwordFinder = Objects.requireNonNull(passwordFinder, "Password Finder required");
        this.resource = Objects.requireNonNull(resource, "Resource required");
    }

    @Override
    public PEMKey readPemKey(BufferedReader bufferedReader) throws IOException {
        PEMKey pemKey = super.readPemKey(bufferedReader);
        List<String> headers = pemKey.getHeaders();
        PEMKey processedPemKey = this.isEncrypted(headers) ? this.readEncryptedPemKey(pemKey) : pemKey;
        return processedPemKey;
    }

    private boolean isEncrypted(List<String> headers) {
        return headers.contains(PROC_TYPE_ENCRYPTED_HEADER);
    }

    private PEMKey readEncryptedPemKey(PEMKey pemKey) throws IOException {
        List<String> headers = pemKey.getHeaders();
        DataEncryptionKeyInfo dataEncryptionKeyInfo = this.getDataEncryptionKeyInfo(headers);
        byte[] pemKeyBody = pemKey.getBody();
        byte[] decryptedPemKeyBody = null;
        char[] password = this.passwordFinder.reqPassword(this.resource);
        while (password != null) {
            try {
                decryptedPemKeyBody = this.getDecryptedPemKeyBody(password, pemKeyBody, dataEncryptionKeyInfo);
                break;
            }
            catch (KeyDecryptionFailedException e) {
                if (this.passwordFinder.shouldRetry(this.resource)) {
                    password = this.passwordFinder.reqPassword(this.resource);
                    continue;
                }
                throw e;
            }
        }
        if (decryptedPemKeyBody == null) {
            throw new KeyDecryptionFailedException("PEM Key password-based decryption failed");
        }
        return new PEMKey(pemKey.getPemKeyType(), headers, decryptedPemKeyBody);
    }

    private byte[] getDecryptedPemKeyBody(char[] password, byte[] pemKeyBody, DataEncryptionKeyInfo dataEncryptionKeyInfo) throws IOException {
        String algorithm = dataEncryptionKeyInfo.algorithm;
        try {
            BcPEMDecryptorProvider pemDecryptorProvider = new BcPEMDecryptorProvider(password);
            PEMDecryptor pemDecryptor = pemDecryptorProvider.get(algorithm);
            byte[] initializationVector = dataEncryptionKeyInfo.initializationVector;
            byte[] byArray = pemDecryptor.decrypt(pemKeyBody, initializationVector);
            return byArray;
        }
        catch (OperatorCreationException e) {
            throw new IOException(String.format("PEM decryption support not found for algorithm [%s]", algorithm), e);
        }
        catch (PEMException e) {
            throw new KeyDecryptionFailedException(String.format("PEM Key decryption failed for algorithm [%s]", algorithm), e);
        }
        finally {
            PasswordUtils.blankOut(password);
        }
    }

    private DataEncryptionKeyInfo getDataEncryptionKeyInfo(List<String> headers) throws IOException {
        DataEncryptionKeyInfo dataEncryptionKeyInfo = null;
        for (String header : headers) {
            Matcher matcher = DEK_INFO_PATTERN.matcher(header);
            if (!matcher.matches()) continue;
            String algorithm = matcher.group(1);
            String initializationVectorGroup = matcher.group(2);
            byte[] initializationVector = ByteArrayUtils.parseHex(initializationVectorGroup);
            dataEncryptionKeyInfo = new DataEncryptionKeyInfo(algorithm, initializationVector);
        }
        if (dataEncryptionKeyInfo == null) {
            throw new IOException("Data Encryption Key Information header [DEK-Info] not found");
        }
        return dataEncryptionKeyInfo;
    }

    private static class DataEncryptionKeyInfo {
        private final String algorithm;
        private final byte[] initializationVector;

        private DataEncryptionKeyInfo(String algorithm, byte[] initializationVector) {
            this.algorithm = algorithm;
            this.initializationVector = initializationVector;
        }
    }
}

