/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import java.io.File;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.notifications.AbstractNotification;
import org.jkiss.dbeaver.ui.notifications.DatabaseNotification;
import org.jkiss.dbeaver.ui.notifications.DatabaseNotificationSink;
import org.jkiss.dbeaver.ui.notifications.GeneralNotification;
import org.jkiss.dbeaver.ui.notifications.NotificationSettings;
import org.jkiss.dbeaver.ui.notifications.NotificationSinkEvent;
import org.jkiss.dbeaver.ui.notifications.NotificationSound;
import org.jkiss.dbeaver.ui.notifications.NotificationSoundProvider;
import org.jkiss.dbeaver.ui.notifications.sounds.BeepSoundProvider;
import org.jkiss.dbeaver.ui.notifications.sounds.FileSoundProvider;
import org.jkiss.dbeaver.ui.registry.NotificationDescriptor;
import org.jkiss.dbeaver.ui.registry.NotificationRegistry;
import org.jkiss.utils.CommonUtils;

public abstract class NotificationUtils {
    private static final Log log = Log.getLog(NotificationUtils.class);
    private static final DatabaseNotificationSink NOTIFICATION_SINK = new DatabaseNotificationSink();
    private static final String NOTIFICATIONS_SETTINGS_PREFIX = "notifications.settings.";
    private static final String NOTIFICATIONS_KEY_ENABLE_POPUP = ".enablePopup";
    private static final String NOTIFICATIONS_KEY_ENABLE_SOUND = ".enableSound";
    private static final String NOTIFICATIONS_KEY_SOUND_FILE = ".soundFile";

    public static void sendNotification(DBPDataSource dataSource, String id, String text, DBPMessageType messageType, Runnable feedback) {
        NotificationUtils.sendNotification(id, () -> new DatabaseNotification(dataSource, id, text, messageType, feedback));
    }

    public static void sendNotification(String id, String title, String text, DBPMessageType messageType, Runnable feedback) {
        NotificationUtils.sendNotification(id, () -> new GeneralNotification(id, title, text, messageType, feedback));
    }

    private static void sendNotification(@NotNull String id, @NotNull Supplier<AbstractNotification> notificationSupplier) {
        NotificationSoundProvider soundProvider;
        if (NotificationUtils.isPopupEnabled(id)) {
            try {
                NOTIFICATION_SINK.notify(new NotificationSinkEvent(Collections.singletonList(notificationSupplier.get())));
            }
            catch (Exception e) {
                log.debug((Object)"Error sending notification", (Throwable)e);
            }
        }
        if (NotificationUtils.isSoundEnabled(id) && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("notifications.soundEnabled") && (soundProvider = NotificationUtils.getNotificationSoundProvider(id)) != null) {
            NotificationUtils.scheduleNotificationSound(soundProvider);
        }
    }

    @NotNull
    public static NotificationSettings getNotificationSettings(@NotNull String id) {
        NotificationDescriptor notification = NotificationRegistry.getInstance().getNotification(id);
        if (notification == null) {
            throw new IllegalArgumentException("Can't find notification '" + id + "'");
        }
        String enablePopupKey = NOTIFICATIONS_SETTINGS_PREFIX + id + NOTIFICATIONS_KEY_ENABLE_POPUP;
        String enableSoundKey = NOTIFICATIONS_SETTINGS_PREFIX + id + NOTIFICATIONS_KEY_ENABLE_SOUND;
        String soundFileKey = NOTIFICATIONS_SETTINGS_PREFIX + id + NOTIFICATIONS_KEY_SOUND_FILE;
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        preferences.setDefault(enablePopupKey, true);
        preferences.setDefault(enableSoundKey, notification.isSoundEnabled());
        NotificationSettings settings = new NotificationSettings();
        settings.setShowPopup(preferences.getBoolean(enablePopupKey));
        settings.setPlaySound(preferences.getBoolean(enableSoundKey));
        settings.setSoundFile(CommonUtils.isEmpty((String)preferences.getString(soundFileKey)) ? null : new File(preferences.getString(soundFileKey)));
        return settings;
    }

    public static void setNotificationSettings(@NotNull String id, @NotNull NotificationSettings settings) {
        NotificationDescriptor notification = NotificationRegistry.getInstance().getNotification(id);
        if (notification == null) {
            throw new IllegalArgumentException("Can't find notification '" + id + "'");
        }
        String enablePopupKey = NOTIFICATIONS_SETTINGS_PREFIX + id + NOTIFICATIONS_KEY_ENABLE_POPUP;
        String enableSoundKey = NOTIFICATIONS_SETTINGS_PREFIX + id + NOTIFICATIONS_KEY_ENABLE_SOUND;
        String soundFileKey = NOTIFICATIONS_SETTINGS_PREFIX + id + NOTIFICATIONS_KEY_SOUND_FILE;
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        preferences.setDefault(enablePopupKey, true);
        preferences.setDefault(enableSoundKey, notification.isSoundEnabled());
        preferences.setValue(enablePopupKey, settings.isShowPopup());
        preferences.setValue(enableSoundKey, settings.isPlaySound());
        preferences.setValue(soundFileKey, settings.getSoundFile() == null ? "" : settings.getSoundFile().toString());
    }

    private static boolean isPopupEnabled(@NotNull String id) {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("notifications.enabled") && NotificationUtils.getNotificationSettings(id).isShowPopup();
    }

    private static boolean isSoundEnabled(@NotNull String id) {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("notifications.enabled") && NotificationUtils.getNotificationSettings(id).isPlaySound();
    }

    @Nullable
    private static NotificationSoundProvider getNotificationSoundProvider(@NotNull String id) {
        NotificationSettings settings = NotificationUtils.getNotificationSettings(id);
        if (!settings.isPlaySound()) {
            return null;
        }
        if (settings.getSoundFile() == null) {
            return BeepSoundProvider.INSTANCE;
        }
        return new FileSoundProvider(settings.getSoundFile());
    }

    private static void scheduleNotificationSound(@NotNull NotificationSoundProvider provider) {
        NotificationSound sound;
        try {
            sound = provider.create();
        }
        catch (DBException e) {
            log.debug((Object)"Unable to play notification sound", (Throwable)e);
            return;
        }
        AbstractJob job = new AbstractJob("Play notification sound"){

            protected IStatus run(DBRProgressMonitor monitor) {
                sound.play(DBWorkbench.getPlatform().getPreferenceStore().getFloat("notifications.soundVolume") / 100.0f);
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                sound.close();
            }
        });
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }
}

