/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ui.UIUtils;

public class CComboContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    private static final boolean COMPUTE_TEXT_USING_CLIENTAREA = !Util.isCarbon();

    public String getControlContents(Control control) {
        return ((CCombo)control).getText();
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        ((CCombo)control).setText(text);
        ((CCombo)control).setSelection(new Point(cursorPosition, cursorPosition));
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        CCombo combo = (CCombo)control;
        combo.setText(text);
        combo.setSelection(new Point(0, text.length()));
    }

    public int getCursorPosition(Control control) {
        return ((CCombo)control).getSelection().x;
    }

    public Rectangle getInsertionBounds(Control control) {
        CCombo combo = (CCombo)control;
        int position = combo.getSelection().y;
        String contents = combo.getText();
        Point extent = UIUtils.getTextSize((Control)combo, contents.substring(0, Math.min(position, contents.length())));
        if (COMPUTE_TEXT_USING_CLIENTAREA) {
            return new Rectangle(combo.getClientArea().x + extent.x, combo.getClientArea().y, 1, combo.getClientArea().height);
        }
        return new Rectangle(extent.x, 0, 1, combo.getSize().y);
    }

    public void setCursorPosition(Control control, int index) {
        ((CCombo)control).setSelection(new Point(index, index));
    }

    public Point getSelection(Control control) {
        return ((CCombo)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((CCombo)control).setSelection(range);
    }
}

