/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tasks;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.tasks.DB2TableTruncateOptions;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;

public class DB2ToolTableTruncateSettings
extends SQLToolExecuteSettings<DB2TableBase> {
    private static final String[] storageOptions = new String[]{DB2TableTruncateOptions.dropStorage.getDesc(), DB2TableTruncateOptions.reuseStorage.getDesc()};
    private static final String[] triggerOptions = new String[]{DB2TableTruncateOptions.ignoreDeleteTriggers.getDesc(), DB2TableTruncateOptions.restrictWhenDeleteTriggers.getDesc()};
    private String storageOption;
    private String triggerOption;

    @Property(viewable=true, editable=true, updatable=true, order=1, listProvider=CheckStorageOptionListProvider.class)
    public String getStorageOption() {
        if (this.storageOption == null) {
            this.storageOption = DB2TableTruncateOptions.getOption(storageOptions[0]).getDesc();
        }
        return this.storageOption;
    }

    public void setStorageOption(String storageOption) {
        this.storageOption = storageOption;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2, listProvider=CheckTriggersOptionListProvider.class)
    public String getTriggerOption() {
        if (this.triggerOption == null) {
            this.triggerOption = DB2TableTruncateOptions.getOption(triggerOptions[0]).getDesc();
        }
        return this.triggerOption;
    }

    public void setTriggerOption(String storageOption) {
        this.triggerOption = storageOption;
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        super.loadConfiguration(runnableContext, config, project);
        this.storageOption = JSONUtils.getString(config, (String)"storage_option");
        this.triggerOption = JSONUtils.getString(config, (String)"trigger_option");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("storage_option", this.storageOption);
        config.put("trigger_option", this.triggerOption);
    }

    public static class CheckStorageOptionListProvider
    implements IPropertyValueListProvider<DB2ToolTableTruncateSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(DB2ToolTableTruncateSettings object) {
            return storageOptions;
        }
    }

    public static class CheckTriggersOptionListProvider
    implements IPropertyValueListProvider<DB2ToolTableTruncateSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(DB2ToolTableTruncateSettings object) {
            return triggerOptions;
        }
    }
}

