/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterString;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class BinaryAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(BinaryAttributeTransformer.class);
    private static final String PROP_FORMAT = "format";
    private static final String PROP_ENCODING = "encoding";
    private static final String FORMAT_NATIVE = "native";
    private static final String FORMAT_HEX = "hex";

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        Charset charset;
        DBPDataSource dataSource = session.getDataSource();
        String formatterId = CommonUtils.toString((Object)options.get(PROP_FORMAT), (String)FORMAT_HEX);
        DBDBinaryFormatter formatter = FORMAT_NATIVE.equals(formatterId) ? dataSource.getSQLDialect().getNativeBinaryFormatter() : DBValueFormatting.getBinaryPresentation(formatterId);
        if (formatter == null) {
            formatter = new BinaryFormatterString();
        }
        String encodingName = CommonUtils.toString((Object)options.get(PROP_ENCODING), (String)GeneralUtils.UTF8_ENCODING);
        try {
            charset = Charset.forName(encodingName);
        }
        catch (Exception e) {
            log.warn(e);
            charset = Charset.defaultCharset();
        }
        attribute.setTransformHandler(new BinaryValueHandler(attribute.getValueHandler(), charset, formatter));
    }

    private class BinaryValueHandler
    extends ProxyValueHandler {
        private final Charset charset;
        private final DBDBinaryFormatter formatter;

        public BinaryValueHandler(DBDValueHandler target, Charset charset, DBDBinaryFormatter formatter) {
            super(target);
            this.charset = charset;
            this.formatter = formatter;
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (value == null) {
                return super.getValueDisplayString(column, null, format);
            }
            ByteBuffer bb = this.charset.encode(CommonUtils.toString((Object)value));
            byte[] bytes = bb.array();
            return this.formatter.toString(bytes, 0, bytes.length);
        }
    }
}

