/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.config;

import java.math.BigDecimal;
import java.util.Locale;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConsumerGroup;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class ExasolConsumerGroupDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ExasolConsumerGroupDialog.class);
    private String name = "";
    private BigDecimal cpuWeight = null;
    private String comment = "";
    private ExasolConsumerGroup group;
    private Text precedenceText;
    private Text userRamLimitText;
    private Text groupRamLimitText;
    private Text sessionRamLimitText;

    public ExasolConsumerGroupDialog(Shell parentShell, ExasolConsumerGroup group) {
        super(parentShell, ExasolMessages.dialog_create_consumer_group, null);
        this.group = group;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 250;
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        Text nameText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_name, (String)"");
        Text cpuWeightText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_cpu_weight, (String)"");
        this.precedenceText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_precedence, (String)"");
        this.userRamLimitText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_user_limit, (String)"");
        this.groupRamLimitText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_group_limit, (String)"");
        this.sessionRamLimitText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_session_limit, (String)"");
        cpuWeightText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.userRamLimitText.addVerifyListener(UIUtils.getUnsignedLongOrEmptyTextVerifyListener((Text)this.userRamLimitText));
        this.groupRamLimitText.addVerifyListener(UIUtils.getUnsignedLongOrEmptyTextVerifyListener((Text)this.groupRamLimitText));
        this.sessionRamLimitText.addVerifyListener(UIUtils.getUnsignedLongOrEmptyTextVerifyListener((Text)this.sessionRamLimitText));
        this.precedenceText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        Text commentText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_priority_group_description, (String)"");
        ModifyListener mod = e -> {
            this.name = nameText.getText();
            try {
                this.cpuWeight = new BigDecimal(cpuWeightText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                log.debug((Object)("Can't format to number " + cpuWeightText.getText()));
            }
            this.comment = commentText.getText();
            Button button = this.getButton(0);
            if (button != null) {
                if (this.name.isEmpty() | this.cpuWeight == null) {
                    button.setEnabled(false);
                } else {
                    button.setEnabled(true);
                }
            }
        };
        nameText.addModifyListener(mod);
        commentText.addModifyListener(mod);
        cpuWeightText.addModifyListener(mod);
        return composite;
    }

    public String getName() {
        return this.name;
    }

    private int getCpuWeight() {
        return this.cpuWeight.intValue();
    }

    private String getComment() {
        return this.comment;
    }

    private BigDecimal getUserRamLimit() {
        String text = this.userRamLimitText.getText();
        return CommonUtils.isNotEmpty((String)text) ? new BigDecimal(text) : null;
    }

    private BigDecimal getGroupRamLimit() {
        String text = this.groupRamLimitText.getText();
        return CommonUtils.isNotEmpty((String)text) ? new BigDecimal(text) : null;
    }

    private BigDecimal getSessionRamLimit() {
        String text = this.sessionRamLimitText.getText();
        return CommonUtils.isNotEmpty((String)text) ? new BigDecimal(text) : null;
    }

    private Integer getPrecedence() {
        String text = this.precedenceText.getText();
        return CommonUtils.isNotEmpty((String)text) ? Integer.valueOf(CommonUtils.toInt((Object)text)) : null;
    }

    protected void okPressed() {
        this.group.setCpuWeight(this.getCpuWeight());
        this.group.setDescription(this.getComment());
        this.group.setGroupRamLimit(this.getGroupRamLimit());
        this.group.setName(this.getName());
        this.group.setPrecedence(this.getPrecedence());
        this.group.setSessionRamLimit(this.getSessionRamLimit());
        this.group.setUserRamLimit(this.getUserRamLimit());
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(false);
        }
    }
}

