/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.GeometryCollection;
import org.cugos.wkg.LineString;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.MultiLineString;
import org.cugos.wkg.MultiPoint;
import org.cugos.wkg.MultiPolygon;
import org.cugos.wkg.Point;
import org.cugos.wkg.Polygon;
import org.cugos.wkg.Reader;
import org.cugos.wkg.internal.JSONBaseListener;
import org.cugos.wkg.internal.JSONLexer;
import org.cugos.wkg.internal.JSONParser;

public class GeoJSONReader
implements Reader<String> {
    private final String srid = "4326";

    @Override
    public Geometry read(String jsonStr) {
        JSON json = this.parse(jsonStr);
        Geometry geometry = null;
        if (json instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)json;
            String type = jsonObject.get("type").toString();
            if (type.equalsIgnoreCase("feature")) {
                geometry = this.readGeometry((JSONObject)jsonObject.get("geometry")).setData(((JSONObject)jsonObject.get("properties")).values());
            } else if (type.equalsIgnoreCase("featurecollection")) {
                JSONArray jsonArray = (JSONArray)jsonObject.get("features");
                ArrayList<Geometry> geometries = new ArrayList<Geometry>();
                for (Object feature : jsonArray.values()) {
                    JSONObject featureJSONObject = (JSONObject)feature;
                    JSONObject geometryJSONObject = (JSONObject)featureJSONObject.get("geometry");
                    geometries.add(this.readGeometry(geometryJSONObject).setData(((JSONObject)featureJSONObject.get("properties")).values()));
                }
                geometry = new GeometryCollection((List<Geometry>)geometries, geometries.isEmpty() ? Dimension.Two : ((Geometry)geometries.get(0)).getDimension(), "4326");
            } else {
                geometry = this.readGeometry(jsonObject);
            }
        }
        return geometry;
    }

    @Override
    public String getName() {
        return "GeoJSON";
    }

    private Point readPoint(JSONObject jsonObject) {
        Coordinate coordinate = this.getCoordinate((JSONArray)jsonObject.get("coordinates"));
        return new Point(coordinate, coordinate.getDimension(), "4326");
    }

    private LineString readLineString(JSONObject jsonObject) {
        List<Coordinate> coordinates;
        return new LineString(coordinates, (coordinates = this.getCoordinates((JSONArray)jsonObject.get("coordinates"))).size() > 0 ? coordinates.get(0).getDimension() : Dimension.Two, "4326");
    }

    private Polygon readPolygon(JSONObject jsonObject) {
        List<List<Coordinate>> coordinateSets = this.getCoordinateSets((JSONArray)jsonObject.get("coordinates"));
        if (coordinateSets.size() > 0) {
            LinearRing exteriorRing = this.getLinearRing(coordinateSets.get(0));
            ArrayList<LinearRing> interiorRings = new ArrayList<LinearRing>();
            for (List<Coordinate> coordinates : coordinateSets.subList(1, coordinateSets.size())) {
                interiorRings.add(this.getLinearRing(coordinates));
            }
            return new Polygon(exteriorRing, interiorRings, exteriorRing.getDimension(), "4326");
        }
        return Polygon.createEmpty();
    }

    private MultiPoint readMultiPoint(JSONObject jsonObject) {
        List<Point> points;
        return new MultiPoint(points, (points = this.getPoints((JSONArray)jsonObject.get("coordinates"))).size() > 0 ? points.get(0).getDimension() : Dimension.Two, "4326");
    }

    private MultiLineString readMultiLineString(JSONObject jsonObject) {
        JSONArray coordinates = (JSONArray)jsonObject.get("coordinates");
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (Object coords : coordinates.values()) {
            List<Coordinate> c;
            lineStrings.add(new LineString(c, (c = this.getCoordinates((JSONArray)coords)).size() > 0 ? c.get(0).getDimension() : Dimension.Two, "4326"));
        }
        return new MultiLineString((List<LineString>)lineStrings, lineStrings.size() > 0 ? ((LineString)lineStrings.get(0)).getDimension() : Dimension.Two, "4326");
    }

    private MultiPolygon readMultiPolygon(JSONObject jsonObject) {
        JSONArray coordinates = (JSONArray)jsonObject.get("coordinates");
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Object polygonsCoords : coordinates.values()) {
            List<List<Coordinate>> coordinateSets = this.getCoordinateSets((JSONArray)polygonsCoords);
            if (coordinateSets.size() > 0) {
                LinearRing exteriorRing = this.getLinearRing(coordinateSets.get(0));
                ArrayList<LinearRing> interiorRings = new ArrayList<LinearRing>();
                for (List<Coordinate> coords : coordinateSets.subList(1, coordinateSets.size())) {
                    interiorRings.add(this.getLinearRing(coords));
                }
                polygons.add(new Polygon(exteriorRing, interiorRings, exteriorRing.getDimension(), "4326"));
                continue;
            }
            polygons.add(Polygon.createEmpty());
        }
        return new MultiPolygon((List<Polygon>)polygons, polygons.size() > 0 ? ((Polygon)polygons.get(0)).getDimension() : Dimension.Two, "4326");
    }

    private GeometryCollection readGeometryCollection(JSONObject jsonObject) {
        JSONArray geometriesJsonArray = (JSONArray)jsonObject.get("geometries");
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Object geometryJsonObject : geometriesJsonArray.values()) {
            geometries.add(this.readGeometry((JSONObject)geometryJsonObject));
        }
        return new GeometryCollection((List<Geometry>)geometries, geometries.size() > 0 ? ((Geometry)geometries.get(0)).getDimension() : Dimension.Two, "4326");
    }

    private Geometry readGeometry(JSONObject jsonObject) {
        String type = (String)jsonObject.get("type");
        Geometry geometry = null;
        if (type != null) {
            if (type.equalsIgnoreCase("point")) {
                geometry = this.readPoint(jsonObject);
            } else if (type.equalsIgnoreCase("LineString")) {
                geometry = this.readLineString(jsonObject);
            } else if (type.equalsIgnoreCase("Polygon")) {
                geometry = this.readPolygon(jsonObject);
            } else if (type.equalsIgnoreCase("MultiPoint")) {
                geometry = this.readMultiPoint(jsonObject);
            } else if (type.equalsIgnoreCase("MultiLineString")) {
                geometry = this.readMultiLineString(jsonObject);
            } else if (type.equalsIgnoreCase("MultiPolygon")) {
                geometry = this.readMultiPolygon(jsonObject);
            } else if (type.equalsIgnoreCase("GeometryCollection")) {
                geometry = this.readGeometryCollection(jsonObject);
            }
        }
        return geometry;
    }

    private LinearRing getLinearRing(List<Coordinate> coordinates) {
        return new LinearRing(coordinates, coordinates.size() > 0 ? coordinates.get(0).getDimension() : Dimension.Two, "4326");
    }

    private Coordinate getCoordinate(JSONArray jsonArray) {
        if (jsonArray.values().size() > 2) {
            return Coordinate.create3D(this.getDouble(jsonArray.get(0)), this.getDouble(jsonArray.get(1)), this.getDouble(jsonArray.get(2)));
        }
        if (jsonArray.values().size() == 2) {
            return Coordinate.create2D(this.getDouble(jsonArray.get(0)), this.getDouble(jsonArray.get(1)));
        }
        return Coordinate.createEmpty();
    }

    private Double getDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value != null) {
            return Double.parseDouble(value.toString());
        }
        return Double.NaN;
    }

    private List<Coordinate> getCoordinates(JSONArray jsonArray) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Object value : jsonArray.values()) {
            if (!(value instanceof JSONArray)) continue;
            coordinates.add(this.getCoordinate((JSONArray)value));
        }
        return coordinates;
    }

    private List<Point> getPoints(JSONArray jsonArray) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Object value : jsonArray.values()) {
            if (!(value instanceof JSONArray)) continue;
            Coordinate coordinate = this.getCoordinate((JSONArray)value);
            points.add(new Point(coordinate, coordinate.getDimension()));
        }
        return points;
    }

    private List<List<Coordinate>> getCoordinateSets(JSONArray jsonArray) {
        ArrayList<List<Coordinate>> coordinateSets = new ArrayList<List<Coordinate>>();
        for (Object value : jsonArray.values()) {
            if (!(value instanceof JSONArray)) continue;
            coordinateSets.add(this.getCoordinates((JSONArray)value));
        }
        return coordinateSets;
    }

    private JSON parse(String jsonStr) {
        JSONLexer lexer = new JSONLexer((CharStream)new ANTLRInputStream(jsonStr));
        JSONParser parser = new JSONParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, (Throwable)e);
            }
        });
        final Stack json = new Stack();
        parser.addParseListener(new JSONBaseListener(){

            @Override
            public void enterObj(JSONParser.ObjContext ctx) {
                json.push(new JSONObject());
            }

            @Override
            public void exitPair(JSONParser.PairContext ctx) {
                Object value = this.getValueFromValueContent(ctx.value());
                JSONObject jsonObject = (JSONObject)json.peek();
                jsonObject.values().put(this.removeDoubleQuotes(ctx.STRING().getText()), value);
            }

            @Override
            public void enterArray(JSONParser.ArrayContext ctx) {
                json.push(new JSONArray());
            }

            @Override
            public void exitArray(JSONParser.ArrayContext ctx) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (JSONParser.ValueContext valueContext : ctx.value()) {
                    Object value = this.getValueFromValueContent(valueContext);
                    if (value instanceof JSON) {
                        values.add(0, value);
                        continue;
                    }
                    values.add(value);
                }
                JSONArray jsonArray = (JSONArray)json.peek();
                jsonArray.values().addAll(values);
            }

            private String removeDoubleQuotes(String str) {
                if (str != null) {
                    return str.replaceAll("\"", "");
                }
                return null;
            }

            private Number parseNumber(String value) {
                if (value.contains(".")) {
                    return Double.parseDouble(value);
                }
                return Integer.parseInt(value);
            }

            private Object getValueFromValueContent(JSONParser.ValueContext ctx) {
                if (ctx.obj() != null) {
                    return json.pop();
                }
                if (ctx.array() != null) {
                    return json.pop();
                }
                if (ctx.STRING() != null) {
                    return this.removeDoubleQuotes(ctx.STRING().getText());
                }
                if (ctx.NUMBER() != null) {
                    return this.parseNumber(this.removeDoubleQuotes(ctx.NUMBER().getText()));
                }
                return null;
            }
        });
        parser.json();
        return (JSON)json.pop();
    }

    private static interface JSON {
    }

    private static class JSONObject
    implements JSON {
        private Map<String, Object> values = new LinkedHashMap<String, Object>();

        private JSONObject() {
        }

        public Map<String, Object> values() {
            return this.values;
        }

        public Object get(String key) {
            return this.values.get(key);
        }

        public String toString() {
            return this.values.toString();
        }
    }

    private static class JSONArray
    implements JSON {
        private List<Object> values = new ArrayList<Object>();

        private JSONArray() {
        }

        public List<Object> values() {
            return this.values;
        }

        public Object get(int index) {
            return this.values.get(index);
        }

        public String toString() {
            return this.values.toString();
        }
    }
}

