/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class VerticaTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn> {
    private final SQLTableColumnManager.ColumnModifier<GenericTableColumn> VerticaDataTypeModifier = (monitor, column, sql, command) -> {
        sql.append(" SET DATA TYPE ");
        this.DataTypeModifier.appendModifier(monitor, column, sql, command);
    };
    private final SQLTableColumnManager.ColumnModifier<GenericTableColumn> VerticaDefaultModifier = (monitor, column, sql, command) -> {
        if (CommonUtils.isEmpty((String)((GenericTableColumn)command.getObject()).getDefaultValue())) {
            sql.append(" DROP DEFAULT");
        } else {
            sql.append(" SET DEFAULT ");
            this.DefaultModifier.appendModifier(monitor, column, sql, command);
        }
    };
    private final SQLTableColumnManager.ColumnModifier<GenericTableColumn> VerticaNotNullModifier = (monitor, column, sql, command) -> {
        if (((GenericTableColumn)command.getObject()).isRequired()) {
            sql.append(" SET NOT NULL");
        } else {
            sql.append(" DROP NOT NULL");
        }
    };
    private final SQLTableColumnManager.ColumnModifier<GenericTableColumn> IncrementModifier = (monitor, column, sql, command) -> {
        if (column.isAutoIncrement()) {
            sql.append(" IDENTITY");
        }
    };

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column, Map<String, Object> options) {
        if (column.isAutoIncrement() && !column.isPersisted()) {
            return new SQLTableColumnManager.ColumnModifier[]{this.IncrementModifier, this.NotNullModifier};
        }
        if (column.isPersisted()) {
            return new SQLTableColumnManager.ColumnModifier[]{this.VerticaDataTypeModifier, this.VerticaDefaultModifier, this.VerticaNotNullModifier};
        }
        return super.getSupportedModifiers(column, options);
    }

    public void addIncrementClauseToNestedDeclaration(DBECommandAbstract<GenericTableColumn> command, StringBuilder decl) {
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        String prefix = "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String typeClause = column.getFullTypeName();
        if (command.getProperty((Object)"typeName") != null || command.getProperty((Object)"maxLength") != null || command.getProperty((Object)"precision") != null || command.getProperty((Object)"scale") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column type", prefix + "SET DATA TYPE " + typeClause));
        }
        if (command.getProperty((Object)"required") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column nullability", prefix + (column.isRequired() ? "SET" : "DROP") + " NOT NULL"));
        }
        if (command.getProperty((Object)"defaultValue") != null) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop column default", prefix + "DROP DEFAULT"));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column default", prefix + "SET DEFAULT " + column.getDefaultValue()));
            }
        }
        super.addObjectModifyActions(monitor, executionContext, actionList, command, options);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((GenericTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

