/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.prop.DBECommandProperty;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyHandler;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.utils.CommonUtils;

public class ControlPropertyCommandListener<OBJECT_TYPE extends DBSObject> {
    private static final Log log = Log.getLog(ControlPropertyCommandListener.class);
    private final AbstractDatabaseObjectEditor<OBJECT_TYPE> objectEditor;
    private final Widget widget;
    private final DBEPropertyHandler<OBJECT_TYPE> handler;
    private Object originalValue;
    private DBECommandProperty<OBJECT_TYPE> curCommand;
    private boolean changingValue = false;

    public static <OBJECT_TYPE extends DBSObject> void create(AbstractDatabaseObjectEditor<OBJECT_TYPE> objectEditor, Widget widget, DBEPropertyHandler<OBJECT_TYPE> handler) {
        new ControlPropertyCommandListener<OBJECT_TYPE>(objectEditor, widget, handler);
    }

    public ControlPropertyCommandListener(AbstractDatabaseObjectEditor<OBJECT_TYPE> objectEditor, Widget widget, DBEPropertyHandler<OBJECT_TYPE> handler) {
        this.objectEditor = objectEditor;
        this.widget = widget;
        this.handler = handler;
        WidgetListener listener = new WidgetListener();
        widget.addListener(15, (Listener)listener);
        widget.addListener(16, (Listener)listener);
        widget.addListener(24, (Listener)listener);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
    }

    private Object readWidgetValue() {
        if (this.widget == null || this.widget.isDisposed()) {
            return null;
        }
        if (this.widget instanceof Text) {
            return ((Text)this.widget).getText();
        }
        if (this.widget instanceof Combo) {
            return ((Combo)this.widget).getText();
        }
        if (this.widget instanceof Button) {
            return ((Button)this.widget).getSelection();
        }
        if (this.widget instanceof Spinner) {
            return ((Spinner)this.widget).getSelection();
        }
        if (this.widget instanceof List) {
            return ((List)this.widget).getSelection();
        }
        if (this.widget instanceof DateTime) {
            DateTime dateTime = (DateTime)this.widget;
            Calendar cl = Calendar.getInstance();
            cl.set(1, dateTime.getYear());
            cl.set(2, dateTime.getMonth());
            cl.set(5, dateTime.getDay());
            cl.set(11, dateTime.getHours());
            cl.set(12, dateTime.getMinutes());
            cl.set(13, dateTime.getSeconds());
            cl.set(14, 0);
            return cl.getTime();
        }
        log.warn((Object)("Control " + String.valueOf(this.widget) + " is not supported"));
        return null;
    }

    private void writeWidgetValue(Object value) {
        if (this.widget == null || this.widget.isDisposed()) {
            return;
        }
        this.changingValue = true;
        try {
            if (this.widget instanceof Text) {
                ((Text)this.widget).setText(CommonUtils.toString((Object)value));
            } else if (this.widget instanceof Combo) {
                ((Combo)this.widget).setText(CommonUtils.toString((Object)value));
            } else if (this.widget instanceof Button) {
                ((Button)this.widget).setSelection(value != null && Boolean.TRUE.equals(value));
            } else if (this.widget instanceof Spinner) {
                ((Spinner)this.widget).setSelection(CommonUtils.toInt((Object)value));
            } else if (this.widget instanceof List) {
                ((List)this.widget).setSelection((String[])value);
            } else if (this.widget instanceof DateTime) {
                DateTime dateTime = (DateTime)this.widget;
                Calendar cl = Calendar.getInstance();
                cl.setTime((Date)value);
                dateTime.setYear(cl.get(1));
                dateTime.setMonth(cl.get(2));
                dateTime.setDay(cl.get(5));
                dateTime.setHours(cl.get(11));
                dateTime.setMinutes(cl.get(12));
                dateTime.setSeconds(cl.get(13));
            } else {
                log.warn((Object)("Control " + String.valueOf(this.widget) + " is not supported"));
            }
        }
        finally {
            this.changingValue = false;
        }
    }

    private class WidgetListener
    implements Listener {
        private WidgetListener() {
        }

        public void handleEvent(Event event) {
            if (ControlPropertyCommandListener.this.changingValue) {
                return;
            }
            switch (event.type) {
                case 15: {
                    ControlPropertyCommandListener.this.originalValue = ControlPropertyCommandListener.this.readWidgetValue();
                    break;
                }
                case 16: {
                    if (ControlPropertyCommandListener.this.curCommand == null) break;
                    ControlPropertyCommandListener.this.curCommand = null;
                    break;
                }
                case 24: {
                    Object newValue = ControlPropertyCommandListener.this.readWidgetValue();
                    DBECommandReflector commandReflector = new DBECommandReflector<OBJECT_TYPE, DBECommandProperty<OBJECT_TYPE>>(){

                        public void redoCommand(DBECommandProperty<OBJECT_TYPE> command) {
                            ControlPropertyCommandListener.this.writeWidgetValue(command.getNewValue());
                        }

                        public void undoCommand(DBECommandProperty<OBJECT_TYPE> command) {
                            ControlPropertyCommandListener.this.writeWidgetValue(command.getOldValue());
                        }
                    };
                    if (ControlPropertyCommandListener.this.curCommand == null) {
                        if (CommonUtils.equalObjects((Object)newValue, (Object)ControlPropertyCommandListener.this.originalValue)) break;
                        ControlPropertyCommandListener.this.curCommand = new DBECommandProperty(ControlPropertyCommandListener.this.objectEditor.getDatabaseObject(), ControlPropertyCommandListener.this.handler, ControlPropertyCommandListener.this.originalValue, newValue);
                        ControlPropertyCommandListener.this.objectEditor.addChangeCommand(ControlPropertyCommandListener.this.curCommand, commandReflector);
                        break;
                    }
                    if (CommonUtils.equalObjects((Object)ControlPropertyCommandListener.this.originalValue, (Object)newValue)) {
                        ControlPropertyCommandListener.this.objectEditor.removeChangeCommand(ControlPropertyCommandListener.this.curCommand);
                        ControlPropertyCommandListener.this.curCommand = null;
                        break;
                    }
                    ControlPropertyCommandListener.this.curCommand.setNewValue(newValue);
                    ControlPropertyCommandListener.this.objectEditor.updateChangeCommand(ControlPropertyCommandListener.this.curCommand, commandReflector);
                }
            }
        }
    }
}

