/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeChangeListener;

public abstract class AbstractSynchronizationScope
implements ISynchronizationScope {
    private final ListenerList<ISynchronizationScopeChangeListener> listeners = new ListenerList(1);

    @Override
    public IResource[] getRoots() {
        ResourceTraversal[] traversals;
        ArrayList<IResource> result = new ArrayList<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals = this.getTraversals();
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] resources;
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] iResourceArray = resources = traversal.getResources();
            int n3 = resources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resource = iResourceArray[n4];
                this.accumulateRoots(result, resource);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    @Override
    public boolean contains(IResource resource) {
        ResourceTraversal[] traversals;
        ResourceTraversal[] resourceTraversalArray = traversals = this.getTraversals();
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            if (traversal.contains(resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void accumulateRoots(List<IResource> roots, IResource resource) {
        IPath resourcePath = resource.getFullPath();
        Iterator<IResource> iter = roots.iterator();
        while (iter.hasNext()) {
            IResource root = iter.next();
            IPath rootPath = root.getFullPath();
            if (rootPath.isPrefixOf(resourcePath)) {
                return;
            }
            if (!resourcePath.isPrefixOf(rootPath)) continue;
            iter.remove();
        }
        roots.add(resource);
    }

    public void fireTraversalsChangedEvent(final ResourceTraversal[] newTraversals, final ResourceMapping[] newMappings) {
        Object[] allListeners;
        Object[] objectArray = allListeners = this.listeners.getListeners();
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((ISynchronizationScopeChangeListener)listener).scopeChanged(AbstractSynchronizationScope.this, newMappings, newTraversals);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    @Override
    public void addScopeChangeListener(ISynchronizationScopeChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeScopeChangeListener(ISynchronizationScopeChangeListener listener) {
        this.listeners.remove((Object)listener);
    }
}

