/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBNProjectDesktop
extends DBNProject {
    private static final Log log = Log.getLog(DBNProjectDesktop.class);
    private final DBPResourceHandler handler;

    public DBNProjectDesktop(DBNNode parentNode, RCPProject project, DBPResourceHandler handler) {
        super(parentNode, (DBPProject)project);
        this.handler = handler;
    }

    @NotNull
    public RCPProject getProject() {
        return (RCPProject)super.getProject();
    }

    private IProject getEclipseProject() {
        return this.getProject().getEclipseProject();
    }

    public String getNodeDescription() {
        IProject iProject = this.getEclipseProject();
        if (iProject != null) {
            this.getProject().ensureOpen();
            try {
                return iProject.getDescription().getComment();
            }
            catch (CoreException e) {
                log.debug((Object)e);
                return null;
            }
        }
        return super.getNodeDescription();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IResource.class) {
            return adapter.cast(this.getEclipseProject());
        }
        return (T)super.getAdapter(adapter);
    }

    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        GeneralUtils.validateResourceNameUnconditionally((String)newName);
        RCPProject project = this.getProject();
        project.ensureOpen();
        try {
            IProject eclipseProject = project.getEclipseProject();
            if (eclipseProject == null) {
                throw new DBException("Eclipse project is null");
            }
            project.updateProject(newName, null);
            if (DBWorkbench.isDistributed()) {
                this.fireNodeEvent(new DBNEvent((Object)this, DBNEvent.Action.UPDATE, (DBNNode)this));
            } else {
                IProjectDescription description = eclipseProject.getDescription();
                description.setName(newName);
                eclipseProject.move(description, true, monitor.getNestedMonitor());
            }
        }
        catch (Exception e) {
            throw new DBException("Can't rename project: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void addProjectNodes(DBRProgressMonitor monitor, List<DBNNode> children) throws DBException {
        this.getProject().ensureOpen();
        children.addAll(List.of(DBNResource.readChildResourceNodes(monitor, (DBNNode)this)));
        super.addProjectNodes(monitor, children);
    }

    protected void filterChildren(List<DBNNode> children) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.folder.placeholders")) {
            children.removeIf(node -> node instanceof DBNResource && !((DBNResource)((Object)node)).isResourceExists());
        }
    }

    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        NavigatorResources.refreshThisResource(monitor, (DBNNode)this);
        return super.refreshNode(monitor, source);
    }
}

