/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.commands;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.ui.discovery.commands.Messages;
import org.eclipse.equinox.internal.p2.ui.discovery.repository.RepositoryDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;

public class ShowRepositoryCatalogCommandHandler
extends AbstractHandler {
    private static final String ID_PARAMETER_REPOSITORY = "org.eclipse.equinox.p2.ui.discovery.commands.RepositoryParameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        URI uri;
        String location = event.getParameter(ID_PARAMETER_REPOSITORY);
        if (location == null) {
            throw new ExecutionException(NLS.bind((String)Messages.ShowRepositoryCatalogCommandHandler_Required_parameter_not_specified_Error, (Object)ID_PARAMETER_REPOSITORY));
        }
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(Messages.ShowRepositoryCatalogCommandHandler_Location_not_valid_Error, (Throwable)e);
        }
        Catalog catalog = new Catalog();
        RepositoryDiscoveryStrategy strategy = new RepositoryDiscoveryStrategy();
        strategy.addLocation(uri);
        catalog.getDiscoveryStrategies().add(strategy);
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        CatalogConfiguration configuration = new CatalogConfiguration();
        configuration.setShowTagFilter(false);
        DiscoveryWizard wizard = new DiscoveryWizard(catalog, configuration);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        dialog.open();
        return null;
    }
}

