/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.server;

import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.app.DPIApplication;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.dpi.DPIController;
import org.jkiss.dbeaver.model.dpi.DPIDataSourceParameters;
import org.jkiss.dbeaver.model.dpi.DPISession;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerBuffer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceMemoryStorage;
import org.jkiss.dbeaver.registry.DataSourcePersistentRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.rest.RestServer;

public class DPIControllerImpl
implements DPIController {
    private static final Log log = Log.getLog(DPIControllerImpl.class);
    private final DPIContext context;
    private final Map<String, DPISession> sessions = new LinkedHashMap<String, DPISession>();
    private RestServer<?> server;

    public DPIControllerImpl(DPIContext context) {
        this.context = context;
    }

    public String ping() throws DBException {
        return "pong";
    }

    public DPISession openSession() {
        DPISession session = new DPISession(UUID.randomUUID().toString());
        this.sessions.put(session.getSessionId(), session);
        return session;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public synchronized DBPDataSource openDataSource(@NotNull DPIDataSourceParameters parameters) throws DBException {
        void persistentRegistry;
        DBPProject project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (project == null) {
            throw new DBException("Active project not found");
        }
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        if (!(registry instanceof DataSourcePersistentRegistry)) {
            throw new DBException("Cannot load datasource from " + registry.getClass().getName());
        }
        DataSourcePersistentRegistry dataSourcePersistentRegistry = (DataSourcePersistentRegistry)registry;
        DataSourceMemoryStorage storage = new DataSourceMemoryStorage(parameters.getContainerConfiguration().getBytes(StandardCharsets.UTF_8));
        DataSourceConfigurationManagerBuffer manager = new DataSourceConfigurationManagerBuffer();
        persistentRegistry.loadDataSources(List.of(storage), (DataSourceConfigurationManager)manager, List.of(), true, false);
        DBPDataSourceContainer dataSourceContainer = project.getDataSourceRegistry().getDataSources().stream().findFirst().orElse(null);
        if (dataSourceContainer == null) {
            throw new DBException("Data source not found");
        }
        ((DPIApplication)DPIApplication.getInstance()).addDriverLibsLocation(dataSourceContainer.getDriver().getId(), parameters.getDriverLibraries());
        LoggingProgressMonitor monitor = new LoggingProgressMonitor(log);
        ((DataSourceDescriptor)dataSourceContainer).openDataSource((DBRProgressMonitor)monitor, true);
        DBPDataSource dataSource = dataSourceContainer.getDataSource();
        return dataSource;
    }

    @NotNull
    public Object createDriverInstance(@NotNull DPIDataSourceParameters parameters) throws DBException {
        throw new DBException("Not implemented");
    }

    public void closeSession(@NotNull String sessionId) throws DBException {
        this.getSession(sessionId);
        this.sessions.remove(sessionId);
        if (this.sessions.isEmpty() && this.server != null) {
            new AbstractJob("Stop detached server"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    DPIControllerImpl.this.server.stop(1);
                    DPIControllerImpl.this.server = null;
                    return Status.OK_STATUS;
                }
            }.schedule(200L);
        }
    }

    public synchronized Object callMethod(@NotNull String objectId, @NotNull String method, @Nullable Object[] args) throws DBException {
        log.debug((Object)MessageFormat.format("Invoke method: {0} object: {1}", method, objectId));
        Object object = this.context.getObject(objectId);
        if (object == null) {
            throw new DBException("DPI object '" + objectId + "' not found");
        }
        Method[] methodArray = object.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method objMethod = methodArray[n2];
            if (objMethod.getName().equals(method)) {
                Object[] argTypes = objMethod.getParameterTypes();
                if (args != null && argTypes.length > 0 && argTypes.length != args.length && argTypes[0] == DBRProgressMonitor.class) {
                    Object[] modifiedArgs = new Object[args.length + 1];
                    modifiedArgs[0] = this.context.getProgressMonitor();
                    System.arraycopy(args, 0, modifiedArgs, 1, args.length);
                    args = modifiedArgs;
                }
                if (ArrayUtils.isEmpty((Object[])args) && ArrayUtils.isEmpty((Object[])argTypes) || args != null && argTypes.length == args.length) {
                    return this.invokeObjectMethod(object, objMethod, args);
                }
            }
            ++n2;
        }
        throw new DBException("Method '" + method + "' not found in DPI object '" + objectId + "'");
    }

    public Object readProperty(@NotNull String objectId, @NotNull String propertyName) throws DBException {
        Object object = this.context.getObject(objectId);
        if (object == null) {
            throw new DBException("DPI object '" + objectId + "' not found");
        }
        Method method = DBXTreeItem.findPropertyReadMethod(object.getClass(), (String)propertyName);
        if (method == null) {
            throw new DBException("Property '" + propertyName + "' not found in object '" + String.valueOf(object.getClass()) + "'");
        }
        return this.invokeObjectMethod(object, method, null);
    }

    private Object invokeObjectMethod(Object object, Method method, Object[] args) throws DBException {
        boolean originalAccessible = method.canAccess(object);
        method.setAccessible(true);
        try {
            log.debug((Object)("DPI Server: invoke DPI method " + String.valueOf(method) + " on " + String.valueOf(object.getClass())));
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (args == null) {
                if (parameterTypes.length == 1 && parameterTypes[0] == DBRProgressMonitor.class) {
                    args = new Object[]{this.context.getProgressMonitor()};
                }
                Object object2 = method.invoke(object, args);
                return object2;
            }
            Object[] realArgs = new Object[args.length];
            Gson gson = this.context.getGson();
            int i = 0;
            while (i < parameterTypes.length) {
                realArgs[i] = args[i] instanceof String && !CharSequence.class.isAssignableFrom(parameterTypes[i]) ? gson.fromJson((String)args[i], parameterTypes[i]) : (args[i] instanceof Map && !Map.class.isAssignableFrom(parameterTypes[i]) ? gson.fromJson(gson.toJsonTree(args[i], Map.class), parameterTypes[i]) : (args[i] instanceof Number ? gson.fromJson(gson.toJson(args[i], parameterTypes[i]), parameterTypes[i]) : args[i]));
                ++i;
            }
            Object object3 = method.invoke(object, realArgs);
            return object3;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new DBException("Error invoking DPI method " + String.valueOf(object.getClass()) + "#" + method.getName() + " : " + e.getMessage(), e);
        }
        finally {
            method.setAccessible(originalAccessible);
        }
    }

    private DPISession getSession(@NotNull String sessionId) throws DBException {
        DPISession session = this.sessions.get(sessionId);
        if (session == null) {
            throw new DBException("Session '" + sessionId + "' not found");
        }
        return session;
    }

    public void close() {
    }

    public void setServer(RestServer<?> server) {
        this.server = server;
    }

    public RestServer<?> getServer() {
        return this.server;
    }
}

