/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLVariable;

final class SQLVariableCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2 {
    private TemplateVariable variable;
    private String displayString;
    private String replacementString;
    private Position replacementPosition;
    private int cursorPosition;
    private Image image;
    private IContextInformation contextInformation;
    private String additionalProposalInfo;

    public SQLVariableCompletionProposal(TemplateVariable variable, String replacementString, Position replacementPosition, int cursorPosition) {
        this(variable, replacementString, replacementPosition, cursorPosition, null, null, null, null);
    }

    public SQLVariableCompletionProposal(TemplateVariable variable, String replacementString, Position replacementPosition, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementPosition != null ? 1 : 0) != 0);
        this.variable = variable;
        this.replacementString = replacementString;
        this.replacementPosition = replacementPosition;
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        SQLVariable sqlVariable;
        try {
            document.replace(this.replacementPosition.getOffset(), this.replacementPosition.getLength(), this.replacementString);
        }
        catch (BadLocationException badLocationException) {}
        if (this.variable instanceof SQLVariable && !this.replacementString.equals((sqlVariable = (SQLVariable)this.variable).getCurrentChoice())) {
            sqlVariable.setCurrentChoice(this.replacementString);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementPosition.getOffset() + this.cursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument());
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            String content = document.get(this.replacementPosition.getOffset(), offset - this.replacementPosition.getOffset());
            if (this.replacementString.startsWith(content)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

