/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.registry.SQLFormatterConfigurationRegistry;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewerConfiguration;

public class SQLFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final ISourceViewer sourceViewer;
    private final SQLEditorSourceViewerConfiguration svConfig;
    private final SQLSyntaxManager sqlSyntax;

    public SQLFormattingStrategy(ISourceViewer sourceViewer, SQLEditorSourceViewerConfiguration svConfig, SQLSyntaxManager syntax) {
        this.sourceViewer = sourceViewer;
        this.svConfig = svConfig;
        this.sqlSyntax = syntax;
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        String[] indentPrefixes = this.svConfig.getIndentPrefixes(this.sourceViewer, "__dftl_partition_content_type");
        SQLFormatterConfiguration configuration = new SQLFormatterConfiguration(this.svConfig.getSQLEditor().getDataSource(), this.sqlSyntax);
        configuration.setIndentString(indentPrefixes[0]);
        SQLFormatter formatter = SQLFormatterConfigurationRegistry.getInstance().createFormatter(configuration);
        if (formatter == null) {
            return content;
        }
        return formatter.format(content, configuration);
    }

    public void formatterStops() {
    }
}

