/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class WorkingSetManager
extends AbstractWorkingSetManager
implements IWorkingSetManager,
BundleListener {
    public static final String WORKING_SET_STATE_FILENAME = "workingsets.xml";
    private boolean restoreInProgress;
    private boolean savePending;

    public WorkingSetManager(BundleContext context) {
        super(context);
    }

    @Override
    public void addRecentWorkingSet(IWorkingSet workingSet) {
        this.internalAddRecentWorkingSet(workingSet);
        this.saveState();
    }

    @Override
    public void addWorkingSet(IWorkingSet workingSet) {
        super.addWorkingSet(workingSet);
        this.saveState();
    }

    private File getWorkingSetStateFile() {
        IPath path = WorkbenchPlugin.getDefault().getDataLocation();
        if (path == null) {
            return null;
        }
        path = path.append(WORKING_SET_STATE_FILENAME);
        return path.toFile();
    }

    @Override
    public void removeWorkingSet(IWorkingSet workingSet) {
        if (this.internalRemoveWorkingSet(workingSet)) {
            this.saveState();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreState() {
        block18: {
            block17: {
                File stateFile = this.getWorkingSetStateFile();
                if (stateFile == null) return;
                if (!stateFile.exists()) return;
                try {
                    try {
                        this.restoreInProgress = true;
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try {
                            FileInputStream input = new FileInputStream(stateFile);
                            try {
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));){
                                    XMLMemento memento = XMLMemento.createReadRoot(reader);
                                    this.restoreWorkingSetState(memento);
                                    this.restoreMruList(memento);
                                }
                                if (input == null) break block17;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (input == null) throw throwable;
                                input.close();
                                throw throwable;
                            }
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    catch (IOException | WorkbenchException e) {
                        this.handleInternalError((Exception)e, WorkbenchMessages.ProblemRestoringWorkingSetState_title, WorkbenchMessages.ProblemRestoringWorkingSetState_message);
                        this.restoreInProgress = false;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.restoreInProgress = false;
                    throw throwable;
                }
            }
            this.restoreInProgress = false;
        }
        if (!this.savePending) return;
        this.saveState();
        this.savePending = false;
    }

    private void saveState() {
        if (this.restoreInProgress) {
            this.savePending = true;
            return;
        }
        File stateFile = this.getWorkingSetStateFile();
        if (stateFile == null) {
            return;
        }
        try {
            this.saveState(stateFile);
        }
        catch (IOException e) {
            stateFile.delete();
            this.handleInternalError(e, WorkbenchMessages.ProblemSavingWorkingSetState_title, WorkbenchMessages.ProblemSavingWorkingSetState_message);
        }
    }

    @Override
    public void workingSetChanged(IWorkingSet changedWorkingSet, String propertyChangeId, Object oldValue) {
        this.saveState();
        super.workingSetChanged(changedWorkingSet, propertyChangeId, oldValue);
    }

    private void handleInternalError(Exception exp, String title, String message) {
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, message, (Throwable)exp);
        StatusAdapter sa = new StatusAdapter((IStatus)status);
        sa.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, title);
        StatusManager.getManager().handle(sa, 3);
    }

    @Override
    protected void restoreWorkingSetState(IMemento memento) {
        super.restoreWorkingSetState(memento);
        this.saveState();
    }
}

