/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.page;

import java.io.IOException;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.ILinkable;
import org.jacoco.report.internal.html.page.MethodItem;
import org.jacoco.report.internal.html.page.ReportPage;
import org.jacoco.report.internal.html.page.TablePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPage
extends TablePage<IClassCoverage> {
    private final ILinkable sourcePage;

    public ClassPage(IClassCoverage classNode, ReportPage parent, ILinkable sourcePage, ReportOutputFolder folder, IHTMLReportContext context) {
        super(classNode, parent, folder, context);
        this.sourcePage = sourcePage;
        context.getIndexUpdate().addClass(this, classNode.getId());
    }

    @Override
    protected String getOnload() {
        return "initialSort(['breadcrumb'])";
    }

    @Override
    public void render() throws IOException {
        for (IMethodCoverage m : ((IClassCoverage)this.getNode()).getMethods()) {
            String label = this.context.getLanguageNames().getMethodName(((IClassCoverage)this.getNode()).getName(), m.getName(), m.getDesc(), m.getSignature());
            this.addItem(new MethodItem(m, label, this.sourcePage));
        }
        super.render();
    }

    @Override
    protected String getFileName() {
        String vmname = ((IClassCoverage)this.getNode()).getName();
        int pos = vmname.lastIndexOf(47);
        String shortname = pos == -1 ? vmname : vmname.substring(pos + 1);
        return shortname + ".html";
    }

    @Override
    public String getLinkLabel() {
        return this.context.getLanguageNames().getClassName(((IClassCoverage)this.getNode()).getName(), ((IClassCoverage)this.getNode()).getSignature(), ((IClassCoverage)this.getNode()).getSuperName(), ((IClassCoverage)this.getNode()).getInterfaceNames());
    }

    @Override
    protected void content(HTMLElement body) throws IOException {
        String sourceFileName;
        if (((IClassCoverage)this.getNode()).isNoMatch()) {
            body.p().text("A different version of class was executed at runtime.");
        }
        if (((IClassCoverage)this.getNode()).getLineCounter().getTotalCount() == 0) {
            body.p().text("Class files must be compiled with debug information to show line coverage.");
        }
        if ((sourceFileName = ((IClassCoverage)this.getNode()).getSourceFileName()) == null) {
            body.p().text("Class files must be compiled with debug information to link with source files.");
        } else if (this.sourcePage == null) {
            String sourcePath = ((IClassCoverage)this.getNode()).getPackageName().length() != 0 ? ((IClassCoverage)this.getNode()).getPackageName() + "/" + sourceFileName : sourceFileName;
            body.p().text("Source file \"" + sourcePath + "\" was not found during generation of report.");
        }
        super.content(body);
    }
}

