/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class SingleTimeClassVisitor
implements ClassVisitor {
    private final ClassVisitor classVisitor;
    private Clazz lastVisitedClass;

    public SingleTimeClassVisitor(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (!programClass.equals(this.lastVisitedClass)) {
            this.classVisitor.visitProgramClass(programClass);
            this.lastVisitedClass = programClass;
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (!libraryClass.equals(this.lastVisitedClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
            this.lastVisitedClass = libraryClass;
        }
    }
}

