/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ProgramClass;
import proguard.util.ArrayUtil;

public class InterfacesEditor {
    private final ProgramClass targetClass;

    public InterfacesEditor(ProgramClass targetClass) {
        this.targetClass = targetClass;
    }

    public void addInterface(int interfaceConstantIndex) {
        if (this.findInterfaceIndex(interfaceConstantIndex) < 0) {
            this.targetClass.u2interfaces = ArrayUtil.add(this.targetClass.u2interfaces, this.targetClass.u2interfacesCount++, interfaceConstantIndex);
        }
    }

    public void deleteInterface(int interfaceConstantIndex) {
        int interfaceIndex = this.findInterfaceIndex(interfaceConstantIndex);
        if (interfaceIndex >= 0) {
            int interfacesCount = --this.targetClass.u2interfacesCount;
            int[] interfaces = this.targetClass.u2interfaces;
            for (int index = interfaceIndex; index < interfacesCount; ++index) {
                interfaces[index] = interfaces[index + 1];
            }
            interfaces[interfacesCount] = 0;
        }
    }

    private int findInterfaceIndex(int interfaceConstantIndex) {
        int interfacesCount = this.targetClass.u2interfacesCount;
        int[] interfaces = this.targetClass.u2interfaces;
        for (int index = 0; index < interfacesCount; ++index) {
            if (interfaces[index] != interfaceConstantIndex) continue;
            return index;
        }
        return -1;
    }
}

