# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AuthenticationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of possible authentication types when connecting
    """

    NONE = "None"
    WINDOWS_AUTHENTICATION = "WindowsAuthentication"
    SQL_AUTHENTICATION = "SqlAuthentication"
    ACTIVE_DIRECTORY_INTEGRATED = "ActiveDirectoryIntegrated"
    ACTIVE_DIRECTORY_PASSWORD = "ActiveDirectoryPassword"

class BackupFileStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of Status of the log backup file.
    """

    ARRIVED = "Arrived"
    QUEUED = "Queued"
    UPLOADING = "Uploading"
    UPLOADED = "Uploaded"
    RESTORING = "Restoring"
    RESTORED = "Restored"
    CANCELLED = "Cancelled"

class BackupMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of backup modes
    """

    CREATE_BACKUP = "CreateBackup"
    EXISTING_BACKUP = "ExistingBackup"

class BackupType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum of the different backup types.
    """

    DATABASE = "Database"
    TRANSACTION_LOG = "TransactionLog"
    FILE = "File"
    DIFFERENTIAL_DATABASE = "DifferentialDatabase"
    DIFFERENTIAL_FILE = "DifferentialFile"
    PARTIAL = "Partial"
    DIFFERENTIAL_PARTIAL = "DifferentialPartial"

class CommandState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the command. This is ignored if submitted.
    """

    UNKNOWN = "Unknown"
    ACCEPTED = "Accepted"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DatabaseCompatLevel(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of SQL Server database compatibility levels
    """

    COMPAT_LEVEL80 = "CompatLevel80"
    COMPAT_LEVEL90 = "CompatLevel90"
    COMPAT_LEVEL100 = "CompatLevel100"
    COMPAT_LEVEL110 = "CompatLevel110"
    COMPAT_LEVEL120 = "CompatLevel120"
    COMPAT_LEVEL130 = "CompatLevel130"
    COMPAT_LEVEL140 = "CompatLevel140"

class DatabaseFileType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of SQL Server database file types
    """

    ROWS = "Rows"
    LOG = "Log"
    FILESTREAM = "Filestream"
    NOT_SUPPORTED = "NotSupported"
    FULLTEXT = "Fulltext"

class DatabaseMigrationStage(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current stage of migration
    """

    NONE = "None"
    INITIALIZE = "Initialize"
    BACKUP = "Backup"
    FILE_COPY = "FileCopy"
    RESTORE = "Restore"
    COMPLETED = "Completed"

class DatabaseMigrationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Database level migration state.
    """

    UNDEFINED = "UNDEFINED"
    INITIAL = "INITIAL"
    FULL_BACKUP_UPLOAD_START = "FULL_BACKUP_UPLOAD_START"
    LOG_SHIPPING_START = "LOG_SHIPPING_START"
    UPLOAD_LOG_FILES_START = "UPLOAD_LOG_FILES_START"
    CUTOVER_START = "CUTOVER_START"
    POST_CUTOVER_COMPLETE = "POST_CUTOVER_COMPLETE"
    COMPLETED = "COMPLETED"
    CANCELLED = "CANCELLED"
    FAILED = "FAILED"

class DatabaseState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of SQL Server Database states
    """

    ONLINE = "Online"
    RESTORING = "Restoring"
    RECOVERING = "Recovering"
    RECOVERY_PENDING = "RecoveryPending"
    SUSPECT = "Suspect"
    EMERGENCY = "Emergency"
    OFFLINE = "Offline"
    COPYING = "Copying"
    OFFLINE_SECONDARY = "OfflineSecondary"

class DataMigrationResultCode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Result code of the data migration
    """

    INITIAL = "Initial"
    COMPLETED = "Completed"
    OBJECT_NOT_EXISTS_IN_SOURCE = "ObjectNotExistsInSource"
    OBJECT_NOT_EXISTS_IN_TARGET = "ObjectNotExistsInTarget"
    TARGET_OBJECT_IS_INACCESSIBLE = "TargetObjectIsInaccessible"
    FATAL_ERROR = "FatalError"

class ErrorType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Error type
    """

    DEFAULT = "Default"
    WARNING = "Warning"
    ERROR = "Error"

class LoginMigrationStage(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum of the different stage of login migration.
    """

    NONE = "None"
    INITIALIZE = "Initialize"
    LOGIN_MIGRATION = "LoginMigration"
    ESTABLISH_USER_MAPPING = "EstablishUserMapping"
    ASSIGN_ROLE_MEMBERSHIP = "AssignRoleMembership"
    ASSIGN_ROLE_OWNERSHIP = "AssignRoleOwnership"
    ESTABLISH_SERVER_PERMISSIONS = "EstablishServerPermissions"
    ESTABLISH_OBJECT_PERMISSIONS = "EstablishObjectPermissions"
    COMPLETED = "Completed"

class LoginType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum mapping of SMO LoginType.
    """

    WINDOWS_USER = "WindowsUser"
    WINDOWS_GROUP = "WindowsGroup"
    SQL_LOGIN = "SqlLogin"
    CERTIFICATE = "Certificate"
    ASYMMETRIC_KEY = "AsymmetricKey"
    EXTERNAL_USER = "ExternalUser"
    EXTERNAL_GROUP = "ExternalGroup"

class MigrationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current state of migration
    """

    NONE = "None"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    WARNING = "Warning"
    COMPLETED = "Completed"
    SKIPPED = "Skipped"
    STOPPED = "Stopped"

class MigrationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current status of migration
    """

    DEFAULT = "Default"
    CONNECTING = "Connecting"
    SOURCE_AND_TARGET_SELECTED = "SourceAndTargetSelected"
    SELECT_LOGINS = "SelectLogins"
    CONFIGURED = "Configured"
    RUNNING = "Running"
    ERROR = "Error"
    STOPPED = "Stopped"
    COMPLETED = "Completed"
    COMPLETED_WITH_WARNINGS = "CompletedWithWarnings"

class MongoDbClusterType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of data source
    """

    BLOB_CONTAINER = "BlobContainer"
    COSMOS_DB = "CosmosDb"
    MONGO_DB = "MongoDb"

class MongoDbErrorType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of error or warning
    """

    ERROR = "Error"
    VALIDATION_ERROR = "ValidationError"
    WARNING = "Warning"

class MongoDbMigrationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NOT_STARTED = "NotStarted"
    VALIDATING_INPUT = "ValidatingInput"
    INITIALIZING = "Initializing"
    RESTARTING = "Restarting"
    COPYING = "Copying"
    INITIAL_REPLAY = "InitialReplay"
    REPLAYING = "Replaying"
    FINALIZING = "Finalizing"
    COMPLETE = "Complete"
    CANCELED = "Canceled"
    FAILED = "Failed"

class MongoDbProgressResultType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of progress object
    """

    MIGRATION = "Migration"
    DATABASE = "Database"
    COLLECTION = "Collection"

class MongoDbReplication(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes how changes will be replicated from the source to the target. The default is OneTime.
    """

    DISABLED = "Disabled"
    ONE_TIME = "OneTime"
    CONTINUOUS = "Continuous"

class MongoDbShardKeyOrder(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The field ordering
    """

    FORWARD = "Forward"
    REVERSE = "Reverse"
    HASHED = "Hashed"

class MySqlTargetPlatformType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of possible target types when migrating from MySQL
    """

    SQL_SERVER = "SqlServer"
    AZURE_DB_FOR_MY_SQL = "AzureDbForMySQL"

class NameCheckFailureReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reason why the name is not available, if nameAvailable is false
    """

    ALREADY_EXISTS = "AlreadyExists"
    INVALID = "Invalid"

class ObjectType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of type of objects
    """

    STORED_PROCEDURES = "StoredProcedures"
    TABLE = "Table"
    USER = "User"
    VIEW = "View"
    FUNCTION = "Function"

class ProjectProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The project's provisioning state
    """

    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"

class ProjectSourcePlatform(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Source platform of the project
    """

    SQL = "SQL"
    MY_SQL = "MySQL"
    POSTGRE_SQL = "PostgreSql"
    MONGO_DB = "MongoDb"
    UNKNOWN = "Unknown"

class ProjectTargetPlatform(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Target platform of the project
    """

    SQLDB = "SQLDB"
    SQLMI = "SQLMI"
    AZURE_DB_FOR_MY_SQL = "AzureDbForMySql"
    AZURE_DB_FOR_POSTGRE_SQL = "AzureDbForPostgreSql"
    MONGO_DB = "MongoDb"
    UNKNOWN = "Unknown"

class ReplicateMigrationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Wrapper for replicate reported migration states.
    """

    UNDEFINED = "UNDEFINED"
    VALIDATING = "VALIDATING"
    PENDING = "PENDING"
    COMPLETE = "COMPLETE"
    ACTION_REQUIRED = "ACTION_REQUIRED"
    FAILED = "FAILED"

class ResourceSkuCapacityScaleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scale type applicable to the SKU.
    """

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
    NONE = "None"

class ResourceSkuRestrictionsReasonCode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reason code for restriction.
    """

    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"

class ResourceSkuRestrictionsType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of restrictions.
    """

    LOCATION = "location"

class ScenarioSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of source type
    """

    ACCESS = "Access"
    DB2 = "DB2"
    MY_SQL = "MySQL"
    ORACLE = "Oracle"
    SQL = "SQL"
    SYBASE = "Sybase"
    POSTGRE_SQL = "PostgreSQL"
    MONGO_DB = "MongoDB"
    SQLRDS = "SQLRDS"
    MY_SQLRDS = "MySQLRDS"
    POSTGRE_SQLRDS = "PostgreSQLRDS"

class ScenarioTarget(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of target type
    """

    SQL_SERVER = "SQLServer"
    SQLDB = "SQLDB"
    SQLDW = "SQLDW"
    SQLMI = "SQLMI"
    AZURE_DB_FOR_MY_SQL = "AzureDBForMySql"
    AZURE_DB_FOR_POSTGRES_SQL = "AzureDBForPostgresSQL"
    MONGO_DB = "MongoDB"

class SchemaMigrationOption(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Option for how schema is extracted and applied to target
    """

    NONE = "None"
    EXTRACT_FROM_SOURCE = "ExtractFromSource"
    USE_STORAGE_FILE = "UseStorageFile"

class SchemaMigrationStage(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current stage of schema migration
    """

    NOT_STARTED = "NotStarted"
    VALIDATING_INPUTS = "ValidatingInputs"
    COLLECTING_OBJECTS = "CollectingObjects"
    DOWNLOADING_SCRIPT = "DownloadingScript"
    GENERATING_SCRIPT = "GeneratingScript"
    UPLOADING_SCRIPT = "UploadingScript"
    DEPLOYING_SCHEMA = "DeployingSchema"
    COMPLETED = "Completed"
    COMPLETED_WITH_WARNINGS = "CompletedWithWarnings"
    FAILED = "Failed"

class ServerLevelPermissionsGroup(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Permission group for validations. These groups will run a set of permissions for validating
    user activity. Select the permission group for the activity that you are performing.
    """

    DEFAULT = "Default"
    MIGRATION_FROM_SQL_SERVER_TO_AZURE_DB = "MigrationFromSqlServerToAzureDB"
    MIGRATION_FROM_SQL_SERVER_TO_AZURE_MI = "MigrationFromSqlServerToAzureMI"
    MIGRATION_FROM_MY_SQL_TO_AZURE_DB_FOR_MY_SQL = "MigrationFromMySQLToAzureDBForMySQL"

class ServiceProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The resource's provisioning state
    """

    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    DEPLOYING = "Deploying"
    STOPPED = "Stopped"
    STOPPING = "Stopping"
    STARTING = "Starting"
    FAILED_TO_START = "FailedToStart"
    FAILED_TO_STOP = "FailedToStop"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class ServiceScalability(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scalability approach
    """

    NONE = "none"
    MANUAL = "manual"
    AUTOMATIC = "automatic"

class Severity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Severity of the validation error
    """

    MESSAGE = "Message"
    WARNING = "Warning"
    ERROR = "Error"

class SqlSourcePlatform(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of source platform types
    """

    SQL_ON_PREM = "SqlOnPrem"

class SsisMigrationOverwriteOption(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The overwrite option for SSIS object migration, only ignore and overwrite are supported in DMS
    now and future may add Reuse option for container object
    """

    IGNORE = "Ignore"
    OVERWRITE = "Overwrite"

class SsisMigrationStage(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current stage of SSIS migration
    """

    NONE = "None"
    INITIALIZE = "Initialize"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"

class SsisStoreType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enumeration of supported source SSIS store type in DMS
    """

    SSIS_CATALOG = "SsisCatalog"

class SyncDatabaseMigrationReportingState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum of the different state of database level online migration.
    """

    UNDEFINED = "UNDEFINED"
    CONFIGURING = "CONFIGURING"
    INITIALIAZING = "INITIALIAZING"
    STARTING = "STARTING"
    RUNNING = "RUNNING"
    READY_TO_COMPLETE = "READY_TO_COMPLETE"
    COMPLETING = "COMPLETING"
    COMPLETE = "COMPLETE"
    CANCELLING = "CANCELLING"
    CANCELLED = "CANCELLED"
    FAILED = "FAILED"
    VALIDATING = "VALIDATING"
    VALIDATION_COMPLETE = "VALIDATION_COMPLETE"
    VALIDATION_FAILED = "VALIDATION_FAILED"
    RESTORE_IN_PROGRESS = "RESTORE_IN_PROGRESS"
    RESTORE_COMPLETED = "RESTORE_COMPLETED"
    BACKUP_IN_PROGRESS = "BACKUP_IN_PROGRESS"
    BACKUP_COMPLETED = "BACKUP_COMPLETED"

class SyncTableMigrationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum of the different state of table level online migration.
    """

    BEFORE_LOAD = "BEFORE_LOAD"
    FULL_LOAD = "FULL_LOAD"
    COMPLETED = "COMPLETED"
    CANCELED = "CANCELED"
    ERROR = "ERROR"
    FAILED = "FAILED"

class TaskState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the task. This is ignored if submitted.
    """

    UNKNOWN = "Unknown"
    QUEUED = "Queued"
    RUNNING = "Running"
    CANCELED = "Canceled"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    FAILED_INPUT_VALIDATION = "FailedInputValidation"
    FAULTED = "Faulted"

class UpdateActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the actual difference for the compared object, while performing schema comparison
    """

    DELETED_ON_TARGET = "DeletedOnTarget"
    CHANGED_ON_TARGET = "ChangedOnTarget"
    ADDED_ON_TARGET = "AddedOnTarget"

class ValidationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current status of the validation
    """

    DEFAULT = "Default"
    NOT_STARTED = "NotStarted"
    INITIALIZED = "Initialized"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    COMPLETED_WITH_ISSUES = "CompletedWithIssues"
    STOPPED = "Stopped"
    FAILED = "Failed"
