﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/model/FeatureGroupSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{
  class ListFeatureGroupsResult
  {
  public:
    AWS_SAGEMAKER_API ListFeatureGroupsResult() = default;
    AWS_SAGEMAKER_API ListFeatureGroupsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SAGEMAKER_API ListFeatureGroupsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A summary of feature groups.</p>
     */
    inline const Aws::Vector<FeatureGroupSummary>& GetFeatureGroupSummaries() const { return m_featureGroupSummaries; }
    template<typename FeatureGroupSummariesT = Aws::Vector<FeatureGroupSummary>>
    void SetFeatureGroupSummaries(FeatureGroupSummariesT&& value) { m_featureGroupSummariesHasBeenSet = true; m_featureGroupSummaries = std::forward<FeatureGroupSummariesT>(value); }
    template<typename FeatureGroupSummariesT = Aws::Vector<FeatureGroupSummary>>
    ListFeatureGroupsResult& WithFeatureGroupSummaries(FeatureGroupSummariesT&& value) { SetFeatureGroupSummaries(std::forward<FeatureGroupSummariesT>(value)); return *this;}
    template<typename FeatureGroupSummariesT = FeatureGroupSummary>
    ListFeatureGroupsResult& AddFeatureGroupSummaries(FeatureGroupSummariesT&& value) { m_featureGroupSummariesHasBeenSet = true; m_featureGroupSummaries.emplace_back(std::forward<FeatureGroupSummariesT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListFeatureGroupsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListFeatureGroupsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<FeatureGroupSummary> m_featureGroupSummaries;
    bool m_featureGroupSummariesHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
