/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import org.opensearch.common.Nullable;
import org.opensearch.common.concurrent.RefCountedReleasable;
import org.opensearch.repositories.s3.AmazonS3WithCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.S3Client;

public class AmazonS3Reference
extends RefCountedReleasable<S3Client> {
    AmazonS3Reference(S3Client client) {
        this(client, null);
    }

    AmazonS3Reference(AmazonS3WithCredentials client) {
        this(client.client(), client.credentials());
    }

    AmazonS3Reference(S3Client client, @Nullable AwsCredentialsProvider credentials) {
        super("AWS_S3_CLIENT", (Object)client, () -> {
            client.close();
            if (credentials instanceof AutoCloseable) {
                AutoCloseable autoCloseable = (AutoCloseable)credentials;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

