/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoDelayElement<T>
extends InternalMonoOperator<T, T> {
    final Scheduler timedScheduler;
    final long delay;
    final TimeUnit unit;

    MonoDelayElement(Mono<? extends T> source, long delay, TimeUnit unit, Scheduler timedScheduler) {
        super(source);
        this.delay = delay;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.timedScheduler = Objects.requireNonNull(timedScheduler, "timedScheduler");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new DelayElementSubscriber<T>(actual, this.timedScheduler, this.delay, this.unit);
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.timedScheduler;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.ASYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class DelayElementSubscriber<T>
    implements InnerOperator<T, T>,
    Fuseable,
    Fuseable.QueueSubscription<T>,
    Runnable {
        static final Disposable CANCELLED = Disposables.disposed();
        static final Disposable TERMINATED = Disposables.disposed();
        final CoreSubscriber<? super T> actual;
        final long delay;
        final Scheduler scheduler;
        final TimeUnit unit;
        Subscription s;
        @Nullable T value;
        boolean done;
        volatile @Nullable Disposable task;
        static final AtomicReferenceFieldUpdater<DelayElementSubscriber, @Nullable Disposable> TASK = AtomicReferenceFieldUpdater.newUpdater(DelayElementSubscriber.class, Disposable.class, "task");

        DelayElementSubscriber(CoreSubscriber<? super T> actual, Scheduler scheduler, long delay, TimeUnit unit) {
            this.actual = actual;
            this.scheduler = scheduler;
            this.delay = delay;
            this.unit = unit;
        }

        @Override
        public @Nullable Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                Disposable task = this.task;
                return this.done && (task == TERMINATED || task == null && this.value == null);
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.task == CANCELLED;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return 0;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.scheduler;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.ASYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.value = t;
            try {
                Disposable currentTask = this.task;
                if (currentTask == CANCELLED) {
                    this.value = null;
                    Operators.onDiscard(t, this.actual.currentContext());
                    return;
                }
                Disposable nextTask = this.scheduler.schedule(this, this.delay, this.unit);
                do {
                    if ((currentTask = this.task) == CANCELLED) {
                        nextTask.dispose();
                        Operators.onDiscard(t, this.actual.currentContext());
                        return;
                    }
                    if (currentTask != TERMINATED) continue;
                    return;
                } while (!TASK.compareAndSet(this, null, nextTask));
                return;
            }
            catch (RejectedExecutionException ree) {
                this.value = null;
                Operators.onDiscard(t, this.actual.currentContext());
                this.actual.onError(Operators.onRejectedExecution(ree, this, null, t, this.actual.currentContext()));
                return;
            }
        }

        @Override
        public void run() {
            Disposable currentTask;
            do {
                if ((currentTask = this.task) != CANCELLED) continue;
                return;
            } while (!TASK.compareAndSet(this, currentTask, TERMINATED));
            T value = this.value;
            assert (value != null) : "value can not be null when task scheduled";
            this.value = null;
            this.actual.onNext(value);
            this.actual.onComplete();
        }

        public void cancel() {
            Disposable task;
            do {
                if ((task = this.task) != CANCELLED && task != TERMINATED) continue;
                return;
            } while (!TASK.compareAndSet(this, task, CANCELLED));
            if (task != null) {
                task.dispose();
                T value = this.value;
                this.value = null;
                Operators.onDiscard(value, this.actual.currentContext());
                return;
            }
            this.s.cancel();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public @Nullable T poll() {
            return null;
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }
    }
}

