/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.Scorable;
import org.opensearch.common.Rounding;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorBase;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;

public class HistogramSkiplistLeafCollector
extends LeafBucketCollector {
    private final NumericDocValues values;
    private final DocValuesSkipper skipper;
    private final LeafBucketCollector sub;
    private final boolean isSubNoOp;
    private final BucketsAggregator aggregator;
    private final LongFunction<Rounding.Prepared> preparedRoundingSupplier;
    private final Supplier<LongKeyedBucketOrds> bucketOrdsSupplier;
    private final IncreaseRoundingIfNeeded increaseRoundingIfNeeded;
    private int upToInclusive = -1;
    private boolean upToSameBucket;
    private long upToBucketIndex;
    private Rounding.Prepared lastPreparedRounding;

    public HistogramSkiplistLeafCollector(NumericDocValues values, DocValuesSkipper skipper, Rounding.Prepared preparedRounding, LongKeyedBucketOrds bucketOrds, LeafBucketCollector sub, BucketsAggregator aggregator) {
        this(values, skipper, owningBucketOrd -> preparedRounding, () -> bucketOrds, sub, aggregator, (owningBucketOrd, rounded) -> {});
    }

    public HistogramSkiplistLeafCollector(NumericDocValues values, DocValuesSkipper skipper, LongFunction<Rounding.Prepared> preparedRoundingSupplier, Supplier<LongKeyedBucketOrds> bucketOrdsSupplier, LeafBucketCollector sub, BucketsAggregator aggregator, IncreaseRoundingIfNeeded increaseRoundingIfNeeded) {
        this.values = values;
        this.skipper = skipper;
        this.preparedRoundingSupplier = preparedRoundingSupplier;
        this.bucketOrdsSupplier = bucketOrdsSupplier;
        this.sub = sub;
        this.isSubNoOp = sub == NO_OP_COLLECTOR;
        this.aggregator = aggregator;
        this.increaseRoundingIfNeeded = increaseRoundingIfNeeded;
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        if (this.sub != null) {
            this.sub.setScorer(scorer);
        }
    }

    private void advanceSkipper(int doc, long owningBucketOrd) throws IOException {
        if (doc > this.skipper.maxDocID(0)) {
            this.skipper.advance(doc);
        }
        this.upToSameBucket = false;
        if (this.skipper.minDocID(0) > doc) {
            this.upToInclusive = this.skipper.minDocID(0) - 1;
            return;
        }
        this.upToInclusive = this.skipper.maxDocID(0);
        Rounding.Prepared currentRounding = this.preparedRoundingSupplier.apply(owningBucketOrd);
        for (int level = 0; level < this.skipper.numLevels(); ++level) {
            int totalDocsAtLevel = this.skipper.maxDocID(level) - this.skipper.minDocID(level) + 1;
            long minBucket = currentRounding.round(this.skipper.minValue(level));
            long maxBucket = currentRounding.round(this.skipper.maxValue(level));
            if (this.skipper.docCount(level) != totalDocsAtLevel || minBucket != maxBucket) break;
            this.upToInclusive = this.skipper.maxDocID(level);
            this.upToSameBucket = true;
            this.upToBucketIndex = this.bucketOrdsSupplier.get().add(owningBucketOrd, maxBucket);
            if (this.upToBucketIndex >= 0L) continue;
            this.upToBucketIndex = -1L - this.upToBucketIndex;
        }
    }

    @Override
    public void collect(int doc, long owningBucketOrd) throws IOException {
        Rounding.Prepared currentRounding = this.preparedRoundingSupplier.apply(owningBucketOrd);
        if (currentRounding != this.lastPreparedRounding) {
            this.upToInclusive = -1;
            this.upToSameBucket = false;
            this.lastPreparedRounding = currentRounding;
        }
        if (doc > this.upToInclusive) {
            this.advanceSkipper(doc, owningBucketOrd);
        }
        if (this.upToSameBucket) {
            this.aggregator.incrementBucketDocCount(this.upToBucketIndex, 1L);
            this.sub.collect(doc, this.upToBucketIndex);
        } else if (this.values.advanceExact(doc)) {
            long value = this.values.longValue();
            long rounded = currentRounding.round(value);
            long bucketIndex = this.bucketOrdsSupplier.get().add(owningBucketOrd, rounded);
            if (bucketIndex < 0L) {
                bucketIndex = -1L - bucketIndex;
                this.aggregator.collectExistingBucket(this.sub, doc, bucketIndex);
            } else {
                this.aggregator.collectBucket(this.sub, doc, bucketIndex);
                this.increaseRoundingIfNeeded.accept(owningBucketOrd, rounded);
            }
        }
    }

    @Override
    public void collect(DocIdStream stream) throws IOException {
        this.collect(stream, 0L);
    }

    @Override
    public void collect(DocIdStream stream, long owningBucketOrd) throws IOException {
        while (true) {
            int upToExclusive;
            if ((upToExclusive = this.upToInclusive + 1) < 0) {
                upToExclusive = Integer.MAX_VALUE;
            }
            if (this.upToSameBucket) {
                if (this.isSubNoOp) {
                    long count = stream.count(upToExclusive);
                    this.aggregator.incrementBucketDocCount(this.upToBucketIndex, count);
                } else {
                    int[] count = new int[]{0};
                    stream.forEach(upToExclusive, doc -> {
                        this.sub.collect(doc, this.upToBucketIndex);
                        count[0] = count[0] + 1;
                    });
                    this.aggregator.incrementBucketDocCount(this.upToBucketIndex, count[0]);
                }
            } else {
                stream.forEach(upToExclusive, doc -> this.collect(doc, owningBucketOrd));
            }
            if (!stream.mayHaveRemaining()) break;
            this.advanceSkipper(upToExclusive, owningBucketOrd);
        }
    }

    public static boolean canUseSkiplist(LongBounds hardBounds, Aggregator parent, DocValuesSkipper skipper, NumericDocValues singleton) {
        if (skipper == null || singleton == null) {
            return false;
        }
        if (hardBounds != null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        if (parent instanceof AggregatorBase) {
            AggregatorBase base = (AggregatorBase)parent;
            return base.getLeafCollectorMode() == AggregatorBase.LeafCollectionMode.FILTER_REWRITE;
        }
        return false;
    }

    public static interface IncreaseRoundingIfNeeded {
        public void accept(long var1, long var3);
    }
}

