/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.opensearch.OpenSearchException;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public final class DataStream
extends AbstractDiffable<DataStream>
implements ToXContentObject {
    public static final String BACKING_INDEX_PREFIX = ".ds-";
    public static final String TIMESERIES_FIELDNAME = "@timestamp";
    public static final Comparator<LeafReader> TIMESERIES_LEAF_SORTER = Comparator.comparingLong(r -> {
        try {
            PointValues points = r.getPointValues(TIMESERIES_FIELDNAME);
            if (points != null) {
                byte[] sortValue = points.getMaxPackedValue();
                return LongPoint.decodeDimension((byte[])sortValue, (int)0);
            }
            return Long.MIN_VALUE;
        }
        catch (IOException e) {
            throw new OpenSearchException("Not a timeseries Index! Field [{}] not found!", new Object[]{TIMESERIES_FIELDNAME});
        }
    }).reversed();
    private final String name;
    private final TimestampField timeStampField;
    private final List<Index> indices;
    private final long generation;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> new DataStream((String)args[0], (TimestampField)args[1], (List)args[2], (Long)args[3]));

    public DataStream(String name, TimestampField timeStampField, List<Index> indices, long generation) {
        this.name = name;
        this.timeStampField = timeStampField;
        this.indices = Collections.unmodifiableList(indices);
        this.generation = generation;
        assert (indices.size() > 0);
        assert (indices.get(indices.size() - 1).getName().equals(DataStream.getDefaultBackingIndexName(name, generation)));
    }

    public DataStream(String name, TimestampField timeStampField, List<Index> indices) {
        this(name, timeStampField, indices, indices.size());
    }

    public String getName() {
        return this.name;
    }

    public TimestampField getTimeStampField() {
        return this.timeStampField;
    }

    public List<Index> getIndices() {
        return this.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    public DataStream rollover(Index newWriteIndex) {
        assert (newWriteIndex.getName().equals(DataStream.getDefaultBackingIndexName(this.name, this.generation + 1L)));
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.add(newWriteIndex);
        return new DataStream(this.name, this.timeStampField, backingIndices, this.generation + 1L);
    }

    public DataStream removeBackingIndex(Index index) {
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.remove(index);
        assert (backingIndices.size() == this.indices.size() - 1);
        return new DataStream(this.name, this.timeStampField, backingIndices, this.generation);
    }

    public DataStream replaceBackingIndex(Index existingBackingIndex, Index newBackingIndex) {
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        int backingIndexPosition = backingIndices.indexOf(existingBackingIndex);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s] ", existingBackingIndex.getName(), this.name));
        }
        if (this.generation == (long)(backingIndexPosition + 1)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot replace backing index [%s] of data stream [%s] because it is the write index", existingBackingIndex.getName(), this.name));
        }
        backingIndices.set(backingIndexPosition, newBackingIndex);
        return new DataStream(this.name, this.timeStampField, backingIndices, this.generation);
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation) {
        return String.format(Locale.ROOT, ".ds-%s-%06d", dataStreamName, generation);
    }

    public DataStream(StreamInput in) throws IOException {
        this(in.readString(), new TimestampField(in), in.readList(Index::new), in.readVLong());
    }

    public static Diff<DataStream> readDiffFrom(StreamInput in) throws IOException {
        return DataStream.readDiffFrom(DataStream::new, in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.timeStampField.writeTo(out);
        out.writeList(this.indices);
        out.writeVLong(this.generation);
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return (DataStream)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(TIMESTAMP_FIELD_FIELD.getPreferredName(), (ToXContent)this.timeStampField);
        builder.field(INDICES_FIELD.getPreferredName(), this.indices);
        builder.field(GENERATION_FIELD.getPreferredName(), this.generation);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.name.equals(that.name) && this.timeStampField.equals(that.timeStampField) && this.indices.equals(that.indices) && this.generation == that.generation;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeStampField, this.indices, this.generation);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TimestampField.PARSER, TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Index.fromXContent((XContentParser)p), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
    }

    @PublicApi(since="1.0.0")
    public static final class TimestampField
    implements Writeable,
    ToXContentObject {
        static ParseField NAME_FIELD = new ParseField("name", new String[0]);
        public static final ConstructingObjectParser<TimestampField, Void> PARSER = new ConstructingObjectParser("timestamp_field", args -> new TimestampField((String)args[0]));
        private final String name;

        public TimestampField(String name) {
            this.name = name;
        }

        public TimestampField(StreamInput in) throws IOException {
            this.name = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.endObject();
            return builder;
        }

        public Map<String, Object> toMap() {
            return Collections.singletonMap(NAME_FIELD.getPreferredName(), this.name);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampField that = (TimestampField)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        }
    }
}

