/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.bootstrap.jvm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensearch.common.Nullable;

public class DenyJvmVersionsParser {
    /*
     * Enabled aggressive exception aggregation
     */
    public static Collection<VersionPredicate> getDeniedJvmVersions() {
        try (InputStreamReader in = new InputStreamReader(DenyJvmVersionsParser.class.getResourceAsStream("deny-jvm-versions.txt"), StandardCharsets.UTF_8);){
            Collection collection;
            try (BufferedReader reader = new BufferedReader(in);){
                collection = reader.lines().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("//")).map(DenyJvmVersionsParser::parse).collect(Collectors.toList());
            }
            return collection;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unable to read the list of denied JVM versions", ex);
        }
    }

    static VersionPredicate parse(String line) {
        String[] parts = (String[])Arrays.stream(line.split("[:]", 2)).map(String::trim).toArray(String[]::new);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unable to parse JVM version or version range: " + line);
        }
        String versionOrRange = parts[0];
        String reason = parts[1];
        if (versionOrRange.startsWith("[") || versionOrRange.startsWith("(")) {
            if (!versionOrRange.endsWith("]") && !versionOrRange.endsWith(")")) {
                throw new IllegalArgumentException("Unable to parse JVM version range: " + versionOrRange);
            }
            boolean lowerIncluded = versionOrRange.startsWith("[");
            boolean upperIncluded = versionOrRange.endsWith("]");
            String[] range = (String[])Arrays.stream(versionOrRange.substring(1, versionOrRange.length() - 1).split("[,]", 2)).map(String::trim).toArray(String[]::new);
            if (range.length != 2) {
                throw new IllegalArgumentException("Unable to parse JVM version range: " + versionOrRange);
            }
            Runtime.Version lower = null;
            if (!range[0].isEmpty() && !range[0].equals("*")) {
                lower = Runtime.Version.parse(range[0]);
            }
            Runtime.Version upper = null;
            if (!range[1].isEmpty() && !range[1].equals("*")) {
                upper = Runtime.Version.parse(range[1]);
            }
            return new VersionRange(lower, lowerIncluded, upper, upperIncluded, reason);
        }
        return new SingleVersion(Runtime.Version.parse(versionOrRange), reason);
    }

    private static class VersionRange
    implements VersionPredicate {
        private Runtime.Version lower;
        private boolean lowerIncluded;
        private Runtime.Version upper;
        private boolean upperIncluded;
        private String reason;

        public VersionRange(@Nullable Runtime.Version lower, boolean lowerIncluded, @Nullable Runtime.Version upper, boolean upperIncluded, String reason) {
            this.lower = lower;
            this.lowerIncluded = lowerIncluded;
            this.upper = upper;
            this.upperIncluded = upperIncluded;
            this.reason = reason;
        }

        @Override
        public boolean test(Runtime.Version v) {
            int compare;
            if (this.lower != null && ((compare = this.lower.compareTo(v)) > 0 || compare == 0 && !this.lowerIncluded)) {
                return false;
            }
            return this.upper == null || (compare = this.upper.compareTo(v)) >= 0 && (compare != 0 || this.upperIncluded);
        }

        @Override
        public String getReason() {
            return this.reason;
        }
    }

    private static class SingleVersion
    implements VersionPredicate {
        private final Runtime.Version version;
        private final String reason;

        public SingleVersion(Runtime.Version version, String reason) {
            this.version = version;
            this.reason = reason;
        }

        @Override
        public boolean test(Runtime.Version v) {
            return this.version.compareTo(v) == 0;
        }

        @Override
        public String getReason() {
            return this.reason;
        }
    }

    public static interface VersionPredicate
    extends Predicate<Runtime.Version> {
        public String getReason();
    }
}

