/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import org.gradle.util.internal.VersionNumber;
import org.jspecify.annotations.Nullable;

public class GroovyDependencyUtil {
    public static String groovyGroupName(String version) {
        return GroovyDependencyUtil.groovyGroupName(VersionNumber.parse((String)version));
    }

    public static String groovyGroupName(VersionNumber version) {
        return version.getMajor() >= 4 ? "org.apache.groovy" : "org.codehaus.groovy";
    }

    public static String groovyModuleDependency(String module, String version) {
        return GroovyDependencyUtil.groovyModuleDependency(module, version, null);
    }

    public static String groovyModuleDependency(String module, String version, @Nullable String classifier) {
        return GroovyDependencyUtil.groovyModuleDependency(module, VersionNumber.parse((String)version), classifier);
    }

    public static String groovyModuleDependency(String module, VersionNumber version) {
        return GroovyDependencyUtil.groovyModuleDependency(module, version, null);
    }

    public static String groovyModuleDependency(String module, VersionNumber version, @Nullable String classifier) {
        StringBuilder dependency = new StringBuilder();
        dependency.append(GroovyDependencyUtil.groovyGroupName(version));
        dependency.append(':');
        dependency.append(module);
        dependency.append(':');
        dependency.append(version);
        if (classifier != null && !classifier.isEmpty()) {
            dependency.append(':');
            dependency.append(classifier);
        }
        return dependency.toString();
    }

    public static String spockModuleDependency(String module, String version) {
        return GroovyDependencyUtil.spockModuleDependency(module, VersionNumber.parse((String)version));
    }

    public static String spockModuleDependency(String module, VersionNumber version) {
        int major = version.getMajor();
        int minor = version.getMinor();
        if (major > 4) {
            major = 4;
            minor = 0;
        }
        return "org.spockframework:" + module + ":2.3-groovy-" + major + "." + minor;
    }
}

