# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from typing import Any, Callable, Literal, Optional, TypeVar, Union

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import AzureFileStorageConfiguration
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    metadata: Optional[dict[str, str]] = None,
    file_permission: str = "inherit",
    file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
    file_permission_key: Optional[str] = None,
    file_attributes: str = "none",
    file_creation_time: str = "now",
    file_last_write_time: str = "now",
    file_change_time: Optional[str] = None,
    owner: Optional[str] = None,
    group: Optional[str] = None,
    file_mode: Optional[str] = None,
    file_property_semantics: Optional[Union[str, _models.FilePropertySemantics]] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if file_permission is not None:
        _headers["x-ms-file-permission"] = _SERIALIZER.header("file_permission", file_permission, "str")
    if file_permission_format is not None:
        _headers["x-ms-file-permission-format"] = _SERIALIZER.header(
            "file_permission_format", file_permission_format, "str"
        )
    if file_permission_key is not None:
        _headers["x-ms-file-permission-key"] = _SERIALIZER.header("file_permission_key", file_permission_key, "str")
    if file_attributes is not None:
        _headers["x-ms-file-attributes"] = _SERIALIZER.header("file_attributes", file_attributes, "str")
    if file_creation_time is not None:
        _headers["x-ms-file-creation-time"] = _SERIALIZER.header("file_creation_time", file_creation_time, "str")
    if file_last_write_time is not None:
        _headers["x-ms-file-last-write-time"] = _SERIALIZER.header("file_last_write_time", file_last_write_time, "str")
    if file_change_time is not None:
        _headers["x-ms-file-change-time"] = _SERIALIZER.header("file_change_time", file_change_time, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    if owner is not None:
        _headers["x-ms-owner"] = _SERIALIZER.header("owner", owner, "str")
    if group is not None:
        _headers["x-ms-group"] = _SERIALIZER.header("group", group, "str")
    if file_mode is not None:
        _headers["x-ms-mode"] = _SERIALIZER.header("file_mode", file_mode, "str")
    if file_property_semantics is not None:
        _headers["x-ms-file-property-semantics"] = _SERIALIZER.header(
            "file_property_semantics", file_property_semantics, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_properties_request(
    url: str,
    *,
    sharesnapshot: Optional[str] = None,
    timeout: Optional[int] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_properties_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    file_permission: str = "inherit",
    file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
    file_permission_key: Optional[str] = None,
    file_attributes: str = "none",
    file_creation_time: str = "now",
    file_last_write_time: str = "now",
    file_change_time: Optional[str] = None,
    owner: Optional[str] = None,
    group: Optional[str] = None,
    file_mode: Optional[str] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
    comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if file_permission is not None:
        _headers["x-ms-file-permission"] = _SERIALIZER.header("file_permission", file_permission, "str")
    if file_permission_format is not None:
        _headers["x-ms-file-permission-format"] = _SERIALIZER.header(
            "file_permission_format", file_permission_format, "str"
        )
    if file_permission_key is not None:
        _headers["x-ms-file-permission-key"] = _SERIALIZER.header("file_permission_key", file_permission_key, "str")
    if file_attributes is not None:
        _headers["x-ms-file-attributes"] = _SERIALIZER.header("file_attributes", file_attributes, "str")
    if file_creation_time is not None:
        _headers["x-ms-file-creation-time"] = _SERIALIZER.header("file_creation_time", file_creation_time, "str")
    if file_last_write_time is not None:
        _headers["x-ms-file-last-write-time"] = _SERIALIZER.header("file_last_write_time", file_last_write_time, "str")
    if file_change_time is not None:
        _headers["x-ms-file-change-time"] = _SERIALIZER.header("file_change_time", file_change_time, "str")
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    if owner is not None:
        _headers["x-ms-owner"] = _SERIALIZER.header("owner", owner, "str")
    if group is not None:
        _headers["x-ms-group"] = _SERIALIZER.header("group", group, "str")
    if file_mode is not None:
        _headers["x-ms-mode"] = _SERIALIZER.header("file_mode", file_mode, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_metadata_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    metadata: Optional[dict[str, str]] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
    comp: Literal["metadata"] = kwargs.pop("comp", _params.pop("comp", "metadata"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_files_and_directories_segment_request(  # pylint: disable=name-too-long
    url: str,
    *,
    prefix: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    marker: Optional[str] = None,
    maxresults: Optional[int] = None,
    timeout: Optional[int] = None,
    include: Optional[list[Union[str, _models.ListFilesIncludeType]]] = None,
    include_extended_info: Optional[bool] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
    comp: Literal["list"] = kwargs.pop("comp", _params.pop("comp", "list"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if prefix is not None:
        _params["prefix"] = _SERIALIZER.query("prefix", prefix, "str")
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")
    if marker is not None:
        _params["marker"] = _SERIALIZER.query("marker", marker, "str")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", minimum=1)
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if include is not None:
        _params["include"] = _SERIALIZER.query("include", include, "[str]", div=",")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if include_extended_info is not None:
        _headers["x-ms-file-extended-info"] = _SERIALIZER.header("include_extended_info", include_extended_info, "bool")
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_handles_request(
    url: str,
    *,
    marker: Optional[str] = None,
    maxresults: Optional[int] = None,
    timeout: Optional[int] = None,
    sharesnapshot: Optional[str] = None,
    recursive: Optional[bool] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["listhandles"] = kwargs.pop("comp", _params.pop("comp", "listhandles"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if marker is not None:
        _params["marker"] = _SERIALIZER.query("marker", marker, "str")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", minimum=1)
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    if recursive is not None:
        _headers["x-ms-recursive"] = _SERIALIZER.header("recursive", recursive, "bool")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_force_close_handles_request(
    url: str,
    *,
    handle_id: str,
    timeout: Optional[int] = None,
    marker: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    recursive: Optional[bool] = None,
    allow_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["forceclosehandles"] = kwargs.pop("comp", _params.pop("comp", "forceclosehandles"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if marker is not None:
        _params["marker"] = _SERIALIZER.query("marker", marker, "str")
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-handle-id"] = _SERIALIZER.header("handle_id", handle_id, "str")
    if recursive is not None:
        _headers["x-ms-recursive"] = _SERIALIZER.header("recursive", recursive, "bool")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_rename_request(
    url: str,
    *,
    rename_source: str,
    timeout: Optional[int] = None,
    replace_if_exists: Optional[bool] = None,
    ignore_read_only: Optional[bool] = None,
    source_lease_id: Optional[str] = None,
    destination_lease_id: Optional[str] = None,
    file_attributes: Optional[str] = None,
    file_creation_time: Optional[str] = None,
    file_last_write_time: Optional[str] = None,
    file_change_time: Optional[str] = None,
    file_permission: str = "inherit",
    file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
    file_permission_key: Optional[str] = None,
    metadata: Optional[dict[str, str]] = None,
    allow_trailing_dot: Optional[bool] = None,
    allow_source_trailing_dot: Optional[bool] = None,
    file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
    comp: Literal["rename"] = kwargs.pop("comp", _params.pop("comp", "rename"))
    version: Literal["2026-02-06"] = kwargs.pop("version", _headers.pop("x-ms-version", "2026-02-06"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["x-ms-file-rename-source"] = _SERIALIZER.header("rename_source", rename_source, "str")
    if replace_if_exists is not None:
        _headers["x-ms-file-rename-replace-if-exists"] = _SERIALIZER.header(
            "replace_if_exists", replace_if_exists, "bool"
        )
    if ignore_read_only is not None:
        _headers["x-ms-file-rename-ignore-readonly"] = _SERIALIZER.header("ignore_read_only", ignore_read_only, "bool")
    if source_lease_id is not None:
        _headers["x-ms-source-lease-id"] = _SERIALIZER.header("source_lease_id", source_lease_id, "str")
    if destination_lease_id is not None:
        _headers["x-ms-destination-lease-id"] = _SERIALIZER.header("destination_lease_id", destination_lease_id, "str")
    if file_attributes is not None:
        _headers["x-ms-file-attributes"] = _SERIALIZER.header("file_attributes", file_attributes, "str")
    if file_creation_time is not None:
        _headers["x-ms-file-creation-time"] = _SERIALIZER.header("file_creation_time", file_creation_time, "str")
    if file_last_write_time is not None:
        _headers["x-ms-file-last-write-time"] = _SERIALIZER.header("file_last_write_time", file_last_write_time, "str")
    if file_change_time is not None:
        _headers["x-ms-file-change-time"] = _SERIALIZER.header("file_change_time", file_change_time, "str")
    if file_permission is not None:
        _headers["x-ms-file-permission"] = _SERIALIZER.header("file_permission", file_permission, "str")
    if file_permission_format is not None:
        _headers["x-ms-file-permission-format"] = _SERIALIZER.header(
            "file_permission_format", file_permission_format, "str"
        )
    if file_permission_key is not None:
        _headers["x-ms-file-permission-key"] = _SERIALIZER.header("file_permission_key", file_permission_key, "str")
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    if allow_trailing_dot is not None:
        _headers["x-ms-allow-trailing-dot"] = _SERIALIZER.header("allow_trailing_dot", allow_trailing_dot, "bool")
    if allow_source_trailing_dot is not None:
        _headers["x-ms-source-allow-trailing-dot"] = _SERIALIZER.header(
            "allow_source_trailing_dot", allow_source_trailing_dot, "bool"
        )
    if file_request_intent is not None:
        _headers["x-ms-file-request-intent"] = _SERIALIZER.header("file_request_intent", file_request_intent, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


class DirectoryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.fileshare.AzureFileStorage`'s
        :attr:`directory` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AzureFileStorageConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def create(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[dict[str, str]] = None,
        file_permission: str = "inherit",
        file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
        file_permission_key: Optional[str] = None,
        file_attributes: str = "none",
        file_creation_time: str = "now",
        file_last_write_time: str = "now",
        file_change_time: Optional[str] = None,
        owner: Optional[str] = None,
        group: Optional[str] = None,
        file_mode: Optional[str] = None,
        file_property_semantics: Optional[Union[str, _models.FilePropertySemantics]] = None,
        **kwargs: Any
    ) -> None:
        """Creates a new directory under the specified share or parent directory.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_format: Optional. Available for version 2023-06-01 and later. Specifies
         the format in which the permission is returned. Acceptable values are SDDL or binary. If
         x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is
         returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the
         permission is returned as a base64 string representing the binary encoding of the permission.
         Known values are: "Sddl" and "Binary". Default value is None.
        :type file_permission_format: str or ~azure.storage.fileshare.models.FilePermissionFormat
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param file_attributes: If specified, the provided file attributes shall be set. Default value:
         ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
         Default value is "none".
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory. Default value: Now. Default
         value is "now".
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory. Default value: Now.
         Default value is "now".
        :type file_last_write_time: str
        :param file_change_time: Change time for the file/directory. Default value: Now. Default value
         is None.
        :type file_change_time: str
        :param owner: Optional, NFS only. The owner of the file or directory. Default value is None.
        :type owner: str
        :param group: Optional, NFS only. The owning group of the file or directory. Default value is
         None.
        :type group: str
        :param file_mode: Optional, NFS only. The file mode of the file or directory. Default value is
         None.
        :type file_mode: str
        :param file_property_semantics: SMB only, default value is New.  New will forcefully add the
         ARCHIVE attribute flag and alter the permissions specified in x-ms-file-permission to inherit
         missing permissions from the parent.  Restore will apply changes without further modification.
         Known values are: "New" and "Restore". Default value is None.
        :type file_property_semantics: str or ~azure.storage.fileshare.models.FilePropertySemantics
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_create_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            file_permission=file_permission,
            file_permission_format=file_permission_format,
            file_permission_key=file_permission_key,
            file_attributes=file_attributes,
            file_creation_time=file_creation_time,
            file_last_write_time=file_last_write_time,
            file_change_time=file_change_time,
            owner=owner,
            group=group,
            file_mode=file_mode,
            file_property_semantics=file_property_semantics,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-request-server-encrypted"] = self._deserialize(
            "bool", response.headers.get("x-ms-request-server-encrypted")
        )
        response_headers["x-ms-file-permission-key"] = self._deserialize(
            "str", response.headers.get("x-ms-file-permission-key")
        )
        response_headers["x-ms-file-attributes"] = self._deserialize(
            "str", response.headers.get("x-ms-file-attributes")
        )
        response_headers["x-ms-file-creation-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-creation-time")
        )
        response_headers["x-ms-file-last-write-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-last-write-time")
        )
        response_headers["x-ms-file-change-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-change-time")
        )
        response_headers["x-ms-file-id"] = self._deserialize("str", response.headers.get("x-ms-file-id"))
        response_headers["x-ms-file-parent-id"] = self._deserialize("str", response.headers.get("x-ms-file-parent-id"))
        response_headers["x-ms-mode"] = self._deserialize("str", response.headers.get("x-ms-mode"))
        response_headers["x-ms-owner"] = self._deserialize("str", response.headers.get("x-ms-owner"))
        response_headers["x-ms-group"] = self._deserialize("str", response.headers.get("x-ms-group"))
        response_headers["x-ms-file-file-type"] = self._deserialize("str", response.headers.get("x-ms-file-file-type"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_properties(  # pylint: disable=inconsistent-return-statements
        self, sharesnapshot: Optional[str] = None, timeout: Optional[int] = None, **kwargs: Any
    ) -> None:
        """Returns all system properties for the specified directory, and can also be used to check the
        existence of a directory. The data returned does not include the files in the directory or any
        subdirectories.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_get_properties_request(
            url=self._config.url,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-meta"] = self._deserialize("{str}", response.headers.get("x-ms-meta"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-server-encrypted"] = self._deserialize(
            "bool", response.headers.get("x-ms-server-encrypted")
        )
        response_headers["x-ms-file-attributes"] = self._deserialize(
            "str", response.headers.get("x-ms-file-attributes")
        )
        response_headers["x-ms-file-creation-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-creation-time")
        )
        response_headers["x-ms-file-last-write-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-last-write-time")
        )
        response_headers["x-ms-file-change-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-change-time")
        )
        response_headers["x-ms-file-permission-key"] = self._deserialize(
            "str", response.headers.get("x-ms-file-permission-key")
        )
        response_headers["x-ms-file-id"] = self._deserialize("str", response.headers.get("x-ms-file-id"))
        response_headers["x-ms-file-parent-id"] = self._deserialize("str", response.headers.get("x-ms-file-parent-id"))
        response_headers["x-ms-mode"] = self._deserialize("str", response.headers.get("x-ms-mode"))
        response_headers["x-ms-owner"] = self._deserialize("str", response.headers.get("x-ms-owner"))
        response_headers["x-ms-group"] = self._deserialize("str", response.headers.get("x-ms-group"))
        response_headers["x-ms-file-file-type"] = self._deserialize("str", response.headers.get("x-ms-file-file-type"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, timeout: Optional[int] = None, **kwargs: Any
    ) -> None:
        """Removes the specified empty directory. Note that the directory must be empty before it can be
        deleted.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            url=self._config.url,
            timeout=timeout,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def set_properties(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        file_permission: str = "inherit",
        file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
        file_permission_key: Optional[str] = None,
        file_attributes: str = "none",
        file_creation_time: str = "now",
        file_last_write_time: str = "now",
        file_change_time: Optional[str] = None,
        owner: Optional[str] = None,
        group: Optional[str] = None,
        file_mode: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Sets properties on the directory.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_format: Optional. Available for version 2023-06-01 and later. Specifies
         the format in which the permission is returned. Acceptable values are SDDL or binary. If
         x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is
         returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the
         permission is returned as a base64 string representing the binary encoding of the permission.
         Known values are: "Sddl" and "Binary". Default value is None.
        :type file_permission_format: str or ~azure.storage.fileshare.models.FilePermissionFormat
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param file_attributes: If specified, the provided file attributes shall be set. Default value:
         ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
         Default value is "none".
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory. Default value: Now. Default
         value is "now".
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory. Default value: Now.
         Default value is "now".
        :type file_last_write_time: str
        :param file_change_time: Change time for the file/directory. Default value: Now. Default value
         is None.
        :type file_change_time: str
        :param owner: Optional, NFS only. The owner of the file or directory. Default value is None.
        :type owner: str
        :param group: Optional, NFS only. The owning group of the file or directory. Default value is
         None.
        :type group: str
        :param file_mode: Optional, NFS only. The file mode of the file or directory. Default value is
         None.
        :type file_mode: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
        comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_set_properties_request(
            url=self._config.url,
            timeout=timeout,
            file_permission=file_permission,
            file_permission_format=file_permission_format,
            file_permission_key=file_permission_key,
            file_attributes=file_attributes,
            file_creation_time=file_creation_time,
            file_last_write_time=file_last_write_time,
            file_change_time=file_change_time,
            owner=owner,
            group=group,
            file_mode=file_mode,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-request-server-encrypted"] = self._deserialize(
            "bool", response.headers.get("x-ms-request-server-encrypted")
        )
        response_headers["x-ms-file-permission-key"] = self._deserialize(
            "str", response.headers.get("x-ms-file-permission-key")
        )
        response_headers["x-ms-file-attributes"] = self._deserialize(
            "str", response.headers.get("x-ms-file-attributes")
        )
        response_headers["x-ms-file-creation-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-creation-time")
        )
        response_headers["x-ms-file-last-write-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-last-write-time")
        )
        response_headers["x-ms-file-change-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-change-time")
        )
        response_headers["x-ms-file-id"] = self._deserialize("str", response.headers.get("x-ms-file-id"))
        response_headers["x-ms-file-parent-id"] = self._deserialize("str", response.headers.get("x-ms-file-parent-id"))
        response_headers["x-ms-mode"] = self._deserialize("str", response.headers.get("x-ms-mode"))
        response_headers["x-ms-owner"] = self._deserialize("str", response.headers.get("x-ms-owner"))
        response_headers["x-ms-group"] = self._deserialize("str", response.headers.get("x-ms-group"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def set_metadata(  # pylint: disable=inconsistent-return-statements
        self, timeout: Optional[int] = None, metadata: Optional[dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """Updates user defined metadata for the specified directory.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
        comp: Literal["metadata"] = kwargs.pop("comp", _params.pop("comp", "metadata"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_set_metadata_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-request-server-encrypted"] = self._deserialize(
            "bool", response.headers.get("x-ms-request-server-encrypted")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_files_and_directories_segment(
        self,
        prefix: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        marker: Optional[str] = None,
        maxresults: Optional[int] = None,
        timeout: Optional[int] = None,
        include: Optional[list[Union[str, _models.ListFilesIncludeType]]] = None,
        include_extended_info: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.ListFilesAndDirectoriesSegmentResponse:
        """Returns a list of files or directories under the specified share or directory. It lists the
        contents only for a single level of the directory hierarchy.

        :param prefix: Filters the results to return only entries whose name begins with the specified
         prefix. Default value is None.
        :type prefix: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param marker: A string value that identifies the portion of the list to be returned with the
         next list operation. The operation returns a marker value within the response body if the list
         returned was not complete. The marker value may then be used in a subsequent call to request
         the next set of list items. The marker value is opaque to the client. Default value is None.
        :type marker: str
        :param maxresults: Specifies the maximum number of entries to return. If the request does not
         specify maxresults, or specifies a value greater than 5,000, the server will return up to 5,000
         items. Default value is None.
        :type maxresults: int
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param include: Include this parameter to specify one or more datasets to include in the
         response. Default value is None.
        :type include: list[str or ~azure.storage.fileshare.models.ListFilesIncludeType]
        :param include_extended_info: Include extended information. Default value is None.
        :type include_extended_info: bool
        :return: ListFilesAndDirectoriesSegmentResponse or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ListFilesAndDirectoriesSegmentResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
        comp: Literal["list"] = kwargs.pop("comp", _params.pop("comp", "list"))
        cls: ClsType[_models.ListFilesAndDirectoriesSegmentResponse] = kwargs.pop("cls", None)

        _request = build_list_files_and_directories_segment_request(
            url=self._config.url,
            prefix=prefix,
            sharesnapshot=sharesnapshot,
            marker=marker,
            maxresults=maxresults,
            timeout=timeout,
            include=include,
            include_extended_info=include_extended_info,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("ListFilesAndDirectoriesSegmentResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_handles(
        self,
        marker: Optional[str] = None,
        maxresults: Optional[int] = None,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        recursive: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.ListHandlesResponse:
        """Lists handles for directory.

        :param marker: A string value that identifies the portion of the list to be returned with the
         next list operation. The operation returns a marker value within the response body if the list
         returned was not complete. The marker value may then be used in a subsequent call to request
         the next set of list items. The marker value is opaque to the client. Default value is None.
        :type marker: str
        :param maxresults: Specifies the maximum number of entries to return. If the request does not
         specify maxresults, or specifies a value greater than 5,000, the server will return up to 5,000
         items. Default value is None.
        :type maxresults: int
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param recursive: Specifies operation should apply to the directory specified in the URI, its
         files, its subdirectories and their files. Default value is None.
        :type recursive: bool
        :return: ListHandlesResponse or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ListHandlesResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["listhandles"] = kwargs.pop("comp", _params.pop("comp", "listhandles"))
        cls: ClsType[_models.ListHandlesResponse] = kwargs.pop("cls", None)

        _request = build_list_handles_request(
            url=self._config.url,
            marker=marker,
            maxresults=maxresults,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            recursive=recursive,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("ListHandlesResponse", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def force_close_handles(  # pylint: disable=inconsistent-return-statements
        self,
        handle_id: str,
        timeout: Optional[int] = None,
        marker: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        recursive: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Closes all handles open for given directory.

        :param handle_id: Specifies handle ID opened on the file or directory to be closed. Asterisk
         (‘*’) is a wildcard that specifies all handles. Required.
        :type handle_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param marker: A string value that identifies the portion of the list to be returned with the
         next list operation. The operation returns a marker value within the response body if the list
         returned was not complete. The marker value may then be used in a subsequent call to request
         the next set of list items. The marker value is opaque to the client. Default value is None.
        :type marker: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param recursive: Specifies operation should apply to the directory specified in the URI, its
         files, its subdirectories and their files. Default value is None.
        :type recursive: bool
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["forceclosehandles"] = kwargs.pop("comp", _params.pop("comp", "forceclosehandles"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_force_close_handles_request(
            url=self._config.url,
            handle_id=handle_id,
            timeout=timeout,
            marker=marker,
            sharesnapshot=sharesnapshot,
            recursive=recursive,
            allow_trailing_dot=self._config.allow_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-marker"] = self._deserialize("str", response.headers.get("x-ms-marker"))
        response_headers["x-ms-number-of-handles-closed"] = self._deserialize(
            "int", response.headers.get("x-ms-number-of-handles-closed")
        )
        response_headers["x-ms-number-of-handles-failed"] = self._deserialize(
            "int", response.headers.get("x-ms-number-of-handles-failed")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def rename(  # pylint: disable=inconsistent-return-statements
        self,
        rename_source: str,
        timeout: Optional[int] = None,
        replace_if_exists: Optional[bool] = None,
        ignore_read_only: Optional[bool] = None,
        file_permission: str = "inherit",
        file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
        file_permission_key: Optional[str] = None,
        metadata: Optional[dict[str, str]] = None,
        source_lease_access_conditions: Optional[_models.SourceLeaseAccessConditions] = None,
        destination_lease_access_conditions: Optional[_models.DestinationLeaseAccessConditions] = None,
        copy_file_smb_info: Optional[_models.CopyFileSmbInfo] = None,
        **kwargs: Any
    ) -> None:
        """Renames a directory.

        :param rename_source: Required. Specifies the URI-style path of the source file, up to 2 KB in
         length. Required.
        :type rename_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param replace_if_exists: Optional. A boolean value for if the destination file already exists,
         whether this request will overwrite the file or not. If true, the rename will succeed and will
         overwrite the destination file. If not provided or if false and the destination file does
         exist, the request will not overwrite the destination file. If provided and the destination
         file doesn’t exist, the rename will succeed. Note: This value does not override the
         x-ms-file-copy-ignore-read-only header value. Default value is None.
        :type replace_if_exists: bool
        :param ignore_read_only: Optional. A boolean value that specifies whether the ReadOnly
         attribute on a preexisting destination file should be respected. If true, the rename will
         succeed, otherwise, a previous file at the destination with the ReadOnly attribute set will
         cause the rename to fail. Default value is None.
        :type ignore_read_only: bool
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_format: Optional. Available for version 2023-06-01 and later. Specifies
         the format in which the permission is returned. Acceptable values are SDDL or binary. If
         x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is
         returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the
         permission is returned as a base64 string representing the binary encoding of the permission.
         Known values are: "Sddl" and "Binary". Default value is None.
        :type file_permission_format: str or ~azure.storage.fileshare.models.FilePermissionFormat
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param source_lease_access_conditions: Parameter group. Default value is None.
        :type source_lease_access_conditions:
         ~azure.storage.fileshare.models.SourceLeaseAccessConditions
        :param destination_lease_access_conditions: Parameter group. Default value is None.
        :type destination_lease_access_conditions:
         ~azure.storage.fileshare.models.DestinationLeaseAccessConditions
        :param copy_file_smb_info: Parameter group. Default value is None.
        :type copy_file_smb_info: ~azure.storage.fileshare.models.CopyFileSmbInfo
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["directory"] = kwargs.pop("restype", _params.pop("restype", "directory"))
        comp: Literal["rename"] = kwargs.pop("comp", _params.pop("comp", "rename"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _source_lease_id = None
        _destination_lease_id = None
        _file_attributes = None
        _file_creation_time = None
        _file_last_write_time = None
        _file_change_time = None
        if source_lease_access_conditions is not None:
            _source_lease_id = source_lease_access_conditions.source_lease_id
        if destination_lease_access_conditions is not None:
            _destination_lease_id = destination_lease_access_conditions.destination_lease_id
        if copy_file_smb_info is not None:
            _file_attributes = copy_file_smb_info.file_attributes
            _file_change_time = copy_file_smb_info.file_change_time
            _file_creation_time = copy_file_smb_info.file_creation_time
            _file_last_write_time = copy_file_smb_info.file_last_write_time

        _request = build_rename_request(
            url=self._config.url,
            rename_source=rename_source,
            timeout=timeout,
            replace_if_exists=replace_if_exists,
            ignore_read_only=ignore_read_only,
            source_lease_id=_source_lease_id,
            destination_lease_id=_destination_lease_id,
            file_attributes=_file_attributes,
            file_creation_time=_file_creation_time,
            file_last_write_time=_file_last_write_time,
            file_change_time=_file_change_time,
            file_permission=file_permission,
            file_permission_format=file_permission_format,
            file_permission_key=file_permission_key,
            metadata=metadata,
            allow_trailing_dot=self._config.allow_trailing_dot,
            allow_source_trailing_dot=self._config.allow_source_trailing_dot,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.StorageError,
                pipeline_response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-request-server-encrypted"] = self._deserialize(
            "bool", response.headers.get("x-ms-request-server-encrypted")
        )
        response_headers["x-ms-file-permission-key"] = self._deserialize(
            "str", response.headers.get("x-ms-file-permission-key")
        )
        response_headers["x-ms-file-attributes"] = self._deserialize(
            "str", response.headers.get("x-ms-file-attributes")
        )
        response_headers["x-ms-file-creation-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-creation-time")
        )
        response_headers["x-ms-file-last-write-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-last-write-time")
        )
        response_headers["x-ms-file-change-time"] = self._deserialize(
            "str", response.headers.get("x-ms-file-change-time")
        )
        response_headers["x-ms-file-id"] = self._deserialize("str", response.headers.get("x-ms-file-id"))
        response_headers["x-ms-file-parent-id"] = self._deserialize("str", response.headers.get("x-ms-file-parent-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
