// python wrapper for vtkSMPluginLoaderProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMPluginLoaderProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMPluginLoaderProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMPluginLoaderProxy_ClassNew(); }

#ifndef DECLARED_PyvtkSMProxy_ClassNew
extern "C" { PyObject *PyvtkSMProxy_ClassNew(); }
#define DECLARED_PyvtkSMProxy_ClassNew
#endif

static PyObject *
PyvtkSMPluginLoaderProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMPluginLoaderProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPluginLoaderProxy *op = static_cast<vtkSMPluginLoaderProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMPluginLoaderProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMPluginLoaderProxy *tempr = vtkSMPluginLoaderProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPluginLoaderProxy *op = static_cast<vtkSMPluginLoaderProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMPluginLoaderProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMPluginLoaderProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMPluginLoaderProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPluginLoaderProxy *op = static_cast<vtkSMPluginLoaderProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMPluginLoaderProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_LoadPlugin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPlugin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPluginLoaderProxy *op = static_cast<vtkSMPluginLoaderProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadPlugin(temp0) :
      op->vtkSMPluginLoaderProxy::LoadPlugin(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_LoadPluginByName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginByName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPluginLoaderProxy *op = static_cast<vtkSMPluginLoaderProxy *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadPluginByName(temp0, temp1) :
      op->vtkSMPluginLoaderProxy::LoadPluginByName(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_LoadPluginConfigurationXMLFromString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXMLFromString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPluginLoaderProxy *op = static_cast<vtkSMPluginLoaderProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXMLFromString(temp0);
    }
    else
    {
      op->vtkSMPluginLoaderProxy::LoadPluginConfigurationXMLFromString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPluginLoaderProxy_LoadPluginConfigurationXML(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPluginConfigurationXML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPluginLoaderProxy *op = static_cast<vtkSMPluginLoaderProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadPluginConfigurationXML(temp0);
    }
    else
    {
      op->vtkSMPluginLoaderProxy::LoadPluginConfigurationXML(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMPluginLoaderProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMPluginLoaderProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMPluginLoaderProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMPluginLoaderProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMPluginLoaderProxy\nC++: static vtkSMPluginLoaderProxy *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMPluginLoaderProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMPluginLoaderProxy\nC++: vtkSMPluginLoaderProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMPluginLoaderProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMPluginLoaderProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"LoadPlugin", PyvtkSMPluginLoaderProxy_LoadPlugin, METH_VARARGS,
   "LoadPlugin(self, filename:str) -> bool\nC++: bool LoadPlugin(const char *filename)\n\nLoads the plugin. Returns true on success else false. To get the\nerror string, call UpdatePropertyInformation() on this proxy and\nthen look at the ErrorString property.\n"},
  {"LoadPluginByName", PyvtkSMPluginLoaderProxy_LoadPluginByName, METH_VARARGS,
   "LoadPluginByName(self, name:str, acceptDelayed:bool=True) -> bool\nC++: bool LoadPluginByName(const char *name,\n    bool acceptDelayed=true)\n\nLoads the plugin based on its name. Returns true on success else\nfalse. To get the error string, call UpdatePropertyInformation()\non this proxy and then look at the ErrorString property.\n"},
  {"LoadPluginConfigurationXMLFromString", PyvtkSMPluginLoaderProxy_LoadPluginConfigurationXMLFromString, METH_VARARGS,
   "LoadPluginConfigurationXMLFromString(self, xmlcontents:str)\n    -> None\nC++: void LoadPluginConfigurationXMLFromString(\n    const char *xmlcontents)\n\nLoads the configuration xml contents. Look at\nvtkPVPluginTracker::LoadPluginConfigurationXMLFromString() to see\nthe details about the configuration xml.\n"},
  {"LoadPluginConfigurationXML", PyvtkSMPluginLoaderProxy_LoadPluginConfigurationXML, METH_VARARGS,
   "LoadPluginConfigurationXML(self, configurationFile:str) -> None\nC++: void LoadPluginConfigurationXML(\n    const char *configurationFile)\n\nLoads a configuration xml file. Look at\nvtkPVPluginTracker::LoadPluginConfigurationXML() to see the\ndetails about the configuration xml.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMPluginLoaderProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMPluginLoaderProxy_Doc =
  "vtkSMPluginLoaderProxy - used to load a plugin remotely.\n\n"
  "Superclass: vtkSMProxy\n\n"
  "vtkSMPluginLoaderProxy is used to load a plugin on dataserver and\n"
  "renderserver processes. Simply call\n"
  "vtkSMPluginLoaderProxy::LoadPlugin() with the right path to load the\n"
  "plugin remotely.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMPluginLoaderProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMPluginLoaderProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMPluginLoaderProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMPluginLoaderProxy_StaticNew()
{
  return vtkSMPluginLoaderProxy::New();
}

PyObject *PyvtkSMPluginLoaderProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMPluginLoaderProxy_Type, PyvtkSMPluginLoaderProxy_Methods,
    "vtkSMPluginLoaderProxy",
 &PyvtkSMPluginLoaderProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMProxy_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMPluginLoaderProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMPluginLoaderProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMPluginLoaderProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMPluginLoaderProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

