// python wrapper for vtkCLIOptions
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCLIOptions.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCLIOptions(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCLIOptions_ClassNew(); }


static PyObject *
PyvtkCLIOptions_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCLIOptions::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCLIOptions::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCLIOptions *tempr = vtkCLIOptions::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCLIOptions *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCLIOptions::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCLIOptions::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCLIOptions::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetHelp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHelp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetHelp() :
      op->vtkCLIOptions::GetHelp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_SetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetName(temp0);
    }
    else
    {
      op->vtkCLIOptions::SetName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetName() :
      op->vtkCLIOptions::GetName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_SetDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDescription(temp0);
    }
    else
    {
      op->vtkCLIOptions::SetDescription(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDescription() :
      op->vtkCLIOptions::GetDescription());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_SetAllowExtras(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAllowExtras");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAllowExtras(temp0);
    }
    else
    {
      op->vtkCLIOptions::SetAllowExtras(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetAllowExtras(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllowExtras");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAllowExtras() :
      op->vtkCLIOptions::GetAllowExtras());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_SetStopOnUnrecognizedArgument(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStopOnUnrecognizedArgument");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStopOnUnrecognizedArgument(temp0);
    }
    else
    {
      op->vtkCLIOptions::SetStopOnUnrecognizedArgument(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetStopOnUnrecognizedArgument(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStopOnUnrecognizedArgument");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetStopOnUnrecognizedArgument() :
      op->vtkCLIOptions::GetStopOnUnrecognizedArgument());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_SetGenerateWarnings(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateWarnings");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateWarnings(temp0);
    }
    else
    {
      op->vtkCLIOptions::SetGenerateWarnings(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetGenerateWarnings(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateWarnings");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateWarnings() :
      op->vtkCLIOptions::GetGenerateWarnings());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GenerateWarningsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateWarningsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateWarningsOn();
    }
    else
    {
      op->vtkCLIOptions::GenerateWarningsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GenerateWarningsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateWarningsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateWarningsOff();
    }
    else
    {
      op->vtkCLIOptions::GenerateWarningsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_SetHandleLegacyArgumentFormats(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHandleLegacyArgumentFormats");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHandleLegacyArgumentFormats(temp0);
    }
    else
    {
      op->vtkCLIOptions::SetHandleLegacyArgumentFormats(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetHandleLegacyArgumentFormats(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHandleLegacyArgumentFormats");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHandleLegacyArgumentFormats() :
      op->vtkCLIOptions::GetHandleLegacyArgumentFormats());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_HandleLegacyArgumentFormatsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HandleLegacyArgumentFormatsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HandleLegacyArgumentFormatsOn();
    }
    else
    {
      op->vtkCLIOptions::HandleLegacyArgumentFormatsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_HandleLegacyArgumentFormatsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HandleLegacyArgumentFormatsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HandleLegacyArgumentFormatsOff();
    }
    else
    {
      op->vtkCLIOptions::HandleLegacyArgumentFormatsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetExtraArguments(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtraArguments");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetExtraArguments() :
      &op->vtkCLIOptions::GetExtraArguments());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetLastErrorMessage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastErrorMessage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetLastErrorMessage() :
      &op->vtkCLIOptions::GetLastErrorMessage());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetHelpRequested(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHelpRequested");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHelpRequested() :
      op->vtkCLIOptions::GetHelpRequested());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCLIOptions_GetUsage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUsage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCLIOptions *op = static_cast<vtkCLIOptions *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetUsage() :
      op->vtkCLIOptions::GetUsage());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCLIOptions_Methods[] = {
  {"IsTypeOf", PyvtkCLIOptions_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCLIOptions_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCLIOptions_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCLIOptions\nC++: static vtkCLIOptions *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCLIOptions_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCLIOptions\nC++: vtkCLIOptions *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCLIOptions_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCLIOptions_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetHelp", PyvtkCLIOptions_GetHelp, METH_VARARGS,
   "GetHelp(self) -> str\nC++: const char *GetHelp()\n\nReturns the help string.\n"},
  {"SetName", PyvtkCLIOptions_SetName, METH_VARARGS,
   "SetName(self, name:str) -> None\nC++: void SetName(const char *name)\n\nGet/Set the application name to use. If none specified, one is\nset using the arguments passed to `Parse`.\n"},
  {"GetName", PyvtkCLIOptions_GetName, METH_VARARGS,
   "GetName(self) -> str\nC++: const char *GetName()\n\n"},
  {"SetDescription", PyvtkCLIOptions_SetDescription, METH_VARARGS,
   "SetDescription(self, desc:str) -> None\nC++: void SetDescription(const char *desc)\n\nGet/Set the application description to use.\n"},
  {"GetDescription", PyvtkCLIOptions_GetDescription, METH_VARARGS,
   "GetDescription(self) -> str\nC++: const char *GetDescription()\n\n"},
  {"SetAllowExtras", PyvtkCLIOptions_SetAllowExtras, METH_VARARGS,
   "SetAllowExtras(self, val:bool) -> None\nC++: void SetAllowExtras(bool val)\n\nIndicate whether extra arguments should be allowed/ignored.\nUnparsed arguments can be obtained using `GetExtraArguments`.\n\nForwards to `CLI::App::allow_extras`.\n\nBy default, this is set to true.\n"},
  {"GetAllowExtras", PyvtkCLIOptions_GetAllowExtras, METH_VARARGS,
   "GetAllowExtras(self) -> bool\nC++: bool GetAllowExtras()\n\n"},
  {"SetStopOnUnrecognizedArgument", PyvtkCLIOptions_SetStopOnUnrecognizedArgument, METH_VARARGS,
   "SetStopOnUnrecognizedArgument(self, val:bool) -> None\nC++: void SetStopOnUnrecognizedArgument(bool val)\n\nIndicate whether the parsing should stop as soon as the first\nunrecognized option is detected.\n\nSetting this to false implies to ignore the \"AllowExtras\" status.\n\nForwards to `CLI::App::prefix_command` by inverting the provided\nboolean. Note there seem to be an issue in the documentation for\n`CLI::App::prefix_command` See\nhttps://github.com/CLIUtils/CLI11/issues/1052 for more\ninformation.\n\nBy default, this is set to false.\n"},
  {"GetStopOnUnrecognizedArgument", PyvtkCLIOptions_GetStopOnUnrecognizedArgument, METH_VARARGS,
   "GetStopOnUnrecognizedArgument(self) -> bool\nC++: bool GetStopOnUnrecognizedArgument()\n\n"},
  {"SetGenerateWarnings", PyvtkCLIOptions_SetGenerateWarnings, METH_VARARGS,
   "SetGenerateWarnings(self, _arg:bool) -> None\nC++: virtual void SetGenerateWarnings(bool _arg)\n\nWhen set to true (default), warnings messages are generated with\nincorrectly named short arguments are automatically converted to\nlong arguments.\n@sa SetConvertInvalidShortNamesToLong\n"},
  {"GetGenerateWarnings", PyvtkCLIOptions_GetGenerateWarnings, METH_VARARGS,
   "GetGenerateWarnings(self) -> bool\nC++: virtual bool GetGenerateWarnings()\n\n"},
  {"GenerateWarningsOn", PyvtkCLIOptions_GenerateWarningsOn, METH_VARARGS,
   "GenerateWarningsOn(self) -> None\nC++: virtual void GenerateWarningsOn()\n\n"},
  {"GenerateWarningsOff", PyvtkCLIOptions_GenerateWarningsOff, METH_VARARGS,
   "GenerateWarningsOff(self) -> None\nC++: virtual void GenerateWarningsOff()\n\n"},
  {"SetHandleLegacyArgumentFormats", PyvtkCLIOptions_SetHandleLegacyArgumentFormats, METH_VARARGS,
   "SetHandleLegacyArgumentFormats(self, _arg:bool) -> None\nC++: virtual void SetHandleLegacyArgumentFormats(bool _arg)\n\nWhen set to true (default), attempts to convert legacy forms of\nargument specifications in `Parse`. Currently, the following\ncases are supported:\n\n* Invalid short flags/options for the from `-name` are converted\n  to `--name`.\n* Equals (`=`) used as separator between short option name and\n  its value is replaced by a space (` `).\n\nIf `GenerateWarnings` is true, a warning is raised when any\noption is convert thusly.\n\nNote, these conversions are only performed till the first\npositional separator, `--`, is detected. All arguments after the\nfirst positional separator are left unchanged.\n"},
  {"GetHandleLegacyArgumentFormats", PyvtkCLIOptions_GetHandleLegacyArgumentFormats, METH_VARARGS,
   "GetHandleLegacyArgumentFormats(self) -> bool\nC++: virtual bool GetHandleLegacyArgumentFormats()\n\n"},
  {"HandleLegacyArgumentFormatsOn", PyvtkCLIOptions_HandleLegacyArgumentFormatsOn, METH_VARARGS,
   "HandleLegacyArgumentFormatsOn(self) -> None\nC++: virtual void HandleLegacyArgumentFormatsOn()\n\n"},
  {"HandleLegacyArgumentFormatsOff", PyvtkCLIOptions_HandleLegacyArgumentFormatsOff, METH_VARARGS,
   "HandleLegacyArgumentFormatsOff(self) -> None\nC++: virtual void HandleLegacyArgumentFormatsOff()\n\n"},
  {"GetExtraArguments", PyvtkCLIOptions_GetExtraArguments, METH_VARARGS,
   "GetExtraArguments(self) -> (str, ...)\nC++: const std::vector<std::string> &GetExtraArguments()\n\nReturns unparsed / extra arguments left over from the most reset\n`Parse` call.\n"},
  {"GetLastErrorMessage", PyvtkCLIOptions_GetLastErrorMessage, METH_VARARGS,
   "GetLastErrorMessage(self) -> str\nC++: const std::string &GetLastErrorMessage()\n\nReturns error message from the most recent call to `Parse`, if\nany.\n"},
  {"GetHelpRequested", PyvtkCLIOptions_GetHelpRequested, METH_VARARGS,
   "GetHelpRequested(self) -> bool\nC++: virtual bool GetHelpRequested()\n\nReturns true of help was requested in the most recent call to\n`Parse`.\n"},
  {"GetUsage", PyvtkCLIOptions_GetUsage, METH_VARARGS,
   "GetUsage(self) -> str\nC++: std::string GetUsage()\n\nReturns usage string.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCLIOptions_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCLIOptions_SetName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCLIOptions_SetName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetName/SetName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("description"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetDescription(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCLIOptions_SetDescription(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCLIOptions_SetDescription(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDescription/SetDescription\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("allow_extras"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetAllowExtras(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCLIOptions_SetAllowExtras(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCLIOptions_SetAllowExtras(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAllowExtras/SetAllowExtras\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stop_on_unrecognized_argument"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetStopOnUnrecognizedArgument(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCLIOptions_SetStopOnUnrecognizedArgument(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCLIOptions_SetStopOnUnrecognizedArgument(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStopOnUnrecognizedArgument/SetStopOnUnrecognizedArgument\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_warnings"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetGenerateWarnings(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCLIOptions_SetGenerateWarnings(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCLIOptions_SetGenerateWarnings(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateWarnings/SetGenerateWarnings\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("handle_legacy_argument_formats"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetHandleLegacyArgumentFormats(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCLIOptions_SetHandleLegacyArgumentFormats(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCLIOptions_SetHandleLegacyArgumentFormats(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHandleLegacyArgumentFormats/SetHandleLegacyArgumentFormats\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("help"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetHelp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetHelp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extra_arguments"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetExtraArguments(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetExtraArguments\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_error_message"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetLastErrorMessage(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastErrorMessage\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("help_requested"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetHelpRequested(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetHelpRequested\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("usage"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCLIOptions_GetUsage(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUsage\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCLIOptions_Doc =
  "vtkCLIOptions - command line options manager\n\n"
  "Superclass: vtkObject\n\n"
  "vtkCLIOptions handles command line arguments processing in ParaView.\n"
  "To use, create a `vtkCLIOptions` instance, populate it with available\n"
  "arguments and then call `Parse`. Various modules in ParaView offer\n"
  "ways of populating vtkCLIOptions instance with supported command line\n"
  "arguments. For example:\n\n"
  "vtkNewoptions;\n"
  "vtkProcessModuleConfiguration::GetInstance()->PopulateOptions(options)\n"
  ";\n"
  "vtkRemotingCoreConfiguration::GetInstance()->PopulateOptions(options);\n\n"
  "Applications can add custom configuration classes that expose new\n"
  "command line options and configuration parameters.\n\n"
  "ParaView uses CLI11 for the processing on command line arguments. The\n"
  "CLI11 App can be accessed using `GetCLI11App`. vtkCLIOptions\n"
  "automatically creates a `CLI::App` on instantiation. One can also\n"
  "pass it an existing app using `vtkCLIOptions::New(app)`.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCLIOptions_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsCore.vtkCLIOptions", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCLIOptions_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCLIOptions_StaticNew()
{
  return vtkCLIOptions::New();
}

PyObject *PyvtkCLIOptions_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCLIOptions_Type, PyvtkCLIOptions_Methods,
    "vtkCLIOptions",
 &PyvtkCLIOptions_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCLIOptions_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCLIOptions(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCLIOptions_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCLIOptions", o) != 0)
  {
    Py_DECREF(o);
  }

}

