{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The type of items in a @GtkStringList@.
-- 
-- A @GtkStringObject@ is a wrapper around a @const char*@; it has
-- a [StringObject:string]("GI.Gtk.Objects.StringObject#g:attr:string") property that can be used
-- for property bindings and expressions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.StringObject
    ( 

-- * Exported types
    StringObject(..)                        ,
    IsStringObject                          ,
    toStringObject                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getString]("GI.Gtk.Objects.StringObject#g:method:getString").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveStringObjectMethod               ,
#endif

-- ** getString #method:getString#

#if defined(ENABLE_OVERLOADING)
    StringObjectGetStringMethodInfo         ,
#endif
    stringObjectGetString                   ,


-- ** new #method:new#

    stringObjectNew                         ,




 -- * Properties


-- ** string #attr:string#
-- | The string.

#if defined(ENABLE_OVERLOADING)
    StringObjectStringPropertyInfo          ,
#endif
    getStringObjectString                   ,
#if defined(ENABLE_OVERLOADING)
    stringObjectString                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype StringObject = StringObject (SP.ManagedPtr StringObject)
    deriving (Eq)

instance SP.ManagedPtrNewtype StringObject where
    toManagedPtr (StringObject p) = p

foreign import ccall "gtk_string_object_get_type"
    c_gtk_string_object_get_type :: IO B.Types.GType

instance B.Types.TypedObject StringObject where
    glibType = c_gtk_string_object_get_type

instance B.Types.GObject StringObject

-- | Type class for types which can be safely cast to t'StringObject', for instance with `toStringObject`.
class (SP.GObject o, O.IsDescendantOf StringObject o) => IsStringObject o
instance (SP.GObject o, O.IsDescendantOf StringObject o) => IsStringObject o

instance O.HasParentTypes StringObject
type instance O.ParentTypes StringObject = '[GObject.Object.Object]

-- | Cast to t'StringObject', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toStringObject :: (MIO.MonadIO m, IsStringObject o) => o -> m StringObject
toStringObject = MIO.liftIO . B.ManagedPtr.unsafeCastTo StringObject

-- | Convert t'StringObject' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StringObject) where
    gvalueGType_ = c_gtk_string_object_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr StringObject)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr StringObject)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject StringObject ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStringObjectMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStringObjectMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStringObjectMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStringObjectMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStringObjectMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStringObjectMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStringObjectMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStringObjectMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStringObjectMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStringObjectMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStringObjectMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStringObjectMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStringObjectMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStringObjectMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStringObjectMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStringObjectMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStringObjectMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStringObjectMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStringObjectMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStringObjectMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStringObjectMethod "getString" o = StringObjectGetStringMethodInfo
    ResolveStringObjectMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStringObjectMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStringObjectMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStringObjectMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStringObjectMethod t StringObject, O.OverloadedMethod info StringObject p) => OL.IsLabel t (StringObject -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStringObjectMethod t StringObject, O.OverloadedMethod info StringObject p, R.HasField t StringObject p) => R.HasField t StringObject p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStringObjectMethod t StringObject, O.OverloadedMethodInfo info StringObject) => OL.IsLabel t (O.MethodProxy info StringObject) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "string"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@string@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringObject #string
-- @
getStringObjectString :: (MonadIO m, IsStringObject o) => o -> m T.Text
getStringObjectString obj = MIO.liftIO $ checkUnexpectedNothing "getStringObjectString" $ B.Properties.getObjectPropertyString obj "string"

#if defined(ENABLE_OVERLOADING)
data StringObjectStringPropertyInfo
instance AttrInfo StringObjectStringPropertyInfo where
    type AttrAllowedOps StringObjectStringPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint StringObjectStringPropertyInfo = IsStringObject
    type AttrSetTypeConstraint StringObjectStringPropertyInfo = (~) ()
    type AttrTransferTypeConstraint StringObjectStringPropertyInfo = (~) ()
    type AttrTransferType StringObjectStringPropertyInfo = ()
    type AttrGetType StringObjectStringPropertyInfo = T.Text
    type AttrLabel StringObjectStringPropertyInfo = "string"
    type AttrOrigin StringObjectStringPropertyInfo = StringObject
    attrGet = getStringObjectString
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringObject.string"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringObject.html#g:attr:string"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StringObject
type instance O.AttributeList StringObject = StringObjectAttributeList
type StringObjectAttributeList = ('[ '("string", StringObjectStringPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
stringObjectString :: AttrLabelProxy "string"
stringObjectString = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StringObject = StringObjectSignalList
type StringObjectSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method StringObject::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The string to wrap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "StringObject" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_object_new" gtk_string_object_new :: 
    CString ->                              -- string : TBasicType TUTF8
    IO (Ptr StringObject)

-- | Wraps a string in an object for use with @GListModel@.
stringObjectNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: The string to wrap
    -> m StringObject
    -- ^ __Returns:__ a new @GtkStringObject@
stringObjectNew string = liftIO $ do
    string' <- textToCString string
    result <- gtk_string_object_new string'
    checkUnexpectedReturnNULL "stringObjectNew" result
    result' <- (wrapObject StringObject) result
    freeMem string'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method StringObject::get_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringObject" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringObject`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_object_get_string" gtk_string_object_get_string :: 
    Ptr StringObject ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringObject"})
    IO CString

-- | Returns the string contained in a @GtkStringObject@.
stringObjectGetString ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringObject a) =>
    a
    -- ^ /@self@/: a @GtkStringObject@
    -> m T.Text
    -- ^ __Returns:__ the string of /@self@/
stringObjectGetString self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_object_get_string self'
    checkUnexpectedReturnNULL "stringObjectGetString" result
    result' <- cstringToText result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StringObjectGetStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsStringObject a) => O.OverloadedMethod StringObjectGetStringMethodInfo a signature where
    overloadedMethod = stringObjectGetString

instance O.OverloadedMethodInfo StringObjectGetStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringObject.stringObjectGetString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringObject.html#v:stringObjectGetString"
        })


#endif


