{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A single-line text entry widget for use as a search entry.
-- 
-- The main API for interacting with a @GtkSearchEntry@ as entry
-- is the @GtkEditable@ interface.
-- 
-- \<picture>
--   \<source srcset=\"search-entry-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkSearchEntry\" src=\"search-entry.png\">
-- \<\/picture>
-- 
-- It will show an inactive symbolic “find” icon when the search
-- entry is empty, and a symbolic “clear” icon when there is text.
-- Clicking on the “clear” icon will empty the search entry.
-- 
-- To make filtering appear more reactive, it is a good idea to
-- not react to every change in the entry text immediately, but
-- only after a short delay. To support this, @GtkSearchEntry@
-- emits the [SearchEntry::searchChanged]("GI.Gtk.Objects.SearchEntry#g:signal:searchChanged") signal which
-- can be used instead of the [Editable::changed]("GI.Gtk.Interfaces.Editable#g:signal:changed") signal.
-- 
-- The [SearchEntry::previousMatch]("GI.Gtk.Objects.SearchEntry#g:signal:previousMatch"),
-- [SearchEntry::nextMatch]("GI.Gtk.Objects.SearchEntry#g:signal:nextMatch") and
-- [SearchEntry::stopSearch]("GI.Gtk.Objects.SearchEntry#g:signal:stopSearch") signals can be used to
-- implement moving between search results and ending the search.
-- 
-- Often, @GtkSearchEntry@ will be fed events by means of being
-- placed inside a t'GI.Gtk.Objects.SearchBar.SearchBar'. If that is not the case,
-- you can use 'GI.Gtk.Objects.SearchEntry.searchEntrySetKeyCaptureWidget' to
-- let it capture key input from another widget.
-- 
-- @GtkSearchEntry@ provides only minimal API and should be used with
-- the t'GI.Gtk.Interfaces.Editable.Editable' API.
-- 
-- == Shortcuts and Gestures
-- 
-- The following signals have default keybindings:
-- 
-- * [SearchEntry::activate]("GI.Gtk.Objects.SearchEntry#g:signal:activate")
-- * [SearchEntry::nextMatch]("GI.Gtk.Objects.SearchEntry#g:signal:nextMatch")
-- * [SearchEntry::previousMatch]("GI.Gtk.Objects.SearchEntry#g:signal:previousMatch")
-- * [SearchEntry::stopSearch]("GI.Gtk.Objects.SearchEntry#g:signal:stopSearch")
-- 
-- 
-- == CSS Nodes
-- 
-- 
-- 	
-- >entry.search
-- >╰── text
-- 
-- 
-- @GtkSearchEntry@ has a single CSS node with name entry that carries
-- a @.search@ style class, and the text node is a child of that.
-- 
-- == Accessibility
-- 
-- @GtkSearchEntry@ uses the 'GI.Gtk.Enums.AccessibleRoleSearchBox' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SearchEntry
    ( 

-- * Exported types
    SearchEntry(..)                         ,
    IsSearchEntry                           ,
    toSearchEntry                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [delegateGetAccessiblePlatformState]("GI.Gtk.Interfaces.Editable#g:method:delegateGetAccessiblePlatformState"), [deleteSelection]("GI.Gtk.Interfaces.Editable#g:method:deleteSelection"), [deleteText]("GI.Gtk.Interfaces.Editable#g:method:deleteText"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [finishDelegate]("GI.Gtk.Interfaces.Editable#g:method:finishDelegate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initDelegate]("GI.Gtk.Interfaces.Editable#g:method:initDelegate"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertText]("GI.Gtk.Interfaces.Editable#g:method:insertText"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [selectRegion]("GI.Gtk.Interfaces.Editable#g:method:selectRegion"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAlignment]("GI.Gtk.Interfaces.Editable#g:method:getAlignment"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChars]("GI.Gtk.Interfaces.Editable#g:method:getChars"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDelegate]("GI.Gtk.Interfaces.Editable#g:method:getDelegate"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEditable]("GI.Gtk.Interfaces.Editable#g:method:getEditable"), [getEnableUndo]("GI.Gtk.Interfaces.Editable#g:method:getEnableUndo"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getInputHints]("GI.Gtk.Objects.SearchEntry#g:method:getInputHints"), [getInputPurpose]("GI.Gtk.Objects.SearchEntry#g:method:getInputPurpose"), [getKeyCaptureWidget]("GI.Gtk.Objects.SearchEntry#g:method:getKeyCaptureWidget"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMaxWidthChars]("GI.Gtk.Interfaces.Editable#g:method:getMaxWidthChars"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlaceholderText]("GI.Gtk.Objects.SearchEntry#g:method:getPlaceholderText"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPosition]("GI.Gtk.Interfaces.Editable#g:method:getPosition"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSearchDelay]("GI.Gtk.Objects.SearchEntry#g:method:getSearchDelay"), [getSelectionBounds]("GI.Gtk.Interfaces.Editable#g:method:getSelectionBounds"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getText]("GI.Gtk.Interfaces.Editable#g:method:getText"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getWidthChars]("GI.Gtk.Interfaces.Editable#g:method:getWidthChars").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAlignment]("GI.Gtk.Interfaces.Editable#g:method:setAlignment"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEditable]("GI.Gtk.Interfaces.Editable#g:method:setEditable"), [setEnableUndo]("GI.Gtk.Interfaces.Editable#g:method:setEnableUndo"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setInputHints]("GI.Gtk.Objects.SearchEntry#g:method:setInputHints"), [setInputPurpose]("GI.Gtk.Objects.SearchEntry#g:method:setInputPurpose"), [setKeyCaptureWidget]("GI.Gtk.Objects.SearchEntry#g:method:setKeyCaptureWidget"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMaxWidthChars]("GI.Gtk.Interfaces.Editable#g:method:setMaxWidthChars"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPlaceholderText]("GI.Gtk.Objects.SearchEntry#g:method:setPlaceholderText"), [setPosition]("GI.Gtk.Interfaces.Editable#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSearchDelay]("GI.Gtk.Objects.SearchEntry#g:method:setSearchDelay"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setText]("GI.Gtk.Interfaces.Editable#g:method:setText"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setWidthChars]("GI.Gtk.Interfaces.Editable#g:method:setWidthChars").

#if defined(ENABLE_OVERLOADING)
    ResolveSearchEntryMethod                ,
#endif

-- ** getInputHints #method:getInputHints#

#if defined(ENABLE_OVERLOADING)
    SearchEntryGetInputHintsMethodInfo      ,
#endif
    searchEntryGetInputHints                ,


-- ** getInputPurpose #method:getInputPurpose#

#if defined(ENABLE_OVERLOADING)
    SearchEntryGetInputPurposeMethodInfo    ,
#endif
    searchEntryGetInputPurpose              ,


-- ** getKeyCaptureWidget #method:getKeyCaptureWidget#

#if defined(ENABLE_OVERLOADING)
    SearchEntryGetKeyCaptureWidgetMethodInfo,
#endif
    searchEntryGetKeyCaptureWidget          ,


-- ** getPlaceholderText #method:getPlaceholderText#

#if defined(ENABLE_OVERLOADING)
    SearchEntryGetPlaceholderTextMethodInfo ,
#endif
    searchEntryGetPlaceholderText           ,


-- ** getSearchDelay #method:getSearchDelay#

#if defined(ENABLE_OVERLOADING)
    SearchEntryGetSearchDelayMethodInfo     ,
#endif
    searchEntryGetSearchDelay               ,


-- ** new #method:new#

    searchEntryNew                          ,


-- ** setInputHints #method:setInputHints#

#if defined(ENABLE_OVERLOADING)
    SearchEntrySetInputHintsMethodInfo      ,
#endif
    searchEntrySetInputHints                ,


-- ** setInputPurpose #method:setInputPurpose#

#if defined(ENABLE_OVERLOADING)
    SearchEntrySetInputPurposeMethodInfo    ,
#endif
    searchEntrySetInputPurpose              ,


-- ** setKeyCaptureWidget #method:setKeyCaptureWidget#

#if defined(ENABLE_OVERLOADING)
    SearchEntrySetKeyCaptureWidgetMethodInfo,
#endif
    searchEntrySetKeyCaptureWidget          ,


-- ** setPlaceholderText #method:setPlaceholderText#

#if defined(ENABLE_OVERLOADING)
    SearchEntrySetPlaceholderTextMethodInfo ,
#endif
    searchEntrySetPlaceholderText           ,


-- ** setSearchDelay #method:setSearchDelay#

#if defined(ENABLE_OVERLOADING)
    SearchEntrySetSearchDelayMethodInfo     ,
#endif
    searchEntrySetSearchDelay               ,




 -- * Properties


-- ** activatesDefault #attr:activatesDefault#
-- | Whether to activate the default widget when Enter is pressed.

#if defined(ENABLE_OVERLOADING)
    SearchEntryActivatesDefaultPropertyInfo ,
#endif
    constructSearchEntryActivatesDefault    ,
    getSearchEntryActivatesDefault          ,
#if defined(ENABLE_OVERLOADING)
    searchEntryActivatesDefault             ,
#endif
    setSearchEntryActivatesDefault          ,


-- ** inputHints #attr:inputHints#
-- | The hints about input for the @GtkSearchEntry@ used to alter the
-- behaviour of input methods.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    SearchEntryInputHintsPropertyInfo       ,
#endif
    constructSearchEntryInputHints          ,
    getSearchEntryInputHints                ,
#if defined(ENABLE_OVERLOADING)
    searchEntryInputHints                   ,
#endif
    setSearchEntryInputHints                ,


-- ** inputPurpose #attr:inputPurpose#
-- | The purpose for the @GtkSearchEntry@ input used to alter the
-- behaviour of input methods.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    SearchEntryInputPurposePropertyInfo     ,
#endif
    constructSearchEntryInputPurpose        ,
    getSearchEntryInputPurpose              ,
#if defined(ENABLE_OVERLOADING)
    searchEntryInputPurpose                 ,
#endif
    setSearchEntryInputPurpose              ,


-- ** placeholderText #attr:placeholderText#
-- | The text that will be displayed in the @GtkSearchEntry@
-- when it is empty and unfocused.

#if defined(ENABLE_OVERLOADING)
    SearchEntryPlaceholderTextPropertyInfo  ,
#endif
    clearSearchEntryPlaceholderText         ,
    constructSearchEntryPlaceholderText     ,
    getSearchEntryPlaceholderText           ,
#if defined(ENABLE_OVERLOADING)
    searchEntryPlaceholderText              ,
#endif
    setSearchEntryPlaceholderText           ,


-- ** searchDelay #attr:searchDelay#
-- | The delay in milliseconds from last keypress to the search
-- changed signal.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    SearchEntrySearchDelayPropertyInfo      ,
#endif
    constructSearchEntrySearchDelay         ,
    getSearchEntrySearchDelay               ,
#if defined(ENABLE_OVERLOADING)
    searchEntrySearchDelay                  ,
#endif
    setSearchEntrySearchDelay               ,




 -- * Signals


-- ** activate #signal:activate#

    SearchEntryActivateCallback             ,
#if defined(ENABLE_OVERLOADING)
    SearchEntryActivateSignalInfo           ,
#endif
    afterSearchEntryActivate                ,
    onSearchEntryActivate                   ,


-- ** nextMatch #signal:nextMatch#

    SearchEntryNextMatchCallback            ,
#if defined(ENABLE_OVERLOADING)
    SearchEntryNextMatchSignalInfo          ,
#endif
    afterSearchEntryNextMatch               ,
    onSearchEntryNextMatch                  ,


-- ** previousMatch #signal:previousMatch#

    SearchEntryPreviousMatchCallback        ,
#if defined(ENABLE_OVERLOADING)
    SearchEntryPreviousMatchSignalInfo      ,
#endif
    afterSearchEntryPreviousMatch           ,
    onSearchEntryPreviousMatch              ,


-- ** searchChanged #signal:searchChanged#

    SearchEntrySearchChangedCallback        ,
#if defined(ENABLE_OVERLOADING)
    SearchEntrySearchChangedSignalInfo      ,
#endif
    afterSearchEntrySearchChanged           ,
    onSearchEntrySearchChanged              ,


-- ** searchStarted #signal:searchStarted#

    SearchEntrySearchStartedCallback        ,
#if defined(ENABLE_OVERLOADING)
    SearchEntrySearchStartedSignalInfo      ,
#endif
    afterSearchEntrySearchStarted           ,
    onSearchEntrySearchStarted              ,


-- ** stopSearch #signal:stopSearch#

    SearchEntryStopSearchCallback           ,
#if defined(ENABLE_OVERLOADING)
    SearchEntryStopSearchSignalInfo         ,
#endif
    afterSearchEntryStopSearch              ,
    onSearchEntryStopSearch                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ObjectClass as GObject.ObjectClass
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype SearchEntry = SearchEntry (SP.ManagedPtr SearchEntry)
    deriving (Eq)

instance SP.ManagedPtrNewtype SearchEntry where
    toManagedPtr (SearchEntry p) = p

foreign import ccall "gtk_search_entry_get_type"
    c_gtk_search_entry_get_type :: IO B.Types.GType

instance B.Types.TypedObject SearchEntry where
    glibType = c_gtk_search_entry_get_type

instance B.Types.GObject SearchEntry

-- | Type class for types which can be safely cast to t'SearchEntry', for instance with `toSearchEntry`.
class (SP.GObject o, O.IsDescendantOf SearchEntry o) => IsSearchEntry o
instance (SP.GObject o, O.IsDescendantOf SearchEntry o) => IsSearchEntry o

instance O.HasParentTypes SearchEntry
type instance O.ParentTypes SearchEntry = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Editable.Editable]

-- | Cast to t'SearchEntry', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSearchEntry :: (MIO.MonadIO m, IsSearchEntry o) => o -> m SearchEntry
toSearchEntry = MIO.liftIO . B.ManagedPtr.unsafeCastTo SearchEntry

-- | Convert t'SearchEntry' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SearchEntry) where
    gvalueGType_ = c_gtk_search_entry_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SearchEntry)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SearchEntry)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SearchEntry ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSearchEntryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSearchEntryMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveSearchEntryMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveSearchEntryMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveSearchEntryMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveSearchEntryMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveSearchEntryMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveSearchEntryMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveSearchEntryMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveSearchEntryMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveSearchEntryMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveSearchEntryMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSearchEntryMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSearchEntryMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveSearchEntryMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveSearchEntryMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveSearchEntryMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveSearchEntryMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveSearchEntryMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveSearchEntryMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveSearchEntryMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveSearchEntryMethod "delegateGetAccessiblePlatformState" o = Gtk.Editable.EditableDelegateGetAccessiblePlatformStateMethodInfo
    ResolveSearchEntryMethod "deleteSelection" o = Gtk.Editable.EditableDeleteSelectionMethodInfo
    ResolveSearchEntryMethod "deleteText" o = Gtk.Editable.EditableDeleteTextMethodInfo
    ResolveSearchEntryMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveSearchEntryMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveSearchEntryMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveSearchEntryMethod "finishDelegate" o = Gtk.Editable.EditableFinishDelegateMethodInfo
    ResolveSearchEntryMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSearchEntryMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSearchEntryMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSearchEntryMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveSearchEntryMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveSearchEntryMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveSearchEntryMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveSearchEntryMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveSearchEntryMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveSearchEntryMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveSearchEntryMethod "initDelegate" o = Gtk.Editable.EditableInitDelegateMethodInfo
    ResolveSearchEntryMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveSearchEntryMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveSearchEntryMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveSearchEntryMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveSearchEntryMethod "insertText" o = Gtk.Editable.EditableInsertTextMethodInfo
    ResolveSearchEntryMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveSearchEntryMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveSearchEntryMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSearchEntryMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveSearchEntryMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveSearchEntryMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveSearchEntryMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveSearchEntryMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveSearchEntryMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveSearchEntryMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveSearchEntryMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveSearchEntryMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSearchEntryMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSearchEntryMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveSearchEntryMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveSearchEntryMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveSearchEntryMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveSearchEntryMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveSearchEntryMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveSearchEntryMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveSearchEntryMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSearchEntryMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSearchEntryMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveSearchEntryMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveSearchEntryMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveSearchEntryMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveSearchEntryMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveSearchEntryMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveSearchEntryMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveSearchEntryMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSearchEntryMethod "selectRegion" o = Gtk.Editable.EditableSelectRegionMethodInfo
    ResolveSearchEntryMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveSearchEntryMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveSearchEntryMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveSearchEntryMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveSearchEntryMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSearchEntryMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSearchEntryMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSearchEntryMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveSearchEntryMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveSearchEntryMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveSearchEntryMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveSearchEntryMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveSearchEntryMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSearchEntryMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveSearchEntryMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveSearchEntryMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveSearchEntryMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveSearchEntryMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveSearchEntryMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveSearchEntryMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSearchEntryMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveSearchEntryMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveSearchEntryMethod "getAlignment" o = Gtk.Editable.EditableGetAlignmentMethodInfo
    ResolveSearchEntryMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveSearchEntryMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveSearchEntryMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveSearchEntryMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveSearchEntryMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveSearchEntryMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveSearchEntryMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveSearchEntryMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveSearchEntryMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveSearchEntryMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveSearchEntryMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveSearchEntryMethod "getChars" o = Gtk.Editable.EditableGetCharsMethodInfo
    ResolveSearchEntryMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveSearchEntryMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveSearchEntryMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveSearchEntryMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveSearchEntryMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveSearchEntryMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveSearchEntryMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSearchEntryMethod "getDelegate" o = Gtk.Editable.EditableGetDelegateMethodInfo
    ResolveSearchEntryMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveSearchEntryMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveSearchEntryMethod "getEditable" o = Gtk.Editable.EditableGetEditableMethodInfo
    ResolveSearchEntryMethod "getEnableUndo" o = Gtk.Editable.EditableGetEnableUndoMethodInfo
    ResolveSearchEntryMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveSearchEntryMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveSearchEntryMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveSearchEntryMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveSearchEntryMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveSearchEntryMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveSearchEntryMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveSearchEntryMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveSearchEntryMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveSearchEntryMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveSearchEntryMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveSearchEntryMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveSearchEntryMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveSearchEntryMethod "getInputHints" o = SearchEntryGetInputHintsMethodInfo
    ResolveSearchEntryMethod "getInputPurpose" o = SearchEntryGetInputPurposeMethodInfo
    ResolveSearchEntryMethod "getKeyCaptureWidget" o = SearchEntryGetKeyCaptureWidgetMethodInfo
    ResolveSearchEntryMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveSearchEntryMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveSearchEntryMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveSearchEntryMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveSearchEntryMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveSearchEntryMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveSearchEntryMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveSearchEntryMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveSearchEntryMethod "getMaxWidthChars" o = Gtk.Editable.EditableGetMaxWidthCharsMethodInfo
    ResolveSearchEntryMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveSearchEntryMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveSearchEntryMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveSearchEntryMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveSearchEntryMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveSearchEntryMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveSearchEntryMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveSearchEntryMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveSearchEntryMethod "getPlaceholderText" o = SearchEntryGetPlaceholderTextMethodInfo
    ResolveSearchEntryMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveSearchEntryMethod "getPosition" o = Gtk.Editable.EditableGetPositionMethodInfo
    ResolveSearchEntryMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveSearchEntryMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveSearchEntryMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveSearchEntryMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSearchEntryMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSearchEntryMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveSearchEntryMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveSearchEntryMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveSearchEntryMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveSearchEntryMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveSearchEntryMethod "getSearchDelay" o = SearchEntryGetSearchDelayMethodInfo
    ResolveSearchEntryMethod "getSelectionBounds" o = Gtk.Editable.EditableGetSelectionBoundsMethodInfo
    ResolveSearchEntryMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveSearchEntryMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveSearchEntryMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveSearchEntryMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveSearchEntryMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveSearchEntryMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveSearchEntryMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveSearchEntryMethod "getText" o = Gtk.Editable.EditableGetTextMethodInfo
    ResolveSearchEntryMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveSearchEntryMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveSearchEntryMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveSearchEntryMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveSearchEntryMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveSearchEntryMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveSearchEntryMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveSearchEntryMethod "getWidthChars" o = Gtk.Editable.EditableGetWidthCharsMethodInfo
    ResolveSearchEntryMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveSearchEntryMethod "setAlignment" o = Gtk.Editable.EditableSetAlignmentMethodInfo
    ResolveSearchEntryMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveSearchEntryMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveSearchEntryMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveSearchEntryMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveSearchEntryMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveSearchEntryMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveSearchEntryMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSearchEntryMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSearchEntryMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveSearchEntryMethod "setEditable" o = Gtk.Editable.EditableSetEditableMethodInfo
    ResolveSearchEntryMethod "setEnableUndo" o = Gtk.Editable.EditableSetEnableUndoMethodInfo
    ResolveSearchEntryMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveSearchEntryMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveSearchEntryMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveSearchEntryMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveSearchEntryMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveSearchEntryMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveSearchEntryMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveSearchEntryMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveSearchEntryMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveSearchEntryMethod "setInputHints" o = SearchEntrySetInputHintsMethodInfo
    ResolveSearchEntryMethod "setInputPurpose" o = SearchEntrySetInputPurposeMethodInfo
    ResolveSearchEntryMethod "setKeyCaptureWidget" o = SearchEntrySetKeyCaptureWidgetMethodInfo
    ResolveSearchEntryMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveSearchEntryMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveSearchEntryMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveSearchEntryMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveSearchEntryMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveSearchEntryMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveSearchEntryMethod "setMaxWidthChars" o = Gtk.Editable.EditableSetMaxWidthCharsMethodInfo
    ResolveSearchEntryMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveSearchEntryMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveSearchEntryMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveSearchEntryMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveSearchEntryMethod "setPlaceholderText" o = SearchEntrySetPlaceholderTextMethodInfo
    ResolveSearchEntryMethod "setPosition" o = Gtk.Editable.EditableSetPositionMethodInfo
    ResolveSearchEntryMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSearchEntryMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveSearchEntryMethod "setSearchDelay" o = SearchEntrySetSearchDelayMethodInfo
    ResolveSearchEntryMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveSearchEntryMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveSearchEntryMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveSearchEntryMethod "setText" o = Gtk.Editable.EditableSetTextMethodInfo
    ResolveSearchEntryMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveSearchEntryMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveSearchEntryMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveSearchEntryMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveSearchEntryMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveSearchEntryMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveSearchEntryMethod "setWidthChars" o = Gtk.Editable.EditableSetWidthCharsMethodInfo
    ResolveSearchEntryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSearchEntryMethod t SearchEntry, O.OverloadedMethod info SearchEntry p) => OL.IsLabel t (SearchEntry -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSearchEntryMethod t SearchEntry, O.OverloadedMethod info SearchEntry p, R.HasField t SearchEntry p) => R.HasField t SearchEntry p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSearchEntryMethod t SearchEntry, O.OverloadedMethodInfo info SearchEntry) => OL.IsLabel t (O.MethodProxy info SearchEntry) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SearchEntry::activate
-- | Emitted when the entry is activated.
-- 
-- The keybindings for this signal are all forms of the \<kbd>Enter\<\/kbd> key.
type SearchEntryActivateCallback =
    IO ()

type C_SearchEntryActivateCallback =
    Ptr SearchEntry ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SearchEntryActivateCallback`.
foreign import ccall "wrapper"
    mk_SearchEntryActivateCallback :: C_SearchEntryActivateCallback -> IO (FunPtr C_SearchEntryActivateCallback)

wrap_SearchEntryActivateCallback :: 
    GObject a => (a -> SearchEntryActivateCallback) ->
    C_SearchEntryActivateCallback
wrap_SearchEntryActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' searchEntry #activate callback
-- @
-- 
-- 
onSearchEntryActivate :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryActivateCallback) -> m SignalHandlerId
onSearchEntryActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryActivateCallback wrapped
    wrapped'' <- mk_SearchEntryActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' searchEntry #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSearchEntryActivate :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryActivateCallback) -> m SignalHandlerId
afterSearchEntryActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryActivateCallback wrapped
    wrapped'' <- mk_SearchEntryActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SearchEntryActivateSignalInfo
instance SignalInfo SearchEntryActivateSignalInfo where
    type HaskellCallbackType SearchEntryActivateSignalInfo = SearchEntryActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SearchEntryActivateCallback cb
        cb'' <- mk_SearchEntryActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:signal:activate"})

#endif

-- signal SearchEntry::next-match
-- | Emitted when the user initiates a move to the next match
-- for the current search string.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- Applications should connect to it, to implement moving
-- between matches.
-- 
-- The default bindings for this signal is \<kbd>Ctrl\<\/kbd>+\<kbd>g\<\/kbd>.
type SearchEntryNextMatchCallback =
    IO ()

type C_SearchEntryNextMatchCallback =
    Ptr SearchEntry ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SearchEntryNextMatchCallback`.
foreign import ccall "wrapper"
    mk_SearchEntryNextMatchCallback :: C_SearchEntryNextMatchCallback -> IO (FunPtr C_SearchEntryNextMatchCallback)

wrap_SearchEntryNextMatchCallback :: 
    GObject a => (a -> SearchEntryNextMatchCallback) ->
    C_SearchEntryNextMatchCallback
wrap_SearchEntryNextMatchCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [nextMatch](#signal:nextMatch) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' searchEntry #nextMatch callback
-- @
-- 
-- 
onSearchEntryNextMatch :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryNextMatchCallback) -> m SignalHandlerId
onSearchEntryNextMatch obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryNextMatchCallback wrapped
    wrapped'' <- mk_SearchEntryNextMatchCallback wrapped'
    connectSignalFunPtr obj "next-match" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [nextMatch](#signal:nextMatch) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' searchEntry #nextMatch callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSearchEntryNextMatch :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryNextMatchCallback) -> m SignalHandlerId
afterSearchEntryNextMatch obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryNextMatchCallback wrapped
    wrapped'' <- mk_SearchEntryNextMatchCallback wrapped'
    connectSignalFunPtr obj "next-match" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SearchEntryNextMatchSignalInfo
instance SignalInfo SearchEntryNextMatchSignalInfo where
    type HaskellCallbackType SearchEntryNextMatchSignalInfo = SearchEntryNextMatchCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SearchEntryNextMatchCallback cb
        cb'' <- mk_SearchEntryNextMatchCallback cb'
        connectSignalFunPtr obj "next-match" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry::next-match"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:signal:nextMatch"})

#endif

-- signal SearchEntry::previous-match
-- | Emitted when the user initiates a move to the previous match
-- for the current search string.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- Applications should connect to it, to implement moving
-- between matches.
-- 
-- The default bindings for this signal is
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>g\<\/kbd>.
type SearchEntryPreviousMatchCallback =
    IO ()

type C_SearchEntryPreviousMatchCallback =
    Ptr SearchEntry ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SearchEntryPreviousMatchCallback`.
foreign import ccall "wrapper"
    mk_SearchEntryPreviousMatchCallback :: C_SearchEntryPreviousMatchCallback -> IO (FunPtr C_SearchEntryPreviousMatchCallback)

wrap_SearchEntryPreviousMatchCallback :: 
    GObject a => (a -> SearchEntryPreviousMatchCallback) ->
    C_SearchEntryPreviousMatchCallback
wrap_SearchEntryPreviousMatchCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [previousMatch](#signal:previousMatch) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' searchEntry #previousMatch callback
-- @
-- 
-- 
onSearchEntryPreviousMatch :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryPreviousMatchCallback) -> m SignalHandlerId
onSearchEntryPreviousMatch obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryPreviousMatchCallback wrapped
    wrapped'' <- mk_SearchEntryPreviousMatchCallback wrapped'
    connectSignalFunPtr obj "previous-match" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [previousMatch](#signal:previousMatch) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' searchEntry #previousMatch callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSearchEntryPreviousMatch :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryPreviousMatchCallback) -> m SignalHandlerId
afterSearchEntryPreviousMatch obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryPreviousMatchCallback wrapped
    wrapped'' <- mk_SearchEntryPreviousMatchCallback wrapped'
    connectSignalFunPtr obj "previous-match" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SearchEntryPreviousMatchSignalInfo
instance SignalInfo SearchEntryPreviousMatchSignalInfo where
    type HaskellCallbackType SearchEntryPreviousMatchSignalInfo = SearchEntryPreviousMatchCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SearchEntryPreviousMatchCallback cb
        cb'' <- mk_SearchEntryPreviousMatchCallback cb'
        connectSignalFunPtr obj "previous-match" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry::previous-match"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:signal:previousMatch"})

#endif

-- signal SearchEntry::search-changed
-- | Emitted with a delay. The length of the delay can be
-- changed with the [SearchEntry:searchDelay]("GI.Gtk.Objects.SearchEntry#g:attr:searchDelay")
-- property.
type SearchEntrySearchChangedCallback =
    IO ()

type C_SearchEntrySearchChangedCallback =
    Ptr SearchEntry ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SearchEntrySearchChangedCallback`.
foreign import ccall "wrapper"
    mk_SearchEntrySearchChangedCallback :: C_SearchEntrySearchChangedCallback -> IO (FunPtr C_SearchEntrySearchChangedCallback)

wrap_SearchEntrySearchChangedCallback :: 
    GObject a => (a -> SearchEntrySearchChangedCallback) ->
    C_SearchEntrySearchChangedCallback
wrap_SearchEntrySearchChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [searchChanged](#signal:searchChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' searchEntry #searchChanged callback
-- @
-- 
-- 
onSearchEntrySearchChanged :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntrySearchChangedCallback) -> m SignalHandlerId
onSearchEntrySearchChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntrySearchChangedCallback wrapped
    wrapped'' <- mk_SearchEntrySearchChangedCallback wrapped'
    connectSignalFunPtr obj "search-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [searchChanged](#signal:searchChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' searchEntry #searchChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSearchEntrySearchChanged :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntrySearchChangedCallback) -> m SignalHandlerId
afterSearchEntrySearchChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntrySearchChangedCallback wrapped
    wrapped'' <- mk_SearchEntrySearchChangedCallback wrapped'
    connectSignalFunPtr obj "search-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SearchEntrySearchChangedSignalInfo
instance SignalInfo SearchEntrySearchChangedSignalInfo where
    type HaskellCallbackType SearchEntrySearchChangedSignalInfo = SearchEntrySearchChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SearchEntrySearchChangedCallback cb
        cb'' <- mk_SearchEntrySearchChangedCallback cb'
        connectSignalFunPtr obj "search-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry::search-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:signal:searchChanged"})

#endif

-- signal SearchEntry::search-started
-- | Emitted when the user initiated a search on the entry.
type SearchEntrySearchStartedCallback =
    IO ()

type C_SearchEntrySearchStartedCallback =
    Ptr SearchEntry ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SearchEntrySearchStartedCallback`.
foreign import ccall "wrapper"
    mk_SearchEntrySearchStartedCallback :: C_SearchEntrySearchStartedCallback -> IO (FunPtr C_SearchEntrySearchStartedCallback)

wrap_SearchEntrySearchStartedCallback :: 
    GObject a => (a -> SearchEntrySearchStartedCallback) ->
    C_SearchEntrySearchStartedCallback
wrap_SearchEntrySearchStartedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [searchStarted](#signal:searchStarted) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' searchEntry #searchStarted callback
-- @
-- 
-- 
onSearchEntrySearchStarted :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntrySearchStartedCallback) -> m SignalHandlerId
onSearchEntrySearchStarted obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntrySearchStartedCallback wrapped
    wrapped'' <- mk_SearchEntrySearchStartedCallback wrapped'
    connectSignalFunPtr obj "search-started" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [searchStarted](#signal:searchStarted) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' searchEntry #searchStarted callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSearchEntrySearchStarted :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntrySearchStartedCallback) -> m SignalHandlerId
afterSearchEntrySearchStarted obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntrySearchStartedCallback wrapped
    wrapped'' <- mk_SearchEntrySearchStartedCallback wrapped'
    connectSignalFunPtr obj "search-started" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SearchEntrySearchStartedSignalInfo
instance SignalInfo SearchEntrySearchStartedSignalInfo where
    type HaskellCallbackType SearchEntrySearchStartedSignalInfo = SearchEntrySearchStartedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SearchEntrySearchStartedCallback cb
        cb'' <- mk_SearchEntrySearchStartedCallback cb'
        connectSignalFunPtr obj "search-started" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry::search-started"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:signal:searchStarted"})

#endif

-- signal SearchEntry::stop-search
-- | Emitted when the user stops a search via keyboard input.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- Applications should connect to it, to implement hiding
-- the search entry in this case.
-- 
-- The default bindings for this signal is \<kbd>Escape\<\/kbd>.
type SearchEntryStopSearchCallback =
    IO ()

type C_SearchEntryStopSearchCallback =
    Ptr SearchEntry ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SearchEntryStopSearchCallback`.
foreign import ccall "wrapper"
    mk_SearchEntryStopSearchCallback :: C_SearchEntryStopSearchCallback -> IO (FunPtr C_SearchEntryStopSearchCallback)

wrap_SearchEntryStopSearchCallback :: 
    GObject a => (a -> SearchEntryStopSearchCallback) ->
    C_SearchEntryStopSearchCallback
wrap_SearchEntryStopSearchCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [stopSearch](#signal:stopSearch) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' searchEntry #stopSearch callback
-- @
-- 
-- 
onSearchEntryStopSearch :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryStopSearchCallback) -> m SignalHandlerId
onSearchEntryStopSearch obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryStopSearchCallback wrapped
    wrapped'' <- mk_SearchEntryStopSearchCallback wrapped'
    connectSignalFunPtr obj "stop-search" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [stopSearch](#signal:stopSearch) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' searchEntry #stopSearch callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSearchEntryStopSearch :: (IsSearchEntry a, MonadIO m) => a -> ((?self :: a) => SearchEntryStopSearchCallback) -> m SignalHandlerId
afterSearchEntryStopSearch obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SearchEntryStopSearchCallback wrapped
    wrapped'' <- mk_SearchEntryStopSearchCallback wrapped'
    connectSignalFunPtr obj "stop-search" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SearchEntryStopSearchSignalInfo
instance SignalInfo SearchEntryStopSearchSignalInfo where
    type HaskellCallbackType SearchEntryStopSearchSignalInfo = SearchEntryStopSearchCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SearchEntryStopSearchCallback cb
        cb'' <- mk_SearchEntryStopSearchCallback cb'
        connectSignalFunPtr obj "stop-search" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry::stop-search"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:signal:stopSearch"})

#endif

-- VVV Prop "activates-default"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@activates-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchEntry #activatesDefault
-- @
getSearchEntryActivatesDefault :: (MonadIO m, IsSearchEntry o) => o -> m Bool
getSearchEntryActivatesDefault obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "activates-default"

-- | Set the value of the “@activates-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchEntry [ #activatesDefault 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchEntryActivatesDefault :: (MonadIO m, IsSearchEntry o) => o -> Bool -> m ()
setSearchEntryActivatesDefault obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "activates-default" val

-- | Construct a t'GValueConstruct' with valid value for the “@activates-default@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchEntryActivatesDefault :: (IsSearchEntry o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSearchEntryActivatesDefault val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "activates-default" val

#if defined(ENABLE_OVERLOADING)
data SearchEntryActivatesDefaultPropertyInfo
instance AttrInfo SearchEntryActivatesDefaultPropertyInfo where
    type AttrAllowedOps SearchEntryActivatesDefaultPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SearchEntryActivatesDefaultPropertyInfo = IsSearchEntry
    type AttrSetTypeConstraint SearchEntryActivatesDefaultPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SearchEntryActivatesDefaultPropertyInfo = (~) Bool
    type AttrTransferType SearchEntryActivatesDefaultPropertyInfo = Bool
    type AttrGetType SearchEntryActivatesDefaultPropertyInfo = Bool
    type AttrLabel SearchEntryActivatesDefaultPropertyInfo = "activates-default"
    type AttrOrigin SearchEntryActivatesDefaultPropertyInfo = SearchEntry
    attrGet = getSearchEntryActivatesDefault
    attrSet = setSearchEntryActivatesDefault
    attrTransfer _ v = do
        return v
    attrConstruct = constructSearchEntryActivatesDefault
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.activatesDefault"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:attr:activatesDefault"
        })
#endif

-- VVV Prop "input-hints"
   -- Type: TInterface (Name {namespace = "Gtk", name = "InputHints"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@input-hints@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchEntry #inputHints
-- @
getSearchEntryInputHints :: (MonadIO m, IsSearchEntry o) => o -> m [Gtk.Flags.InputHints]
getSearchEntryInputHints obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "input-hints"

-- | Set the value of the “@input-hints@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchEntry [ #inputHints 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchEntryInputHints :: (MonadIO m, IsSearchEntry o) => o -> [Gtk.Flags.InputHints] -> m ()
setSearchEntryInputHints obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "input-hints" val

-- | Construct a t'GValueConstruct' with valid value for the “@input-hints@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchEntryInputHints :: (IsSearchEntry o, MIO.MonadIO m) => [Gtk.Flags.InputHints] -> m (GValueConstruct o)
constructSearchEntryInputHints val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "input-hints" val

#if defined(ENABLE_OVERLOADING)
data SearchEntryInputHintsPropertyInfo
instance AttrInfo SearchEntryInputHintsPropertyInfo where
    type AttrAllowedOps SearchEntryInputHintsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SearchEntryInputHintsPropertyInfo = IsSearchEntry
    type AttrSetTypeConstraint SearchEntryInputHintsPropertyInfo = (~) [Gtk.Flags.InputHints]
    type AttrTransferTypeConstraint SearchEntryInputHintsPropertyInfo = (~) [Gtk.Flags.InputHints]
    type AttrTransferType SearchEntryInputHintsPropertyInfo = [Gtk.Flags.InputHints]
    type AttrGetType SearchEntryInputHintsPropertyInfo = [Gtk.Flags.InputHints]
    type AttrLabel SearchEntryInputHintsPropertyInfo = "input-hints"
    type AttrOrigin SearchEntryInputHintsPropertyInfo = SearchEntry
    attrGet = getSearchEntryInputHints
    attrSet = setSearchEntryInputHints
    attrTransfer _ v = do
        return v
    attrConstruct = constructSearchEntryInputHints
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.inputHints"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:attr:inputHints"
        })
#endif

-- VVV Prop "input-purpose"
   -- Type: TInterface (Name {namespace = "Gtk", name = "InputPurpose"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@input-purpose@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchEntry #inputPurpose
-- @
getSearchEntryInputPurpose :: (MonadIO m, IsSearchEntry o) => o -> m Gtk.Enums.InputPurpose
getSearchEntryInputPurpose obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "input-purpose"

-- | Set the value of the “@input-purpose@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchEntry [ #inputPurpose 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchEntryInputPurpose :: (MonadIO m, IsSearchEntry o) => o -> Gtk.Enums.InputPurpose -> m ()
setSearchEntryInputPurpose obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "input-purpose" val

-- | Construct a t'GValueConstruct' with valid value for the “@input-purpose@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchEntryInputPurpose :: (IsSearchEntry o, MIO.MonadIO m) => Gtk.Enums.InputPurpose -> m (GValueConstruct o)
constructSearchEntryInputPurpose val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "input-purpose" val

#if defined(ENABLE_OVERLOADING)
data SearchEntryInputPurposePropertyInfo
instance AttrInfo SearchEntryInputPurposePropertyInfo where
    type AttrAllowedOps SearchEntryInputPurposePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SearchEntryInputPurposePropertyInfo = IsSearchEntry
    type AttrSetTypeConstraint SearchEntryInputPurposePropertyInfo = (~) Gtk.Enums.InputPurpose
    type AttrTransferTypeConstraint SearchEntryInputPurposePropertyInfo = (~) Gtk.Enums.InputPurpose
    type AttrTransferType SearchEntryInputPurposePropertyInfo = Gtk.Enums.InputPurpose
    type AttrGetType SearchEntryInputPurposePropertyInfo = Gtk.Enums.InputPurpose
    type AttrLabel SearchEntryInputPurposePropertyInfo = "input-purpose"
    type AttrOrigin SearchEntryInputPurposePropertyInfo = SearchEntry
    attrGet = getSearchEntryInputPurpose
    attrSet = setSearchEntryInputPurpose
    attrTransfer _ v = do
        return v
    attrConstruct = constructSearchEntryInputPurpose
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.inputPurpose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:attr:inputPurpose"
        })
#endif

-- VVV Prop "placeholder-text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@placeholder-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchEntry #placeholderText
-- @
getSearchEntryPlaceholderText :: (MonadIO m, IsSearchEntry o) => o -> m (Maybe T.Text)
getSearchEntryPlaceholderText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "placeholder-text"

-- | Set the value of the “@placeholder-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchEntry [ #placeholderText 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchEntryPlaceholderText :: (MonadIO m, IsSearchEntry o) => o -> T.Text -> m ()
setSearchEntryPlaceholderText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "placeholder-text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@placeholder-text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchEntryPlaceholderText :: (IsSearchEntry o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructSearchEntryPlaceholderText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "placeholder-text" (P.Just val)

-- | Set the value of the “@placeholder-text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #placeholderText
-- @
clearSearchEntryPlaceholderText :: (MonadIO m, IsSearchEntry o) => o -> m ()
clearSearchEntryPlaceholderText obj = liftIO $ B.Properties.setObjectPropertyString obj "placeholder-text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data SearchEntryPlaceholderTextPropertyInfo
instance AttrInfo SearchEntryPlaceholderTextPropertyInfo where
    type AttrAllowedOps SearchEntryPlaceholderTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SearchEntryPlaceholderTextPropertyInfo = IsSearchEntry
    type AttrSetTypeConstraint SearchEntryPlaceholderTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint SearchEntryPlaceholderTextPropertyInfo = (~) T.Text
    type AttrTransferType SearchEntryPlaceholderTextPropertyInfo = T.Text
    type AttrGetType SearchEntryPlaceholderTextPropertyInfo = (Maybe T.Text)
    type AttrLabel SearchEntryPlaceholderTextPropertyInfo = "placeholder-text"
    type AttrOrigin SearchEntryPlaceholderTextPropertyInfo = SearchEntry
    attrGet = getSearchEntryPlaceholderText
    attrSet = setSearchEntryPlaceholderText
    attrTransfer _ v = do
        return v
    attrConstruct = constructSearchEntryPlaceholderText
    attrClear = clearSearchEntryPlaceholderText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.placeholderText"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:attr:placeholderText"
        })
#endif

-- VVV Prop "search-delay"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@search-delay@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' searchEntry #searchDelay
-- @
getSearchEntrySearchDelay :: (MonadIO m, IsSearchEntry o) => o -> m Word32
getSearchEntrySearchDelay obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "search-delay"

-- | Set the value of the “@search-delay@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' searchEntry [ #searchDelay 'Data.GI.Base.Attributes.:=' value ]
-- @
setSearchEntrySearchDelay :: (MonadIO m, IsSearchEntry o) => o -> Word32 -> m ()
setSearchEntrySearchDelay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "search-delay" val

-- | Construct a t'GValueConstruct' with valid value for the “@search-delay@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSearchEntrySearchDelay :: (IsSearchEntry o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructSearchEntrySearchDelay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "search-delay" val

#if defined(ENABLE_OVERLOADING)
data SearchEntrySearchDelayPropertyInfo
instance AttrInfo SearchEntrySearchDelayPropertyInfo where
    type AttrAllowedOps SearchEntrySearchDelayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SearchEntrySearchDelayPropertyInfo = IsSearchEntry
    type AttrSetTypeConstraint SearchEntrySearchDelayPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint SearchEntrySearchDelayPropertyInfo = (~) Word32
    type AttrTransferType SearchEntrySearchDelayPropertyInfo = Word32
    type AttrGetType SearchEntrySearchDelayPropertyInfo = Word32
    type AttrLabel SearchEntrySearchDelayPropertyInfo = "search-delay"
    type AttrOrigin SearchEntrySearchDelayPropertyInfo = SearchEntry
    attrGet = getSearchEntrySearchDelay
    attrSet = setSearchEntrySearchDelay
    attrTransfer _ v = do
        return v
    attrConstruct = constructSearchEntrySearchDelay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchDelay"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#g:attr:searchDelay"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SearchEntry
type instance O.AttributeList SearchEntry = SearchEntryAttributeList
type SearchEntryAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("activatesDefault", SearchEntryActivatesDefaultPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("cursorPosition", Gtk.Editable.EditableCursorPositionPropertyInfo), '("editable", Gtk.Editable.EditableEditablePropertyInfo), '("enableUndo", Gtk.Editable.EditableEnableUndoPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("inputHints", SearchEntryInputHintsPropertyInfo), '("inputPurpose", SearchEntryInputPurposePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maxWidthChars", Gtk.Editable.EditableMaxWidthCharsPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("placeholderText", SearchEntryPlaceholderTextPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("searchDelay", SearchEntrySearchDelayPropertyInfo), '("selectionBound", Gtk.Editable.EditableSelectionBoundPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("text", Gtk.Editable.EditableTextPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthChars", Gtk.Editable.EditableWidthCharsPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("xalign", Gtk.Editable.EditableXalignPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
searchEntryActivatesDefault :: AttrLabelProxy "activatesDefault"
searchEntryActivatesDefault = AttrLabelProxy

searchEntryInputHints :: AttrLabelProxy "inputHints"
searchEntryInputHints = AttrLabelProxy

searchEntryInputPurpose :: AttrLabelProxy "inputPurpose"
searchEntryInputPurpose = AttrLabelProxy

searchEntryPlaceholderText :: AttrLabelProxy "placeholderText"
searchEntryPlaceholderText = AttrLabelProxy

searchEntrySearchDelay :: AttrLabelProxy "searchDelay"
searchEntrySearchDelay = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SearchEntry = SearchEntrySignalList
type SearchEntrySignalList = ('[ '("activate", SearchEntryActivateSignalInfo), '("changed", Gtk.Editable.EditableChangedSignalInfo), '("deleteText", Gtk.Editable.EditableDeleteTextSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("insertText", Gtk.Editable.EditableInsertTextSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("nextMatch", SearchEntryNextMatchSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("previousMatch", SearchEntryPreviousMatchSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("searchChanged", SearchEntrySearchChangedSignalInfo), '("searchStarted", SearchEntrySearchStartedSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("stopSearch", SearchEntryStopSearchSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SearchEntry::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "SearchEntry" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_new" gtk_search_entry_new :: 
    IO (Ptr SearchEntry)

-- | Creates a @GtkSearchEntry@.
searchEntryNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SearchEntry
    -- ^ __Returns:__ a new @GtkSearchEntry@
searchEntryNew  = liftIO $ do
    result <- gtk_search_entry_new
    checkUnexpectedReturnNULL "searchEntryNew" result
    result' <- (newObject SearchEntry) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SearchEntry::get_input_hints
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "InputHints" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_get_input_hints" gtk_search_entry_get_input_hints :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    IO CUInt

-- | Gets the input purpose for /@entry@/.
-- 
-- /Since: 4.14/
searchEntryGetInputHints ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> m [Gtk.Flags.InputHints]
    -- ^ __Returns:__ The input hints
searchEntryGetInputHints entry = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    result <- gtk_search_entry_get_input_hints entry'
    let result' = wordToGFlags result
    touchManagedPtr entry
    return result'

#if defined(ENABLE_OVERLOADING)
data SearchEntryGetInputHintsMethodInfo
instance (signature ~ (m [Gtk.Flags.InputHints]), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntryGetInputHintsMethodInfo a signature where
    overloadedMethod = searchEntryGetInputHints

instance O.OverloadedMethodInfo SearchEntryGetInputHintsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntryGetInputHints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntryGetInputHints"
        })


#endif

-- method SearchEntry::get_input_purpose
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "InputPurpose" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_get_input_purpose" gtk_search_entry_get_input_purpose :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    IO CUInt

-- | Gets the input purpose of /@entry@/.
-- 
-- /Since: 4.14/
searchEntryGetInputPurpose ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> m Gtk.Enums.InputPurpose
    -- ^ __Returns:__ The input hints
searchEntryGetInputPurpose entry = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    result <- gtk_search_entry_get_input_purpose entry'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr entry
    return result'

#if defined(ENABLE_OVERLOADING)
data SearchEntryGetInputPurposeMethodInfo
instance (signature ~ (m Gtk.Enums.InputPurpose), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntryGetInputPurposeMethodInfo a signature where
    overloadedMethod = searchEntryGetInputPurpose

instance O.OverloadedMethodInfo SearchEntryGetInputPurposeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntryGetInputPurpose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntryGetInputPurpose"
        })


#endif

-- method SearchEntry::get_key_capture_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_get_key_capture_widget" gtk_search_entry_get_key_capture_widget :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the widget that /@entry@/ is capturing key events from.
searchEntryGetKeyCaptureWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ The key capture widget.
searchEntryGetKeyCaptureWidget entry = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    result <- gtk_search_entry_get_key_capture_widget entry'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr entry
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SearchEntryGetKeyCaptureWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntryGetKeyCaptureWidgetMethodInfo a signature where
    overloadedMethod = searchEntryGetKeyCaptureWidget

instance O.OverloadedMethodInfo SearchEntryGetKeyCaptureWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntryGetKeyCaptureWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntryGetKeyCaptureWidget"
        })


#endif

-- method SearchEntry::get_placeholder_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_get_placeholder_text" gtk_search_entry_get_placeholder_text :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    IO CString

-- | Gets the placeholder text associated with /@entry@/.
-- 
-- /Since: 4.10/
searchEntryGetPlaceholderText ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The placeholder text.
searchEntryGetPlaceholderText entry = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    result <- gtk_search_entry_get_placeholder_text entry'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr entry
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SearchEntryGetPlaceholderTextMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntryGetPlaceholderTextMethodInfo a signature where
    overloadedMethod = searchEntryGetPlaceholderText

instance O.OverloadedMethodInfo SearchEntryGetPlaceholderTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntryGetPlaceholderText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntryGetPlaceholderText"
        })


#endif

-- method SearchEntry::get_search_delay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_get_search_delay" gtk_search_entry_get_search_delay :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    IO Word32

-- | Get the delay to be used between the last keypress and the
-- [SearchEntry::searchChanged]("GI.Gtk.Objects.SearchEntry#g:signal:searchChanged") signal being emitted.
-- 
-- /Since: 4.8/
searchEntryGetSearchDelay ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> m Word32
    -- ^ __Returns:__ a delay in milliseconds.
searchEntryGetSearchDelay entry = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    result <- gtk_search_entry_get_search_delay entry'
    touchManagedPtr entry
    return result

#if defined(ENABLE_OVERLOADING)
data SearchEntryGetSearchDelayMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntryGetSearchDelayMethodInfo a signature where
    overloadedMethod = searchEntryGetSearchDelay

instance O.OverloadedMethodInfo SearchEntryGetSearchDelayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntryGetSearchDelay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntryGetSearchDelay"
        })


#endif

-- method SearchEntry::set_input_hints
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hints"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InputHints" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new input hints"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_set_input_hints" gtk_search_entry_set_input_hints :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    CUInt ->                                -- hints : TInterface (Name {namespace = "Gtk", name = "InputHints"})
    IO ()

-- | Sets the input hints for /@entry@/.
-- 
-- /Since: 4.14/
searchEntrySetInputHints ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> [Gtk.Flags.InputHints]
    -- ^ /@hints@/: the new input hints
    -> m ()
searchEntrySetInputHints entry hints = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    let hints' = gflagsToWord hints
    gtk_search_entry_set_input_hints entry' hints'
    touchManagedPtr entry
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchEntrySetInputHintsMethodInfo
instance (signature ~ ([Gtk.Flags.InputHints] -> m ()), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntrySetInputHintsMethodInfo a signature where
    overloadedMethod = searchEntrySetInputHints

instance O.OverloadedMethodInfo SearchEntrySetInputHintsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntrySetInputHints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntrySetInputHints"
        })


#endif

-- method SearchEntry::set_input_purpose
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "purpose"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InputPurpose" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new input purpose"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_set_input_purpose" gtk_search_entry_set_input_purpose :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    CUInt ->                                -- purpose : TInterface (Name {namespace = "Gtk", name = "InputPurpose"})
    IO ()

-- | Sets the input purpose of /@entry@/.
-- 
-- /Since: 4.14/
searchEntrySetInputPurpose ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> Gtk.Enums.InputPurpose
    -- ^ /@purpose@/: the new input purpose
    -> m ()
searchEntrySetInputPurpose entry purpose = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    let purpose' = (fromIntegral . fromEnum) purpose
    gtk_search_entry_set_input_purpose entry' purpose'
    touchManagedPtr entry
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchEntrySetInputPurposeMethodInfo
instance (signature ~ (Gtk.Enums.InputPurpose -> m ()), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntrySetInputPurposeMethodInfo a signature where
    overloadedMethod = searchEntrySetInputPurpose

instance O.OverloadedMethodInfo SearchEntrySetInputPurposeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntrySetInputPurpose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntrySetInputPurpose"
        })


#endif

-- method SearchEntry::set_key_capture_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_set_key_capture_widget" gtk_search_entry_set_key_capture_widget :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets /@widget@/ as the widget that /@entry@/ will capture key
-- events from.
-- 
-- Key events are consumed by the search entry to start or
-- continue a search.
-- 
-- If the entry is part of a @GtkSearchBar@, it is preferable
-- to call 'GI.Gtk.Objects.SearchBar.searchBarSetKeyCaptureWidget' instead,
-- which will reveal the entry in addition to triggering the
-- search entry.
-- 
-- Note that despite the name of this function, the events
-- are only \'captured\' in the bubble phase, which means that
-- editable child widgets of /@widget@/ will receive text input
-- before it gets captured. If that is not desired, you can
-- capture and forward the events yourself with
-- 'GI.Gtk.Objects.EventControllerKey.eventControllerKeyForward'.
searchEntrySetKeyCaptureWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> Maybe (b)
    -- ^ /@widget@/: a @GtkWidget@
    -> m ()
searchEntrySetKeyCaptureWidget entry widget = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_search_entry_set_key_capture_widget entry' maybeWidget
    touchManagedPtr entry
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchEntrySetKeyCaptureWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSearchEntry a, Gtk.Widget.IsWidget b) => O.OverloadedMethod SearchEntrySetKeyCaptureWidgetMethodInfo a signature where
    overloadedMethod = searchEntrySetKeyCaptureWidget

instance O.OverloadedMethodInfo SearchEntrySetKeyCaptureWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntrySetKeyCaptureWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntrySetKeyCaptureWidget"
        })


#endif

-- method SearchEntry::set_placeholder_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text to set as a placeholder"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_set_placeholder_text" gtk_search_entry_set_placeholder_text :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    CString ->                              -- text : TBasicType TUTF8
    IO ()

-- | Sets the placeholder text associated with /@entry@/.
-- 
-- /Since: 4.10/
searchEntrySetPlaceholderText ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> Maybe (T.Text)
    -- ^ /@text@/: the text to set as a placeholder
    -> m ()
searchEntrySetPlaceholderText entry text = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    maybeText <- case text of
        Nothing -> return FP.nullPtr
        Just jText -> do
            jText' <- textToCString jText
            return jText'
    gtk_search_entry_set_placeholder_text entry' maybeText
    touchManagedPtr entry
    freeMem maybeText
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchEntrySetPlaceholderTextMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntrySetPlaceholderTextMethodInfo a signature where
    overloadedMethod = searchEntrySetPlaceholderText

instance O.OverloadedMethodInfo SearchEntrySetPlaceholderTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntrySetPlaceholderText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntrySetPlaceholderText"
        })


#endif

-- method SearchEntry::set_search_delay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "entry"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SearchEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSearchEntry`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delay"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a delay in milliseconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_search_entry_set_search_delay" gtk_search_entry_set_search_delay :: 
    Ptr SearchEntry ->                      -- entry : TInterface (Name {namespace = "Gtk", name = "SearchEntry"})
    Word32 ->                               -- delay : TBasicType TUInt
    IO ()

-- | Set the delay to be used between the last keypress and the
-- [SearchEntry::searchChanged]("GI.Gtk.Objects.SearchEntry#g:signal:searchChanged") signal being emitted.
-- 
-- /Since: 4.8/
searchEntrySetSearchDelay ::
    (B.CallStack.HasCallStack, MonadIO m, IsSearchEntry a) =>
    a
    -- ^ /@entry@/: a @GtkSearchEntry@
    -> Word32
    -- ^ /@delay@/: a delay in milliseconds
    -> m ()
searchEntrySetSearchDelay entry delay = liftIO $ do
    entry' <- unsafeManagedPtrCastPtr entry
    gtk_search_entry_set_search_delay entry' delay
    touchManagedPtr entry
    return ()

#if defined(ENABLE_OVERLOADING)
data SearchEntrySetSearchDelayMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsSearchEntry a) => O.OverloadedMethod SearchEntrySetSearchDelayMethodInfo a signature where
    overloadedMethod = searchEntrySetSearchDelay

instance O.OverloadedMethodInfo SearchEntrySetSearchDelayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SearchEntry.searchEntrySetSearchDelay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-SearchEntry.html#v:searchEntrySetSearchDelay"
        })


#endif


