{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides access to key events.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.EventControllerKey
    ( 

-- * Exported types
    EventControllerKey(..)                  ,
    IsEventControllerKey                    ,
    toEventControllerKey                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [forward]("GI.Gtk.Objects.EventControllerKey#g:method:forward"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getGroup]("GI.Gtk.Objects.EventControllerKey#g:method:getGroup"), [getImContext]("GI.Gtk.Objects.EventControllerKey#g:method:getImContext"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setImContext]("GI.Gtk.Objects.EventControllerKey#g:method:setImContext"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveEventControllerKeyMethod         ,
#endif

-- ** forward #method:forward#

#if defined(ENABLE_OVERLOADING)
    EventControllerKeyForwardMethodInfo     ,
#endif
    eventControllerKeyForward               ,


-- ** getGroup #method:getGroup#

#if defined(ENABLE_OVERLOADING)
    EventControllerKeyGetGroupMethodInfo    ,
#endif
    eventControllerKeyGetGroup              ,


-- ** getImContext #method:getImContext#

#if defined(ENABLE_OVERLOADING)
    EventControllerKeyGetImContextMethodInfo,
#endif
    eventControllerKeyGetImContext          ,


-- ** new #method:new#

    eventControllerKeyNew                   ,


-- ** setImContext #method:setImContext#

#if defined(ENABLE_OVERLOADING)
    EventControllerKeySetImContextMethodInfo,
#endif
    eventControllerKeySetImContext          ,




 -- * Signals


-- ** imUpdate #signal:imUpdate#

    EventControllerKeyImUpdateCallback      ,
#if defined(ENABLE_OVERLOADING)
    EventControllerKeyImUpdateSignalInfo    ,
#endif
    afterEventControllerKeyImUpdate         ,
    onEventControllerKeyImUpdate            ,


-- ** keyPressed #signal:keyPressed#

    EventControllerKeyKeyPressedCallback    ,
#if defined(ENABLE_OVERLOADING)
    EventControllerKeyKeyPressedSignalInfo  ,
#endif
    afterEventControllerKeyKeyPressed       ,
    onEventControllerKeyKeyPressed          ,


-- ** keyReleased #signal:keyReleased#

    EventControllerKeyKeyReleasedCallback   ,
#if defined(ENABLE_OVERLOADING)
    EventControllerKeyKeyReleasedSignalInfo ,
#endif
    afterEventControllerKeyKeyReleased      ,
    onEventControllerKeyKeyReleased         ,


-- ** modifiers #signal:modifiers#

    EventControllerKeyModifiersCallback     ,
#if defined(ENABLE_OVERLOADING)
    EventControllerKeyModifiersSignalInfo   ,
#endif
    afterEventControllerKeyModifiers        ,
    onEventControllerKeyModifiers           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.IMContext as Gtk.IMContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.AttrList as Pango.AttrList

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.IMContext as Gtk.IMContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype EventControllerKey = EventControllerKey (SP.ManagedPtr EventControllerKey)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventControllerKey where
    toManagedPtr (EventControllerKey p) = p

foreign import ccall "gtk_event_controller_key_get_type"
    c_gtk_event_controller_key_get_type :: IO B.Types.GType

instance B.Types.TypedObject EventControllerKey where
    glibType = c_gtk_event_controller_key_get_type

instance B.Types.GObject EventControllerKey

-- | Type class for types which can be safely cast to t'EventControllerKey', for instance with `toEventControllerKey`.
class (SP.GObject o, O.IsDescendantOf EventControllerKey o) => IsEventControllerKey o
instance (SP.GObject o, O.IsDescendantOf EventControllerKey o) => IsEventControllerKey o

instance O.HasParentTypes EventControllerKey
type instance O.ParentTypes EventControllerKey = '[Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to t'EventControllerKey', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toEventControllerKey :: (MIO.MonadIO m, IsEventControllerKey o) => o -> m EventControllerKey
toEventControllerKey = MIO.liftIO . B.ManagedPtr.unsafeCastTo EventControllerKey

-- | Convert t'EventControllerKey' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EventControllerKey) where
    gvalueGType_ = c_gtk_event_controller_key_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EventControllerKey)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EventControllerKey)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EventControllerKey ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEventControllerKeyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventControllerKeyMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEventControllerKeyMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEventControllerKeyMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEventControllerKeyMethod "forward" o = EventControllerKeyForwardMethodInfo
    ResolveEventControllerKeyMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEventControllerKeyMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEventControllerKeyMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEventControllerKeyMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEventControllerKeyMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEventControllerKeyMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEventControllerKeyMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEventControllerKeyMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveEventControllerKeyMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEventControllerKeyMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEventControllerKeyMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEventControllerKeyMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEventControllerKeyMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEventControllerKeyMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEventControllerKeyMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveEventControllerKeyMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveEventControllerKeyMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveEventControllerKeyMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveEventControllerKeyMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEventControllerKeyMethod "getGroup" o = EventControllerKeyGetGroupMethodInfo
    ResolveEventControllerKeyMethod "getImContext" o = EventControllerKeyGetImContextMethodInfo
    ResolveEventControllerKeyMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveEventControllerKeyMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveEventControllerKeyMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveEventControllerKeyMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEventControllerKeyMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEventControllerKeyMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveEventControllerKeyMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEventControllerKeyMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEventControllerKeyMethod "setImContext" o = EventControllerKeySetImContextMethodInfo
    ResolveEventControllerKeyMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveEventControllerKeyMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveEventControllerKeyMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveEventControllerKeyMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEventControllerKeyMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveEventControllerKeyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventControllerKeyMethod t EventControllerKey, O.OverloadedMethod info EventControllerKey p) => OL.IsLabel t (EventControllerKey -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventControllerKeyMethod t EventControllerKey, O.OverloadedMethod info EventControllerKey p, R.HasField t EventControllerKey p) => R.HasField t EventControllerKey p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventControllerKeyMethod t EventControllerKey, O.OverloadedMethodInfo info EventControllerKey) => OL.IsLabel t (O.MethodProxy info EventControllerKey) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal EventControllerKey::im-update
-- | Emitted whenever the input method context filters away
-- a keypress and prevents the /@controller@/ receiving it.
-- 
-- See 'GI.Gtk.Objects.EventControllerKey.eventControllerKeySetImContext' and
-- 'GI.Gtk.Objects.IMContext.iMContextFilterKeypress'.
type EventControllerKeyImUpdateCallback =
    IO ()

type C_EventControllerKeyImUpdateCallback =
    Ptr EventControllerKey ->               -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EventControllerKeyImUpdateCallback`.
foreign import ccall "wrapper"
    mk_EventControllerKeyImUpdateCallback :: C_EventControllerKeyImUpdateCallback -> IO (FunPtr C_EventControllerKeyImUpdateCallback)

wrap_EventControllerKeyImUpdateCallback :: 
    GObject a => (a -> EventControllerKeyImUpdateCallback) ->
    C_EventControllerKeyImUpdateCallback
wrap_EventControllerKeyImUpdateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [imUpdate](#signal:imUpdate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerKey #imUpdate callback
-- @
-- 
-- 
onEventControllerKeyImUpdate :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyImUpdateCallback) -> m SignalHandlerId
onEventControllerKeyImUpdate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyImUpdateCallback wrapped
    wrapped'' <- mk_EventControllerKeyImUpdateCallback wrapped'
    connectSignalFunPtr obj "im-update" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [imUpdate](#signal:imUpdate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerKey #imUpdate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerKeyImUpdate :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyImUpdateCallback) -> m SignalHandlerId
afterEventControllerKeyImUpdate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyImUpdateCallback wrapped
    wrapped'' <- mk_EventControllerKeyImUpdateCallback wrapped'
    connectSignalFunPtr obj "im-update" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerKeyImUpdateSignalInfo
instance SignalInfo EventControllerKeyImUpdateSignalInfo where
    type HaskellCallbackType EventControllerKeyImUpdateSignalInfo = EventControllerKeyImUpdateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerKeyImUpdateCallback cb
        cb'' <- mk_EventControllerKeyImUpdateCallback cb'
        connectSignalFunPtr obj "im-update" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey::im-update"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#g:signal:imUpdate"})

#endif

-- signal EventControllerKey::key-pressed
-- | Emitted whenever a key is pressed.
type EventControllerKeyKeyPressedCallback =
    Word32
    -- ^ /@keyval@/: the pressed key.
    -> Word32
    -- ^ /@keycode@/: the raw code of the pressed key.
    -> [Gdk.Flags.ModifierType]
    -- ^ /@state@/: the bitmask, representing the state of modifier keys and pointer buttons.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the key press was handled, 'P.False' otherwise.

type C_EventControllerKeyKeyPressedCallback =
    Ptr EventControllerKey ->               -- object
    Word32 ->
    Word32 ->
    CUInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_EventControllerKeyKeyPressedCallback`.
foreign import ccall "wrapper"
    mk_EventControllerKeyKeyPressedCallback :: C_EventControllerKeyKeyPressedCallback -> IO (FunPtr C_EventControllerKeyKeyPressedCallback)

wrap_EventControllerKeyKeyPressedCallback :: 
    GObject a => (a -> EventControllerKeyKeyPressedCallback) ->
    C_EventControllerKeyKeyPressedCallback
wrap_EventControllerKeyKeyPressedCallback gi'cb gi'selfPtr keyval keycode state _ = do
    let state' = wordToGFlags state
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  keyval keycode state'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [keyPressed](#signal:keyPressed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerKey #keyPressed callback
-- @
-- 
-- 
onEventControllerKeyKeyPressed :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyKeyPressedCallback) -> m SignalHandlerId
onEventControllerKeyKeyPressed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyKeyPressedCallback wrapped
    wrapped'' <- mk_EventControllerKeyKeyPressedCallback wrapped'
    connectSignalFunPtr obj "key-pressed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [keyPressed](#signal:keyPressed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerKey #keyPressed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerKeyKeyPressed :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyKeyPressedCallback) -> m SignalHandlerId
afterEventControllerKeyKeyPressed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyKeyPressedCallback wrapped
    wrapped'' <- mk_EventControllerKeyKeyPressedCallback wrapped'
    connectSignalFunPtr obj "key-pressed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerKeyKeyPressedSignalInfo
instance SignalInfo EventControllerKeyKeyPressedSignalInfo where
    type HaskellCallbackType EventControllerKeyKeyPressedSignalInfo = EventControllerKeyKeyPressedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerKeyKeyPressedCallback cb
        cb'' <- mk_EventControllerKeyKeyPressedCallback cb'
        connectSignalFunPtr obj "key-pressed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey::key-pressed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#g:signal:keyPressed"})

#endif

-- signal EventControllerKey::key-released
-- | Emitted whenever a key is released.
type EventControllerKeyKeyReleasedCallback =
    Word32
    -- ^ /@keyval@/: the released key.
    -> Word32
    -- ^ /@keycode@/: the raw code of the released key.
    -> [Gdk.Flags.ModifierType]
    -- ^ /@state@/: the bitmask, representing the state of modifier keys and pointer buttons.
    -> IO ()

type C_EventControllerKeyKeyReleasedCallback =
    Ptr EventControllerKey ->               -- object
    Word32 ->
    Word32 ->
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EventControllerKeyKeyReleasedCallback`.
foreign import ccall "wrapper"
    mk_EventControllerKeyKeyReleasedCallback :: C_EventControllerKeyKeyReleasedCallback -> IO (FunPtr C_EventControllerKeyKeyReleasedCallback)

wrap_EventControllerKeyKeyReleasedCallback :: 
    GObject a => (a -> EventControllerKeyKeyReleasedCallback) ->
    C_EventControllerKeyKeyReleasedCallback
wrap_EventControllerKeyKeyReleasedCallback gi'cb gi'selfPtr keyval keycode state _ = do
    let state' = wordToGFlags state
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  keyval keycode state'


-- | Connect a signal handler for the [keyReleased](#signal:keyReleased) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerKey #keyReleased callback
-- @
-- 
-- 
onEventControllerKeyKeyReleased :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyKeyReleasedCallback) -> m SignalHandlerId
onEventControllerKeyKeyReleased obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyKeyReleasedCallback wrapped
    wrapped'' <- mk_EventControllerKeyKeyReleasedCallback wrapped'
    connectSignalFunPtr obj "key-released" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [keyReleased](#signal:keyReleased) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerKey #keyReleased callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerKeyKeyReleased :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyKeyReleasedCallback) -> m SignalHandlerId
afterEventControllerKeyKeyReleased obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyKeyReleasedCallback wrapped
    wrapped'' <- mk_EventControllerKeyKeyReleasedCallback wrapped'
    connectSignalFunPtr obj "key-released" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerKeyKeyReleasedSignalInfo
instance SignalInfo EventControllerKeyKeyReleasedSignalInfo where
    type HaskellCallbackType EventControllerKeyKeyReleasedSignalInfo = EventControllerKeyKeyReleasedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerKeyKeyReleasedCallback cb
        cb'' <- mk_EventControllerKeyKeyReleasedCallback cb'
        connectSignalFunPtr obj "key-released" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey::key-released"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#g:signal:keyReleased"})

#endif

-- signal EventControllerKey::modifiers
-- | Emitted whenever the state of modifier keys and pointer buttons change.
type EventControllerKeyModifiersCallback =
    [Gdk.Flags.ModifierType]
    -- ^ /@state@/: the bitmask, representing the new state of modifier keys and
    --   pointer buttons.
    -> IO Bool
    -- ^ __Returns:__ whether to ignore modifiers

type C_EventControllerKeyModifiersCallback =
    Ptr EventControllerKey ->               -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_EventControllerKeyModifiersCallback`.
foreign import ccall "wrapper"
    mk_EventControllerKeyModifiersCallback :: C_EventControllerKeyModifiersCallback -> IO (FunPtr C_EventControllerKeyModifiersCallback)

wrap_EventControllerKeyModifiersCallback :: 
    GObject a => (a -> EventControllerKeyModifiersCallback) ->
    C_EventControllerKeyModifiersCallback
wrap_EventControllerKeyModifiersCallback gi'cb gi'selfPtr state _ = do
    let state' = wordToGFlags state
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  state'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [modifiers](#signal:modifiers) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerKey #modifiers callback
-- @
-- 
-- 
onEventControllerKeyModifiers :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyModifiersCallback) -> m SignalHandlerId
onEventControllerKeyModifiers obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyModifiersCallback wrapped
    wrapped'' <- mk_EventControllerKeyModifiersCallback wrapped'
    connectSignalFunPtr obj "modifiers" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [modifiers](#signal:modifiers) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerKey #modifiers callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerKeyModifiers :: (IsEventControllerKey a, MonadIO m) => a -> ((?self :: a) => EventControllerKeyModifiersCallback) -> m SignalHandlerId
afterEventControllerKeyModifiers obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerKeyModifiersCallback wrapped
    wrapped'' <- mk_EventControllerKeyModifiersCallback wrapped'
    connectSignalFunPtr obj "modifiers" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerKeyModifiersSignalInfo
instance SignalInfo EventControllerKeyModifiersSignalInfo where
    type HaskellCallbackType EventControllerKeyModifiersSignalInfo = EventControllerKeyModifiersCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerKeyModifiersCallback cb
        cb'' <- mk_EventControllerKeyModifiersCallback cb'
        connectSignalFunPtr obj "modifiers" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey::modifiers"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#g:signal:modifiers"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventControllerKey
type instance O.AttributeList EventControllerKey = EventControllerKeyAttributeList
type EventControllerKeyAttributeList = ('[ '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EventControllerKey = EventControllerKeySignalList
type EventControllerKeySignalList = ('[ '("imUpdate", EventControllerKeyImUpdateSignalInfo), '("keyPressed", EventControllerKeyKeyPressedSignalInfo), '("keyReleased", EventControllerKeyKeyReleasedSignalInfo), '("modifiers", EventControllerKeyModifiersSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EventControllerKey::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "EventControllerKey" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_key_new" gtk_event_controller_key_new :: 
    IO (Ptr EventControllerKey)

-- | Creates a new event controller that will handle key events.
eventControllerKeyNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m EventControllerKey
    -- ^ __Returns:__ a new @GtkEventControllerKey@
eventControllerKeyNew  = liftIO $ do
    result <- gtk_event_controller_key_new
    checkUnexpectedReturnNULL "eventControllerKeyNew" result
    result' <- (wrapObject EventControllerKey) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method EventControllerKey::forward
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventControllerKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerKey`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_key_forward" gtk_event_controller_key_forward :: 
    Ptr EventControllerKey ->               -- controller : TInterface (Name {namespace = "Gtk", name = "EventControllerKey"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CInt

-- | Forwards the current event of this /@controller@/ to a /@widget@/.
-- 
-- This function can only be used in handlers for the
-- [EventControllerKey::keyPressed]("GI.Gtk.Objects.EventControllerKey#g:signal:keyPressed"),
-- [EventControllerKey::keyReleased]("GI.Gtk.Objects.EventControllerKey#g:signal:keyReleased")
-- or [EventControllerKey::modifiers]("GI.Gtk.Objects.EventControllerKey#g:signal:modifiers") signals.
eventControllerKeyForward ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerKey a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@controller@/: a @GtkEventControllerKey@
    -> b
    -- ^ /@widget@/: a @GtkWidget@
    -> m Bool
    -- ^ __Returns:__ whether the /@widget@/ handled the event
eventControllerKeyForward controller widget = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    widget' <- unsafeManagedPtrCastPtr widget
    result <- gtk_event_controller_key_forward controller' widget'
    let result' = (/= 0) result
    touchManagedPtr controller
    touchManagedPtr widget
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerKeyForwardMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsEventControllerKey a, Gtk.Widget.IsWidget b) => O.OverloadedMethod EventControllerKeyForwardMethodInfo a signature where
    overloadedMethod = eventControllerKeyForward

instance O.OverloadedMethodInfo EventControllerKeyForwardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey.eventControllerKeyForward",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#v:eventControllerKeyForward"
        })


#endif

-- method EventControllerKey::get_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventControllerKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerKey`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_key_get_group" gtk_event_controller_key_get_group :: 
    Ptr EventControllerKey ->               -- controller : TInterface (Name {namespace = "Gtk", name = "EventControllerKey"})
    IO Word32

-- | Gets the key group of the current event of this /@controller@/.
-- 
-- See 'GI.Gdk.Objects.KeyEvent.keyEventGetLayout'.
eventControllerKeyGetGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerKey a) =>
    a
    -- ^ /@controller@/: a @GtkEventControllerKey@
    -> m Word32
    -- ^ __Returns:__ the key group
eventControllerKeyGetGroup controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_key_get_group controller'
    touchManagedPtr controller
    return result

#if defined(ENABLE_OVERLOADING)
data EventControllerKeyGetGroupMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsEventControllerKey a) => O.OverloadedMethod EventControllerKeyGetGroupMethodInfo a signature where
    overloadedMethod = eventControllerKeyGetGroup

instance O.OverloadedMethodInfo EventControllerKeyGetGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey.eventControllerKeyGetGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#v:eventControllerKeyGetGroup"
        })


#endif

-- method EventControllerKey::get_im_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventControllerKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerKey`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "IMContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_key_get_im_context" gtk_event_controller_key_get_im_context :: 
    Ptr EventControllerKey ->               -- controller : TInterface (Name {namespace = "Gtk", name = "EventControllerKey"})
    IO (Ptr Gtk.IMContext.IMContext)

-- | Gets the input method context of the key /@controller@/.
eventControllerKeyGetImContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerKey a) =>
    a
    -- ^ /@controller@/: a @GtkEventControllerKey@
    -> m (Maybe Gtk.IMContext.IMContext)
    -- ^ __Returns:__ the @GtkIMContext@
eventControllerKeyGetImContext controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_key_get_im_context controller'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.IMContext.IMContext) result'
        return result''
    touchManagedPtr controller
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data EventControllerKeyGetImContextMethodInfo
instance (signature ~ (m (Maybe Gtk.IMContext.IMContext)), MonadIO m, IsEventControllerKey a) => O.OverloadedMethod EventControllerKeyGetImContextMethodInfo a signature where
    overloadedMethod = eventControllerKeyGetImContext

instance O.OverloadedMethodInfo EventControllerKeyGetImContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey.eventControllerKeyGetImContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#v:eventControllerKeyGetImContext"
        })


#endif

-- method EventControllerKey::set_im_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventControllerKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventControllerKey`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "im_context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIMContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_key_set_im_context" gtk_event_controller_key_set_im_context :: 
    Ptr EventControllerKey ->               -- controller : TInterface (Name {namespace = "Gtk", name = "EventControllerKey"})
    Ptr Gtk.IMContext.IMContext ->          -- im_context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    IO ()

-- | Sets the input method context of the key /@controller@/.
eventControllerKeySetImContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventControllerKey a, Gtk.IMContext.IsIMContext b) =>
    a
    -- ^ /@controller@/: a @GtkEventControllerKey@
    -> Maybe (b)
    -- ^ /@imContext@/: a @GtkIMContext@
    -> m ()
eventControllerKeySetImContext controller imContext = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    maybeImContext <- case imContext of
        Nothing -> return FP.nullPtr
        Just jImContext -> do
            jImContext' <- unsafeManagedPtrCastPtr jImContext
            return jImContext'
    gtk_event_controller_key_set_im_context controller' maybeImContext
    touchManagedPtr controller
    whenJust imContext touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data EventControllerKeySetImContextMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsEventControllerKey a, Gtk.IMContext.IsIMContext b) => O.OverloadedMethod EventControllerKeySetImContextMethodInfo a signature where
    overloadedMethod = eventControllerKeySetImContext

instance O.OverloadedMethodInfo EventControllerKeySetImContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerKey.eventControllerKeySetImContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-EventControllerKey.html#v:eventControllerKeySetImContext"
        })


#endif


