
// Copyright (C) 2016-2024, Will Godfrey

// This file is part of yoshimi, which is free software: you can
// redistribute it and/or modify it under the terms of the GNU General
// Public License as published by the Free Software Foundation, either
// version 3 of the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with yoshimi; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef VectorUI_h
#define VectorUI_h
#include <FL/Fl.H>
#include "Misc/SynthEngine.h"
#include "UI/MiscGui.h"
#include "UI/WidgetSpinner.h"
#include "UI/ScaleTrackedWindow.h"
#include "BankUI.h"
#include "ParametersUI.h"
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Choice.H>

class VectorUI {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *vectorwindow;
private:
  inline void cb_vectorwindow_i(ScaleTrackedWindow*, void*);
  static void cb_vectorwindow(ScaleTrackedWindow*, void*);
public:
  WidgetSpinner *setbasechan;
private:
  inline void cb_setbasechan_i(WidgetSpinner*, void*);
  static void cb_setbasechan(WidgetSpinner*, void*);
public:
  Fl_Menu_Button *options;
private:
  inline void cb_options_i(Fl_Menu_Button*, void*);
  static void cb_options(Fl_Menu_Button*, void*);
public:
  Fl_Group *Xgroup;
  Fl_Box *AddBackL;
  Fl_Box *SubBackL;
  Fl_Box *PadBackL;
  Fl_Text_Display *XinstL;
  Fl_Button *XL;
private:
  inline void cb_XL_i(Fl_Button*, void*);
  static void cb_XL(Fl_Button*, void*);
public:
  Fl_Box *AddBackR;
  Fl_Box *SubBackR;
  Fl_Box *PadBackR;
  Fl_Text_Display *XinstR;
  Fl_Button *XR;
private:
  inline void cb_XR_i(Fl_Button*, void*);
  static void cb_XR(Fl_Button*, void*);
public:
  Fl_Text_Display *Xfeat;
  Fl_Choice *Xfeat1;
private:
  inline void cb_Xfeat1_i(Fl_Choice*, void*);
  static void cb_Xfeat1(Fl_Choice*, void*);
public:
  Fl_Choice *Xfeat2;
private:
  inline void cb_Xfeat2_i(Fl_Choice*, void*);
  static void cb_Xfeat2(Fl_Choice*, void*);
public:
  Fl_Choice *Xfeat3;
private:
  inline void cb_Xfeat3_i(Fl_Choice*, void*);
  static void cb_Xfeat3(Fl_Choice*, void*);
public:
  Fl_Choice *Xfeat4;
private:
  inline void cb_Xfeat4_i(Fl_Choice*, void*);
  static void cb_Xfeat4(Fl_Choice*, void*);
public:
  WidgetSpinner *Xcontrol;
private:
  inline void cb_Xcontrol_i(WidgetSpinner*, void*);
  static void cb_Xcontrol(WidgetSpinner*, void*);
public:
  Fl_Button *Closevector;
private:
  inline void cb_Closevector_i(Fl_Button*, void*);
  static void cb_Closevector(Fl_Button*, void*);
public:
  Fl_Group *Ygroup;
  Fl_Box *AddBackU;
  Fl_Box *SubBackU;
  Fl_Box *PadBackU;
private:
  Fl_Text_Display *YinstU;
public:
  Fl_Button *YU;
private:
  inline void cb_YU_i(Fl_Button*, void*);
  static void cb_YU(Fl_Button*, void*);
public:
  Fl_Box *AddBackD;
  Fl_Box *SubBackD;
  Fl_Box *PadBackD;
private:
  Fl_Text_Display *YinstD;
public:
  Fl_Button *YD;
private:
  inline void cb_YD_i(Fl_Button*, void*);
  static void cb_YD(Fl_Button*, void*);
public:
  Fl_Text_Display *Yfeat;
  Fl_Choice *Yfeat1;
private:
  inline void cb_Yfeat1_i(Fl_Choice*, void*);
  static void cb_Yfeat1(Fl_Choice*, void*);
public:
  Fl_Choice *Yfeat2;
private:
  inline void cb_Yfeat2_i(Fl_Choice*, void*);
  static void cb_Yfeat2(Fl_Choice*, void*);
public:
  Fl_Choice *Yfeat3;
private:
  inline void cb_Yfeat3_i(Fl_Choice*, void*);
  static void cb_Yfeat3(Fl_Choice*, void*);
public:
  Fl_Choice *Yfeat4;
private:
  inline void cb_Yfeat4_i(Fl_Choice*, void*);
  static void cb_Yfeat4(Fl_Choice*, void*);
public:
  WidgetSpinner *Ycontrol;
private:
  inline void cb_Ycontrol_i(WidgetSpinner*, void*);
  static void cb_Ycontrol(WidgetSpinner*, void*);
public:
  Fl_Button *Loaded;
private:
  inline void cb_Loaded_i(Fl_Button*, void*);
  static void cb_Loaded(Fl_Button*, void*);
public:
  void send_data(int action, int control, float value, int type, int part = TOPLEVEL::section::vector, int kit = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int miscmsg = UNUSED);
  void returns_update(CommandBlock *getData);
  void setRecent(bool active);
  VectorUI(SynthEngine *_synth, BankUI *_bankui, ParametersUI *_paramsui);
  ~VectorUI();
  void updateAll(bool everything = true);
  void RefreshChans();
  void setbuttons();
  void Show(SynthEngine *synth);
  void vectorRtext();
  void setInstrumentLabel(int vecPart);
  void setLoadLabelRemote(int chan, string name);
  string findnames(int vecPart);
  unsigned int findengines(int vecPart);
  int setcolors(int engine);
  void loadVector(string fname);
  void saveVector();
  void clearVector(int BaseC);
  void checkParts(int nval);
  void errorlabel(string msg);
private:
  SynthEngine *synth;
  BankUI *bankui;
  ParametersUI *paramsui;
  int BaseChan;
  int Xcc;
  unsigned int Xf;
  int Ycc;
  unsigned int Yf;
  float vecDW;
  float vecDH;
  string loadlabel [NUM_MIDI_CHANNELS];
  bool vectorSeen;
public:
  int lastvectorW;
};
#endif
