/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsAudioDataOutputCallback.h"

#include "ContextDestructionObserverInlines.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSWebCodecsAudioData.h"
#include "ScriptExecutionContext.h"


namespace WebCore {
using namespace JSC;

JSWebCodecsAudioDataOutputCallback::JSWebCodecsAudioDataOutputCallback(JSObject* callback, JSDOMGlobalObject* globalObject)
    : WebCodecsAudioDataOutputCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackData(callback, globalObject, this))
{
}

JSWebCodecsAudioDataOutputCallback::~JSWebCodecsAudioDataOutputCallback()
{
    SUPPRESS_UNCOUNTED_LOCAL ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    // We can't use RefPtr here since ScriptExecutionContext is not thread safe ref counted.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

CallbackResult<typename IDLUndefined::CallbackReturnType> JSWebCodecsAudioDataOutputCallback::invoke(typename IDLInterface<WebCodecsAudioData>::ParameterType output)
{
    if (!canInvokeCallback())
        return CallbackResultType::UnableToExecute;

    Ref<JSWebCodecsAudioDataOutputCallback> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLInterface<WebCodecsAudioData>>(lexicalGlobalObject, globalObject, output));
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::Function, Identifier(), returnedException);
    if (returnedException) {
        UNUSED_PARAM(lexicalGlobalObject);
        reportException(m_data->callback()->globalObject(), returnedException);
        return CallbackResultType::ExceptionThrown;
     }

    return { };
}

CallbackResult<typename IDLUndefined::CallbackReturnType> JSWebCodecsAudioDataOutputCallback::invokeRethrowingException(typename IDLInterface<WebCodecsAudioData>::ParameterType output)
{
    if (!canInvokeCallback())
        return CallbackResultType::UnableToExecute;

    Ref<JSWebCodecsAudioDataOutputCallback> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLInterface<WebCodecsAudioData>>(lexicalGlobalObject, globalObject, output));
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::Function, Identifier(), returnedException);
    if (returnedException) {
        auto throwScope = DECLARE_THROW_SCOPE(vm);
        throwException(&lexicalGlobalObject, throwScope, returnedException);
        return CallbackResultType::ExceptionThrown;
     }

    return { };
}

void JSWebCodecsAudioDataOutputCallback::visitJSFunction(JSC::AbstractSlotVisitor& visitor)
{
    m_data->visitJSFunction(visitor);
}

void JSWebCodecsAudioDataOutputCallback::visitJSFunction(JSC::SlotVisitor& visitor)
{
    m_data->visitJSFunction(visitor);
}

JSC::JSValue toJS(WebCodecsAudioDataOutputCallback& impl)
{
    if (!static_cast<JSWebCodecsAudioDataOutputCallback&>(impl).callbackData())
        return jsNull();

    return static_cast<JSWebCodecsAudioDataOutputCallback&>(impl).callbackData()->callback();
}

ScriptExecutionContext* JSWebCodecsAudioDataOutputCallback::scriptExecutionContext() const
{
    return ContextDestructionObserver::scriptExecutionContext();
}
} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
