/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSServiceWorkerContainer.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerRegistration.h"
#include "JSServiceWorkerUpdateViaCache.h"
#include "JSTrustedScriptURL.h"
#include "JSWorkerType.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ServiceWorkerContainer::RegistrationOptions>> convertDictionary<ServiceWorkerContainer::RegistrationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ServiceWorkerContainer::RegistrationOptions result;
    JSValue scopeValue;
    if (isNullOrUndefined)
        scopeValue = jsUndefined();
    else {
        scopeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "scope"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!scopeValue.isUndefined()) {
        auto scopeConversionResult = convert<IDLUSVString>(lexicalGlobalObject, scopeValue);
        if (scopeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.scope = scopeConversionResult.releaseReturnValue();
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLEnumeration<WorkerType>>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLEnumeration<WorkerType>> { return Converter<IDLEnumeration<WorkerType>>::ReturnType { WorkerType::Classic }; });
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    JSValue updateViaCacheValue;
    if (isNullOrUndefined)
        updateViaCacheValue = jsUndefined();
    else {
        updateViaCacheValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "updateViaCache"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto updateViaCacheConversionResult = convertOptionalWithDefault<IDLEnumeration<ServiceWorkerUpdateViaCache>>(lexicalGlobalObject, updateViaCacheValue, [&]() -> ConversionResult<IDLEnumeration<ServiceWorkerUpdateViaCache>> { return Converter<IDLEnumeration<ServiceWorkerUpdateViaCache>>::ReturnType { ServiceWorkerUpdateViaCache::Imports }; });
    if (updateViaCacheConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.updateViaCache = updateViaCacheConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_register);
static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_getRegistration);
static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_getRegistrations);
static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_startMessages);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerContainerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerContainer_controller);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerContainer_ready);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerContainer_oncontrollerchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSServiceWorkerContainer_oncontrollerchange);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerContainer_onmessage);
static JSC_DECLARE_CUSTOM_SETTER(setJSServiceWorkerContainer_onmessage);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerContainer_onmessageerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSServiceWorkerContainer_onmessageerror);

class JSServiceWorkerContainerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerContainerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerContainerPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerContainerPrototype>(vm)) JSServiceWorkerContainerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerContainerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerContainerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerContainerPrototype, JSServiceWorkerContainerPrototype::Base);

using JSServiceWorkerContainerDOMConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerContainer>;

template<> const ClassInfo JSServiceWorkerContainerDOMConstructor::s_info = { "ServiceWorkerContainer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerContainerDOMConstructor) };

template<> JSValue JSServiceWorkerContainerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSServiceWorkerContainerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ServiceWorkerContainer"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerContainer::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 10> JSServiceWorkerContainerPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerContainerConstructor, 0 } },
    HashTableValue { "controller"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerContainer_controller, 0 } },
    HashTableValue { "ready"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerContainer_ready, 0 } },
    HashTableValue { "oncontrollerchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerContainer_oncontrollerchange, setJSServiceWorkerContainer_oncontrollerchange } },
    HashTableValue { "onmessage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerContainer_onmessage, setJSServiceWorkerContainer_onmessage } },
    HashTableValue { "onmessageerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerContainer_onmessageerror, setJSServiceWorkerContainer_onmessageerror } },
    HashTableValue { "register"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerContainerPrototypeFunction_register, 1 } },
    HashTableValue { "getRegistration"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerContainerPrototypeFunction_getRegistration, 0 } },
    HashTableValue { "getRegistrations"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerContainerPrototypeFunction_getRegistrations, 0 } },
    HashTableValue { "startMessages"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerContainerPrototypeFunction_startMessages, 0 } },
};

const ClassInfo JSServiceWorkerContainerPrototype::s_info = { "ServiceWorkerContainer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerContainerPrototype) };

void JSServiceWorkerContainerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerContainer::info(), JSServiceWorkerContainerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSServiceWorkerContainer::s_info = { "ServiceWorkerContainer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerContainer) };

JSServiceWorkerContainer::JSServiceWorkerContainer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerContainer>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<ServiceWorkerContainer> JSServiceWorkerContainer::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, ServiceWorkerContainer>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSServiceWorkerContainer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSServiceWorkerContainerPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSServiceWorkerContainerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSServiceWorkerContainer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerContainer>(vm, globalObject);
}

JSValue JSServiceWorkerContainer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerContainerDOMConstructor, DOMConstructorID::ServiceWorkerContainer>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerContainerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerContainerPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerContainer::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsServiceWorkerContainer_controllerGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<ServiceWorker>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.controller())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerContainer_controller, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainer_controllerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerContainer_readyGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLInterface<ServiceWorkerRegistration>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.ready(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerContainer_ready, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainer_readyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerContainer_oncontrollerchangeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().controllerchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerContainer_oncontrollerchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainer_oncontrollerchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSServiceWorkerContainer_oncontrollerchangeSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().controllerchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSServiceWorkerContainer_oncontrollerchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::set<setJSServiceWorkerContainer_oncontrollerchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsServiceWorkerContainer_onmessageGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerContainer_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainer_onmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSServiceWorkerContainer_onmessageSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().messageEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSServiceWorkerContainer_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::set<setJSServiceWorkerContainer_onmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsServiceWorkerContainer_onmessageerrorGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().messageerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerContainer_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::get<jsServiceWorkerContainer_onmessageerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSServiceWorkerContainer_onmessageerrorSetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerContainer& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().messageerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSServiceWorkerContainer_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerContainer>::set<setJSServiceWorkerContainer_onmessageerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunction_registerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto scriptURLConversionResult = convert<IDLUnion<IDLInterface<TrustedScriptURL>, IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (scriptURLConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<ServiceWorkerContainer::RegistrationOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<ServiceWorkerRegistration>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.addRegistration(scriptURLConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_register, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunction_registerBody>(*lexicalGlobalObject, *callFrame, "register");
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunction_getRegistrationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto clientURLConversionResult = convertOptionalWithDefault<IDLUSVString>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (clientURLConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getRegistration(clientURLConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_getRegistration, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunction_getRegistrationBody>(*lexicalGlobalObject, *callFrame, "getRegistration");
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunction_getRegistrationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSServiceWorkerContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLSequence<IDLInterface<ServiceWorkerRegistration>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getRegistrations(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_getRegistrations, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunction_getRegistrationsBody>(*lexicalGlobalObject, *callFrame, "getRegistrations");
}

static inline JSC::EncodedJSValue jsServiceWorkerContainerPrototypeFunction_startMessagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerContainer>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.startMessages(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerContainerPrototypeFunction_startMessages, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSServiceWorkerContainer>::call<jsServiceWorkerContainerPrototypeFunction_startMessagesBody>(*lexicalGlobalObject, *callFrame, "startMessages");
}

JSC::GCClient::IsoSubspace* JSServiceWorkerContainer::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSServiceWorkerContainer, UseCustomHeapCellType::No>(vm, "JSServiceWorkerContainer"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForServiceWorkerContainer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForServiceWorkerContainer = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForServiceWorkerContainer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForServiceWorkerContainer = std::forward<decltype(space)>(space); }
    );
}

void JSServiceWorkerContainer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerContainer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerContainerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsServiceWorkerContainer = jsCast<JSServiceWorkerContainer*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsServiceWorkerContainer->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    NavigatorBase* owner = WTF::getPtr(jsServiceWorkerContainer->wrapped().navigator());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSServiceWorkerContainerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerContainer = static_cast<JSServiceWorkerContainer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsServiceWorkerContainer->protectedWrapped().ptr(), jsServiceWorkerContainer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ServiceWorkerContainer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22ServiceWorkerContainerE[]; }
#endif
template<std::same_as<ServiceWorkerContainer> T>
static inline void verifyVTable(ServiceWorkerContainer* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ServiceWorkerContainer@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22ServiceWorkerContainerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ServiceWorkerContainer has subclasses. If ServiceWorkerContainer has subclasses that get passed
        // to toJS() we currently require ServiceWorkerContainer you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ServiceWorkerContainer>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ServiceWorkerContainer>(impl.ptr());
#endif
    return createWrapper<ServiceWorkerContainer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ServiceWorkerContainer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ServiceWorkerContainer* JSServiceWorkerContainer::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerContainer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
