/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWheelEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "EventTargetInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WheelEvent::Init>> convertDictionary<WheelEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WheelEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detailConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, detailValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (detailConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.detail = detailConversionResult.releaseReturnValue();
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<WindowProxy>>> { return typename Converter<IDLNullable<IDLInterface<WindowProxy>>>::ReturnType { nullptr }; });
    if (viewConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.view = viewConversionResult.releaseReturnValue();
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto altKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, altKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (altKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.altKey = altKeyConversionResult.releaseReturnValue();
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ctrlKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (ctrlKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.ctrlKey = ctrlKeyConversionResult.releaseReturnValue();
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto metaKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, metaKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (metaKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.metaKey = metaKeyConversionResult.releaseReturnValue();
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierAltGraphConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (modifierAltGraphConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.modifierAltGraph = modifierAltGraphConversionResult.releaseReturnValue();
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierCapsLockConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (modifierCapsLockConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.modifierCapsLock = modifierCapsLockConversionResult.releaseReturnValue();
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto shiftKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, shiftKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (shiftKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.shiftKey = shiftKeyConversionResult.releaseReturnValue();
    JSValue buttonValue;
    if (isNullOrUndefined)
        buttonValue = jsUndefined();
    else {
        buttonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "button"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto buttonConversionResult = convertOptionalWithDefault<IDLShort>(lexicalGlobalObject, buttonValue, [&]() -> ConversionResult<IDLShort> { return Converter<IDLShort>::ReturnType { 0 }; });
    if (buttonConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.button = buttonConversionResult.releaseReturnValue();
    JSValue buttonsValue;
    if (isNullOrUndefined)
        buttonsValue = jsUndefined();
    else {
        buttonsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buttons"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto buttonsConversionResult = convertOptionalWithDefault<IDLUnsignedShort>(lexicalGlobalObject, buttonsValue, [&]() -> ConversionResult<IDLUnsignedShort> { return Converter<IDLUnsignedShort>::ReturnType { 0 }; });
    if (buttonsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.buttons = buttonsConversionResult.releaseReturnValue();
    JSValue clientXValue;
    if (isNullOrUndefined)
        clientXValue = jsUndefined();
    else {
        clientXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clientXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, clientXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (clientXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.clientX = clientXConversionResult.releaseReturnValue();
    JSValue clientYValue;
    if (isNullOrUndefined)
        clientYValue = jsUndefined();
    else {
        clientYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clientYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, clientYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (clientYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.clientY = clientYConversionResult.releaseReturnValue();
    JSValue movementXValue;
    if (isNullOrUndefined)
        movementXValue = jsUndefined();
    else {
        movementXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto movementXConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, movementXValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (movementXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.movementX = movementXConversionResult.releaseReturnValue();
    JSValue movementYValue;
    if (isNullOrUndefined)
        movementYValue = jsUndefined();
    else {
        movementYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto movementYConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, movementYValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (movementYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.movementY = movementYConversionResult.releaseReturnValue();
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto relatedTargetConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<EventTarget>>> { return typename Converter<IDLNullable<IDLInterface<EventTarget>>>::ReturnType { nullptr }; });
    if (relatedTargetConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.relatedTarget = relatedTargetConversionResult.releaseReturnValue();
    JSValue screenXValue;
    if (isNullOrUndefined)
        screenXValue = jsUndefined();
    else {
        screenXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto screenXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, screenXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (screenXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.screenX = screenXConversionResult.releaseReturnValue();
    JSValue screenYValue;
    if (isNullOrUndefined)
        screenYValue = jsUndefined();
    else {
        screenYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto screenYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, screenYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (screenYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.screenY = screenYConversionResult.releaseReturnValue();
    JSValue deltaModeValue;
    if (isNullOrUndefined)
        deltaModeValue = jsUndefined();
    else {
        deltaModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto deltaModeConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, deltaModeValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (deltaModeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.deltaMode = deltaModeConversionResult.releaseReturnValue();
    JSValue deltaXValue;
    if (isNullOrUndefined)
        deltaXValue = jsUndefined();
    else {
        deltaXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto deltaXConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, deltaXValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (deltaXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.deltaX = deltaXConversionResult.releaseReturnValue();
    JSValue deltaYValue;
    if (isNullOrUndefined)
        deltaYValue = jsUndefined();
    else {
        deltaYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto deltaYConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, deltaYValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (deltaYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.deltaY = deltaYConversionResult.releaseReturnValue();
    JSValue deltaZValue;
    if (isNullOrUndefined)
        deltaZValue = jsUndefined();
    else {
        deltaZValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deltaZ"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto deltaZConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, deltaZValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (deltaZConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.deltaZ = deltaZConversionResult.releaseReturnValue();
    JSValue wheelDeltaXValue;
    if (isNullOrUndefined)
        wheelDeltaXValue = jsUndefined();
    else {
        wheelDeltaXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "wheelDeltaX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto wheelDeltaXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, wheelDeltaXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (wheelDeltaXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.wheelDeltaX = wheelDeltaXConversionResult.releaseReturnValue();
    JSValue wheelDeltaYValue;
    if (isNullOrUndefined)
        wheelDeltaYValue = jsUndefined();
    else {
        wheelDeltaYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "wheelDeltaY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto wheelDeltaYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, wheelDeltaYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (wheelDeltaYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.wheelDeltaY = wheelDeltaYConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWheelEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaX);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaY);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaZ);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_deltaMode);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaX);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaY);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_wheelDelta);
static JSC_DECLARE_CUSTOM_GETTER(jsWheelEvent_webkitDirectionInvertedFromDevice);

class JSWheelEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWheelEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWheelEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSWheelEventPrototype>(vm)) JSWheelEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWheelEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWheelEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWheelEventPrototype, JSWheelEventPrototype::Base);

using JSWheelEventDOMConstructor = JSDOMConstructor<JSWheelEvent>;

/* Hash table for constructor */

static const std::array<HashTableValue, 3> JSWheelEventConstructorTableValues {
    HashTableValue { "DOM_DELTA_PIXEL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00 } },
    HashTableValue { "DOM_DELTA_LINE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    HashTableValue { "DOM_DELTA_PAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
};

static_assert(WheelEvent::DOM_DELTA_PIXEL == 0x00, "DOM_DELTA_PIXEL in WheelEvent does not match value from IDL");
static_assert(WheelEvent::DOM_DELTA_LINE == 0x01, "DOM_DELTA_LINE in WheelEvent does not match value from IDL");
static_assert(WheelEvent::DOM_DELTA_PAGE == 0x02, "DOM_DELTA_PAGE in WheelEvent does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWheelEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWheelEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<WheelEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = WheelEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WheelEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WheelEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWheelEventDOMConstructorConstruct, JSWheelEventDOMConstructor::construct);

template<> const ClassInfo JSWheelEventDOMConstructor::s_info = { "WheelEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEventDOMConstructor) };

template<> JSValue JSWheelEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMouseEvent::getConstructor(vm, &globalObject);
}

template<> void JSWheelEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WheelEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWheelEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSWheelEvent::info(), JSWheelEventConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 12> JSWheelEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEventConstructor, 0 } },
    HashTableValue { "deltaX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaX, 0 } },
    HashTableValue { "deltaY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaY, 0 } },
    HashTableValue { "deltaZ"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaZ, 0 } },
    HashTableValue { "deltaMode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_deltaMode, 0 } },
    HashTableValue { "wheelDeltaX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_wheelDeltaX, 0 } },
    HashTableValue { "wheelDeltaY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_wheelDeltaY, 0 } },
    HashTableValue { "wheelDelta"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_wheelDelta, 0 } },
    HashTableValue { "webkitDirectionInvertedFromDevice"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWheelEvent_webkitDirectionInvertedFromDevice, 0 } },
    HashTableValue { "DOM_DELTA_PIXEL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00 } },
    HashTableValue { "DOM_DELTA_LINE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    HashTableValue { "DOM_DELTA_PAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
};

const ClassInfo JSWheelEventPrototype::s_info = { "WheelEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEventPrototype) };

void JSWheelEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWheelEvent::info(), JSWheelEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWheelEvent) };

JSWheelEvent::JSWheelEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WheelEvent>&& impl)
    : JSMouseEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<WheelEvent> JSWheelEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, WheelEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWheelEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWheelEventPrototype::createStructure(vm, &globalObject, JSMouseEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWheelEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWheelEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWheelEvent>(vm, globalObject);
}

JSValue JSWheelEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWheelEventDOMConstructor, DOMConstructorID::WheelEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWheelEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWheelEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWheelEvent_deltaXGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.deltaX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_deltaYGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.deltaY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_deltaZGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.deltaZ())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaZ, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_deltaModeGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.deltaMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_deltaMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_deltaModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_wheelDeltaXGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDeltaX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_wheelDeltaXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_wheelDeltaYGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDeltaY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_wheelDeltaY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_wheelDeltaYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_wheelDeltaGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.wheelDelta())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_wheelDelta, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_wheelDeltaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWheelEvent_webkitDirectionInvertedFromDeviceGetter(JSGlobalObject& lexicalGlobalObject, JSWheelEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitDirectionInvertedFromDevice())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWheelEvent_webkitDirectionInvertedFromDevice, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWheelEvent>::get<jsWheelEvent_webkitDirectionInvertedFromDeviceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSWheelEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWheelEvent, UseCustomHeapCellType::No>(vm, "JSWheelEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWheelEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWheelEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWheelEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWheelEvent = std::forward<decltype(space)>(space); }
    );
}

void JSWheelEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWheelEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WheelEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10WheelEventE[]; }
#endif
template<std::same_as<WheelEvent> T>
static inline void verifyVTable(WheelEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WheelEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10WheelEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WheelEvent has subclasses. If WheelEvent has subclasses that get passed
        // to toJS() we currently require WheelEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WheelEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WheelEvent>(impl.ptr());
#endif
    return createWrapper<WheelEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WheelEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
