/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportSendStreamStats.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebTransportSendStreamStats>> convertDictionary<WebTransportSendStreamStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebTransportSendStreamStats result;
    JSValue bytesAcknowledgedValue;
    if (isNullOrUndefined)
        bytesAcknowledgedValue = jsUndefined();
    else {
        bytesAcknowledgedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesAcknowledged"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesAcknowledgedValue.isUndefined()) {
        auto bytesAcknowledgedConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesAcknowledgedValue);
        if (bytesAcknowledgedConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bytesAcknowledged = bytesAcknowledgedConversionResult.releaseReturnValue();
    }
    JSValue bytesSentValue;
    if (isNullOrUndefined)
        bytesSentValue = jsUndefined();
    else {
        bytesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesSent"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesSentValue.isUndefined()) {
        auto bytesSentConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesSentValue);
        if (bytesSentConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bytesSent = bytesSentConversionResult.releaseReturnValue();
    }
    JSValue bytesWrittenValue;
    if (isNullOrUndefined)
        bytesWrittenValue = jsUndefined();
    else {
        bytesWrittenValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesWritten"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesWrittenValue.isUndefined()) {
        auto bytesWrittenConversionResult = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesWrittenValue);
        if (bytesWrittenConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bytesWritten = bytesWrittenConversionResult.releaseReturnValue();
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timestampValue.isUndefined()) {
        auto timestampConversionResult = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        if (timestampConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timestamp = timestampConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

