/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebLockManager.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAbortSignal.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSWebLockGrantedCallback.h"
#include "JSWebLockManagerSnapshot.h"
#include "JSWebLockMode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebLockManager::Options>> convertDictionary<WebLockManager::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebLockManager::Options result;
    JSValue ifAvailableValue;
    if (isNullOrUndefined)
        ifAvailableValue = jsUndefined();
    else {
        ifAvailableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ifAvailable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ifAvailableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ifAvailableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (ifAvailableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.ifAvailable = ifAvailableConversionResult.releaseReturnValue();
    JSValue modeValue;
    if (isNullOrUndefined)
        modeValue = jsUndefined();
    else {
        modeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modeConversionResult = convertOptionalWithDefault<IDLEnumeration<WebLockMode>>(lexicalGlobalObject, modeValue, [&]() -> ConversionResult<IDLEnumeration<WebLockMode>> { return Converter<IDLEnumeration<WebLockMode>>::ReturnType { WebLockMode::Exclusive }; });
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.mode = modeConversionResult.releaseReturnValue();
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!signalValue.isUndefined()) {
        auto signalConversionResult = convert<IDLInterface<AbortSignal>>(lexicalGlobalObject, signalValue);
        if (signalConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.signal = signalConversionResult.releaseReturnValue();
    }
    JSValue stealValue;
    if (isNullOrUndefined)
        stealValue = jsUndefined();
    else {
        stealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "steal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stealConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, stealValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (stealConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.steal = stealConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebLockManagerPrototypeFunction_request);
static JSC_DECLARE_HOST_FUNCTION(jsWebLockManagerPrototypeFunction_query);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebLockManagerConstructor);

class JSWebLockManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebLockManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebLockManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebLockManagerPrototype>(vm)) JSWebLockManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebLockManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebLockManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebLockManagerPrototype, JSWebLockManagerPrototype::Base);

using JSWebLockManagerDOMConstructor = JSDOMConstructorNotConstructable<JSWebLockManager>;

template<> const ClassInfo JSWebLockManagerDOMConstructor::s_info = { "LockManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebLockManagerDOMConstructor) };

template<> JSValue JSWebLockManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebLockManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "LockManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebLockManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSWebLockManagerPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebLockManagerConstructor, 0 } },
    HashTableValue { "request"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebLockManagerPrototypeFunction_request, 2 } },
    HashTableValue { "query"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebLockManagerPrototypeFunction_query, 0 } },
};

const ClassInfo JSWebLockManagerPrototype::s_info = { "LockManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebLockManagerPrototype) };

void JSWebLockManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebLockManager::info(), JSWebLockManagerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebLockManager::s_info = { "LockManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebLockManager) };

JSWebLockManager::JSWebLockManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebLockManager>&& impl)
    : JSDOMWrapper<WebLockManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, WebLockManager>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWebLockManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebLockManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebLockManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebLockManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebLockManager>(vm, globalObject);
}

JSValue JSWebLockManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebLockManagerDOMConstructor, DOMConstructorID::WebLockManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebLockManager::destroy(JSC::JSCell* cell)
{
    JSWebLockManager* thisObject = static_cast<JSWebLockManager*>(cell);
    thisObject->JSWebLockManager::~JSWebLockManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebLockManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebLockManagerPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebLockManager::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsWebLockManagerPrototypeFunction_request1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebLockManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto grantedCallbackConversionResult = convert<IDLCallbackFunction<JSWebLockGrantedCallback>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "grantedCallback"_s, "LockManager"_s, "request"_s); });
    if (grantedCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.request(nameConversionResult.releaseReturnValue(), grantedCallbackConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

static inline JSC::EncodedJSValue jsWebLockManagerPrototypeFunction_request2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebLockManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto optionsConversionResult = convert<IDLDictionary<WebLockManager::Options>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto grantedCallbackConversionResult = convert<IDLCallbackFunction<JSWebLockGrantedCallback>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "grantedCallback"_s, "LockManager"_s, "request"_s); });
    if (grantedCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.request(nameConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), grantedCallbackConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

static inline JSC::EncodedJSValue jsWebLockManagerPrototypeFunction_requestOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebLockManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsWebLockManagerPrototypeFunction_request1Body(lexicalGlobalObject, callFrame, castedThis, WTFMove(promise))));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsWebLockManagerPrototypeFunction_request2Body(lexicalGlobalObject, callFrame, castedThis, WTFMove(promise))));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsWebLockManagerPrototypeFunction_request, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebLockManager>::call<jsWebLockManagerPrototypeFunction_requestOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "request");
}

static inline JSC::EncodedJSValue jsWebLockManagerPrototypeFunction_queryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebLockManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebLockManagerSnapshot>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.query(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebLockManagerPrototypeFunction_query, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebLockManager>::call<jsWebLockManagerPrototypeFunction_queryBody>(*lexicalGlobalObject, *callFrame, "query");
}

JSC::GCClient::IsoSubspace* JSWebLockManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebLockManager, UseCustomHeapCellType::No>(vm, "JSWebLockManager"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebLockManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebLockManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebLockManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebLockManager = std::forward<decltype(space)>(space); }
    );
}

void JSWebLockManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebLockManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebLockManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsWebLockManager = jsCast<JSWebLockManager*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsWebLockManager->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebLockManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebLockManager = static_cast<JSWebLockManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebLockManager->protectedWrapped().ptr(), jsWebLockManager);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebLockManager@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14WebLockManagerE[]; }
#endif
template<std::same_as<WebLockManager> T>
static inline void verifyVTable(WebLockManager* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebLockManager@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14WebLockManagerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebLockManager has subclasses. If WebLockManager has subclasses that get passed
        // to toJS() we currently require WebLockManager you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebLockManager>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebLockManager>(impl.ptr());
#endif
    return createWrapper<WebLockManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebLockManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebLockManager* JSWebLockManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebLockManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
