/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoMatrixCoefficients.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(VideoMatrixCoefficients enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 10> values {
        MAKE_STATIC_STRING_IMPL("rgb"),
        MAKE_STATIC_STRING_IMPL("bt709"),
        MAKE_STATIC_STRING_IMPL("bt470bg"),
        MAKE_STATIC_STRING_IMPL("smpte170m"),
        MAKE_STATIC_STRING_IMPL("smpte240m"),
        MAKE_STATIC_STRING_IMPL("fcc"),
        MAKE_STATIC_STRING_IMPL("yCgCo"),
        MAKE_STATIC_STRING_IMPL("bt2020-ncl"),
        MAKE_STATIC_STRING_IMPL("bt2020-cl"),
        MAKE_STATIC_STRING_IMPL("unspecified"),
    };
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Rgb) == 0, "VideoMatrixCoefficients::Rgb is not 0 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Bt709) == 1, "VideoMatrixCoefficients::Bt709 is not 1 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Bt470bg) == 2, "VideoMatrixCoefficients::Bt470bg is not 2 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Smpte170m) == 3, "VideoMatrixCoefficients::Smpte170m is not 3 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Smpte240m) == 4, "VideoMatrixCoefficients::Smpte240m is not 4 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Fcc) == 5, "VideoMatrixCoefficients::Fcc is not 5 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::YCgCo) == 6, "VideoMatrixCoefficients::YCgCo is not 6 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Bt2020Ncl) == 7, "VideoMatrixCoefficients::Bt2020Ncl is not 7 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Bt2020Cl) == 8, "VideoMatrixCoefficients::Bt2020Cl is not 8 as expected");
    static_assert(static_cast<size_t>(VideoMatrixCoefficients::Unspecified) == 9, "VideoMatrixCoefficients::Unspecified is not 9 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VideoMatrixCoefficients enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VideoMatrixCoefficients> parseEnumerationFromString<VideoMatrixCoefficients>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, VideoMatrixCoefficients>, 10> mappings {
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "bt2020-cl"_s, VideoMatrixCoefficients::Bt2020Cl },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "bt2020-ncl"_s, VideoMatrixCoefficients::Bt2020Ncl },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "bt470bg"_s, VideoMatrixCoefficients::Bt470bg },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "bt709"_s, VideoMatrixCoefficients::Bt709 },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "fcc"_s, VideoMatrixCoefficients::Fcc },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "rgb"_s, VideoMatrixCoefficients::Rgb },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "smpte170m"_s, VideoMatrixCoefficients::Smpte170m },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "smpte240m"_s, VideoMatrixCoefficients::Smpte240m },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "unspecified"_s, VideoMatrixCoefficients::Unspecified },
        std::pair<ComparableASCIILiteral, VideoMatrixCoefficients> { "yCgCo"_s, VideoMatrixCoefficients::YCgCo },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VideoMatrixCoefficients> parseEnumeration<VideoMatrixCoefficients>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VideoMatrixCoefficients>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VideoMatrixCoefficients>()
{
    return "\"rgb\", \"bt709\", \"bt470bg\", \"smpte170m\", \"smpte240m\", \"fcc\", \"yCgCo\", \"bt2020-ncl\", \"bt2020-cl\", \"unspecified\""_s;
}

} // namespace WebCore


#endif // ENABLE(VIDEO)
