/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPermissionState.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(PermissionState enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("granted"),
        MAKE_STATIC_STRING_IMPL("denied"),
        MAKE_STATIC_STRING_IMPL("prompt"),
    };
    static_assert(static_cast<size_t>(PermissionState::Granted) == 0, "PermissionState::Granted is not 0 as expected");
    static_assert(static_cast<size_t>(PermissionState::Denied) == 1, "PermissionState::Denied is not 1 as expected");
    static_assert(static_cast<size_t>(PermissionState::Prompt) == 2, "PermissionState::Prompt is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, PermissionState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<PermissionState> parseEnumerationFromString<PermissionState>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, PermissionState>, 3> mappings {
        std::pair<ComparableASCIILiteral, PermissionState> { "denied"_s, PermissionState::Denied },
        std::pair<ComparableASCIILiteral, PermissionState> { "granted"_s, PermissionState::Granted },
        std::pair<ComparableASCIILiteral, PermissionState> { "prompt"_s, PermissionState::Prompt },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<PermissionState> parseEnumeration<PermissionState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<PermissionState>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<PermissionState>()
{
    return "\"granted\", \"denied\", \"prompt\""_s;
}

} // namespace WebCore

