/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSHardwareAcceleration.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(HardwareAcceleration enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("no-preference"),
        MAKE_STATIC_STRING_IMPL("prefer-hardware"),
        MAKE_STATIC_STRING_IMPL("prefer-software"),
    };
    static_assert(static_cast<size_t>(HardwareAcceleration::NoPreference) == 0, "HardwareAcceleration::NoPreference is not 0 as expected");
    static_assert(static_cast<size_t>(HardwareAcceleration::PreferHardware) == 1, "HardwareAcceleration::PreferHardware is not 1 as expected");
    static_assert(static_cast<size_t>(HardwareAcceleration::PreferSoftware) == 2, "HardwareAcceleration::PreferSoftware is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, HardwareAcceleration enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<HardwareAcceleration> parseEnumerationFromString<HardwareAcceleration>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, HardwareAcceleration>, 3> mappings {
        std::pair<ComparableASCIILiteral, HardwareAcceleration> { "no-preference"_s, HardwareAcceleration::NoPreference },
        std::pair<ComparableASCIILiteral, HardwareAcceleration> { "prefer-hardware"_s, HardwareAcceleration::PreferHardware },
        std::pair<ComparableASCIILiteral, HardwareAcceleration> { "prefer-software"_s, HardwareAcceleration::PreferSoftware },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<HardwareAcceleration> parseEnumeration<HardwareAcceleration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<HardwareAcceleration>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<HardwareAcceleration>()
{
    return "\"no-preference\", \"prefer-hardware\", \"prefer-software\""_s;
}

} // namespace WebCore


#endif // ENABLE(WEB_CODECS)
