/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFrameSetElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "JSDOMAbstractOperations.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorHandler.h"
#include "JSEventListener.h"
#include "JSWindowProxy.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_cols);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_cols);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_rows);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_rows);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onblur);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onblur);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onfocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onfocus);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onresize);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onresize);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onscroll);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onscroll);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onfocusin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onfocusin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onfocusout);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onfocusout);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onafterprint);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onafterprint);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onbeforeprint);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onbeforeprint);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onbeforeunload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onbeforeunload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onhashchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onhashchange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onlanguagechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onlanguagechange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onmessage);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onmessage);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onmessageerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onmessageerror);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onoffline);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onoffline);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_ononline);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_ononline);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpagehide);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpagehide);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpagereveal);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpagereveal);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpageshow);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpageshow);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpageswap);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpageswap);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpopstate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpopstate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onrejectionhandled);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onrejectionhandled);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onstorage);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onstorage);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onunhandledrejection);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onunhandledrejection);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_onunload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onunload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_ongamepadconnected);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_ongamepadconnected);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLFrameSetElement_ongamepaddisconnected);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLFrameSetElement_ongamepaddisconnected);

class JSHTMLFrameSetElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLFrameSetElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLFrameSetElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLFrameSetElementPrototype>(vm)) JSHTMLFrameSetElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLFrameSetElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLFrameSetElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLFrameSetElementPrototype, JSHTMLFrameSetElementPrototype::Base);

using JSHTMLFrameSetElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLFrameSetElement>;

template<> const ClassInfo JSHTMLFrameSetElementDOMConstructor::s_info = { "HTMLFrameSetElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLFrameSetElementDOMConstructor) };

template<> JSValue JSHTMLFrameSetElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLFrameSetElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLFrameSetElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLFrameSetElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 31> JSHTMLFrameSetElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElementConstructor, 0 } },
    HashTableValue { "cols"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_cols, setJSHTMLFrameSetElement_cols } },
    HashTableValue { "rows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_rows, setJSHTMLFrameSetElement_rows } },
    HashTableValue { "onblur"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onblur, setJSHTMLFrameSetElement_onblur } },
    HashTableValue { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onerror, setJSHTMLFrameSetElement_onerror } },
    HashTableValue { "onfocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onfocus, setJSHTMLFrameSetElement_onfocus } },
    HashTableValue { "onload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onload, setJSHTMLFrameSetElement_onload } },
    HashTableValue { "onresize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onresize, setJSHTMLFrameSetElement_onresize } },
    HashTableValue { "onscroll"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onscroll, setJSHTMLFrameSetElement_onscroll } },
    HashTableValue { "onfocusin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onfocusin, setJSHTMLFrameSetElement_onfocusin } },
    HashTableValue { "onfocusout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onfocusout, setJSHTMLFrameSetElement_onfocusout } },
    HashTableValue { "onafterprint"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onafterprint, setJSHTMLFrameSetElement_onafterprint } },
    HashTableValue { "onbeforeprint"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onbeforeprint, setJSHTMLFrameSetElement_onbeforeprint } },
    HashTableValue { "onbeforeunload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onbeforeunload, setJSHTMLFrameSetElement_onbeforeunload } },
    HashTableValue { "onhashchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onhashchange, setJSHTMLFrameSetElement_onhashchange } },
    HashTableValue { "onlanguagechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onlanguagechange, setJSHTMLFrameSetElement_onlanguagechange } },
    HashTableValue { "onmessage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onmessage, setJSHTMLFrameSetElement_onmessage } },
    HashTableValue { "onmessageerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onmessageerror, setJSHTMLFrameSetElement_onmessageerror } },
    HashTableValue { "onoffline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onoffline, setJSHTMLFrameSetElement_onoffline } },
    HashTableValue { "ononline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_ononline, setJSHTMLFrameSetElement_ononline } },
    HashTableValue { "onpagehide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onpagehide, setJSHTMLFrameSetElement_onpagehide } },
    HashTableValue { "onpagereveal"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onpagereveal, setJSHTMLFrameSetElement_onpagereveal } },
    HashTableValue { "onpageshow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onpageshow, setJSHTMLFrameSetElement_onpageshow } },
    HashTableValue { "onpageswap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onpageswap, setJSHTMLFrameSetElement_onpageswap } },
    HashTableValue { "onpopstate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onpopstate, setJSHTMLFrameSetElement_onpopstate } },
    HashTableValue { "onrejectionhandled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onrejectionhandled, setJSHTMLFrameSetElement_onrejectionhandled } },
    HashTableValue { "onstorage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onstorage, setJSHTMLFrameSetElement_onstorage } },
    HashTableValue { "onunhandledrejection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onunhandledrejection, setJSHTMLFrameSetElement_onunhandledrejection } },
    HashTableValue { "onunload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_onunload, setJSHTMLFrameSetElement_onunload } },
    HashTableValue { "ongamepadconnected"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_ongamepadconnected, setJSHTMLFrameSetElement_ongamepadconnected } },
    HashTableValue { "ongamepaddisconnected"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLFrameSetElement_ongamepaddisconnected, setJSHTMLFrameSetElement_ongamepaddisconnected } },
};

const ClassInfo JSHTMLFrameSetElementPrototype::s_info = { "HTMLFrameSetElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLFrameSetElementPrototype) };

void JSHTMLFrameSetElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLFrameSetElement::info(), JSHTMLFrameSetElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLFrameSetElement::s_info = { "HTMLFrameSetElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLFrameSetElement) };

JSHTMLFrameSetElement::JSHTMLFrameSetElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLFrameSetElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLFrameSetElement> JSHTMLFrameSetElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSHTMLFrameSetElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLFrameSetElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLFrameSetElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLFrameSetElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLFrameSetElement>(vm, globalObject);
}

JSValue JSHTMLFrameSetElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFrameSetElementDOMConstructor, DOMConstructorID::HTMLFrameSetElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSHTMLFrameSetElement::legacyPlatformObjectGetOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot, bool ignoreNamedProperties)
{
    auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (!ignoreNamedProperties) {
        using GetterIDLType = IDLInterface<WindowProxy>;
        auto getterFunctor = visibleNamedPropertyItemAccessorFunctor<GetterIDLType, JSHTMLFrameSetElement>([] (JSHTMLFrameSetElement& thisObject, PropertyName propertyName) -> decltype(auto) {
            return thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
        });
        if (auto namedProperty = accessVisibleNamedProperty<LegacyOverrideBuiltIns::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
            auto value = toJS<IDLInterface<WindowProxy>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, WTFMove(namedProperty.value()));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSHTMLFrameSetElement::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    bool ignoreNamedProperties = false;
    return legacyPlatformObjectGetOwnProperty(object, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
}

bool JSHTMLFrameSetElement::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    auto propertyName = Identifier::from(vm, index);
    using GetterIDLType = IDLInterface<WindowProxy>;
    auto getterFunctor = visibleNamedPropertyItemAccessorFunctor<GetterIDLType, JSHTMLFrameSetElement>([] (JSHTMLFrameSetElement& thisObject, PropertyName propertyName) -> decltype(auto) {
        return thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
    });
    if (auto namedProperty = accessVisibleNamedProperty<LegacyOverrideBuiltIns::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLInterface<WindowProxy>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, WTFMove(namedProperty.value()));
        RETURN_IF_EXCEPTION(throwScope, false);
        slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
        return true;
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSHTMLFrameSetElement::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, DontEnumPropertiesMode mode)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
        propertyNames.add(Identifier::fromString(vm, propertyName));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

bool JSHTMLFrameSetElement::put(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, JSValue value, PutPropertySlot& putPropertySlot)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    if (thisObject != putPropertySlot.thisValue()) [[unlikely]]
        return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (document->quirks().needsConfigurableIndexedPropertiesQuirk()) [[unlikely]]
            return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);
    }

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    throwScope.assertNoException();
    PropertyDescriptor ownDescriptor;
    PropertySlot slot(thisObject, PropertySlot::InternalMethodType::GetOwnProperty);;
    bool ignoreNamedProperties = true;
    bool hasOwnProperty = legacyPlatformObjectGetOwnProperty(thisObject, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (hasOwnProperty) {
        ownDescriptor.setPropertySlot(lexicalGlobalObject, propertyName, slot);
        RETURN_IF_EXCEPTION(throwScope, false);
    }
    RELEASE_AND_RETURN(throwScope, ordinarySetWithOwnDescriptor(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), WTFMove(ownDescriptor), putPropertySlot.isStrictMode()));
}

bool JSHTMLFrameSetElement::putByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index, JSValue value, bool shouldThrow)
{

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (document->quirks().needsConfigurableIndexedPropertiesQuirk()) [[unlikely]]
            return JSObject::putByIndex(cell, lexicalGlobalObject, index, value, shouldThrow);
    }

    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    throwScope.assertNoException();
    auto propertyName = Identifier::from(vm, index);
    PutPropertySlot putPropertySlot(thisObject, shouldThrow);
    RELEASE_AND_RETURN(throwScope, ordinarySetSlow(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), shouldThrow));
}

bool JSHTMLFrameSetElement::defineOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, const PropertyDescriptor& propertyDescriptor, bool shouldThrow)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    if (!propertyName.isSymbol()) {
        PropertySlot slot { thisObject, PropertySlot::InternalMethodType::VMInquiry, &lexicalGlobalObject->vm() };
        bool found = JSObject::getOwnPropertySlot(thisObject, lexicalGlobalObject, propertyName, slot);
        slot.disallowVMEntry.reset();
        RETURN_IF_EXCEPTION(throwScope, false);
        if (!found) {
            if (thisObject->wrapped().isSupportedPropertyName(propertyNameToString(propertyName)))
                return typeError(lexicalGlobalObject, throwScope, shouldThrow, "Cannot set named properties on this object"_s);
        }
    }

    PropertyDescriptor newPropertyDescriptor = propertyDescriptor;
    throwScope.release();
    return JSObject::defineOwnProperty(object, lexicalGlobalObject, propertyName, newPropertyDescriptor, shouldThrow);
}

bool JSHTMLFrameSetElement::deleteProperty(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, DeletePropertySlot& slot)
{
    auto& thisObject = *jsCast<JSHTMLFrameSetElement*>(cell);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (document->quirks().needsConfigurableIndexedPropertiesQuirk()) [[unlikely]]
            return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
    }

    if (!propertyName.isSymbol() && impl.isSupportedPropertyName(propertyNameToString(propertyName))) {
        PropertySlot slotForGet { &thisObject, PropertySlot::InternalMethodType::VMInquiry, &lexicalGlobalObject->vm() };
        if (!JSObject::getOwnPropertySlot(&thisObject, lexicalGlobalObject, propertyName, slotForGet))
            return false;
    }
    return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
}

bool JSHTMLFrameSetElement::deletePropertyByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index)
{
    UNUSED_PARAM(lexicalGlobalObject);
    auto& thisObject = *jsCast<JSHTMLFrameSetElement*>(cell);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (document->quirks().needsConfigurableIndexedPropertiesQuirk()) [[unlikely]]
            return JSObject::deletePropertyByIndex(cell, lexicalGlobalObject, index);
    }

    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto propertyName = Identifier::from(vm, index);
    if (impl.isSupportedPropertyName(propertyNameToString(propertyName))) {
        PropertySlot slotForGet { &thisObject, PropertySlot::InternalMethodType::VMInquiry, &lexicalGlobalObject->vm() };
        if (!JSObject::getOwnPropertySlot(&thisObject, lexicalGlobalObject, propertyName, slotForGet))
            return false;
    }
    return JSObject::deletePropertyByIndex(cell, lexicalGlobalObject, index);
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLFrameSetElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLFrameSetElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsHTMLFrameSetElement_colsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::colsAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_cols, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_colsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_colsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::colsAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_cols, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_colsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_rowsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::rowsAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_rows, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_rowsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_rowsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::rowsAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_rows, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_rowsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onblurGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onblurSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().blurEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSErrorHandler>(thisObject.protectedWrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onfocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onfocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().focusEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onresizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onresizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resizeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onscrollGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onscrollSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().scrollEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onfocusinGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().focusinEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onfocusin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onfocusinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onfocusinSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().focusinEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onfocusin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onfocusinSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onfocusoutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().focusoutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onfocusout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onfocusoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onfocusoutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().focusoutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onfocusout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onfocusoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onafterprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().afterprintEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onafterprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onafterprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onafterprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().afterprintEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onafterprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onafterprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onbeforeprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforeprintEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onbeforeprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onbeforeprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onbeforeprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforeprintEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onbeforeprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onbeforeprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onbeforeunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforeunloadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onbeforeunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onbeforeunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onbeforeunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforeunloadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onbeforeunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onbeforeunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onhashchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().hashchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onhashchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onhashchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onhashchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().hashchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onhashchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onhashchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onlanguagechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().languagechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onlanguagechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onlanguagechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onlanguagechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().languagechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onlanguagechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onlanguagechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onmessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onmessageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().messageEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onmessageerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().messageerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onmessageerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onmessageerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().messageerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onmessageerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onofflineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().offlineEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onoffline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onofflineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onofflineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().offlineEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onoffline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onofflineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_ononlineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().onlineEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_ononline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_ononlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_ononlineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().onlineEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_ononline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_ononlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onpagehideGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pagehideEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpagehide, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onpagehideGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onpagehideSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pagehideEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpagehide, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onpagehideSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onpagerevealGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pagerevealEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpagereveal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onpagerevealGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onpagerevealSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pagerevealEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpagereveal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onpagerevealSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onpageshowGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pageshowEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpageshow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onpageshowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onpageshowSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pageshowEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpageshow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onpageshowSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onpageswapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pageswapEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpageswap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onpageswapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onpageswapSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pageswapEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpageswap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onpageswapSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onpopstateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().popstateEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onpopstate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onpopstateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onpopstateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().popstateEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onpopstate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onpopstateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onrejectionhandledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().rejectionhandledEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onrejectionhandled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onrejectionhandledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onrejectionhandledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().rejectionhandledEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onrejectionhandled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onrejectionhandledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onstorageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().storageEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onstorage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onstorageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onstorageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().storageEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onstorage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onstorageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onunhandledrejectionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().unhandledrejectionEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onunhandledrejection, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onunhandledrejectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onunhandledrejectionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().unhandledrejectionEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onunhandledrejection, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onunhandledrejectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_onunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().unloadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_onunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_onunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_onunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().unloadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_onunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_onunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_ongamepadconnectedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().gamepadconnectedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_ongamepadconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_ongamepadconnectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_ongamepadconnectedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().gamepadconnectedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_ongamepadconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_ongamepadconnectedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLFrameSetElement_ongamepaddisconnectedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.protectedWrapped(), eventNames().gamepaddisconnectedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLFrameSetElement_ongamepaddisconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElement_ongamepaddisconnectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLFrameSetElement_ongamepaddisconnectedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().gamepaddisconnectedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLFrameSetElement_ongamepaddisconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElement_ongamepaddisconnectedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSHTMLFrameSetElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLFrameSetElement, UseCustomHeapCellType::No>(vm, "JSHTMLFrameSetElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLFrameSetElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLFrameSetElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLFrameSetElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLFrameSetElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLFrameSetElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
