/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#if ENABLE(MODEL_PROCESS)
#include "ModelProcessProxy.h"

#if PLATFORM(VISION) && ENABLE(GPU_PROCESS)
#include "ArgumentCoders.h" // NOLINT
#endif
#include "Decoder.h" // NOLINT
#include "HandleMessage.h" // NOLINT
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
#include "LayerHostingContext.h" // NOLINT
#endif
#include "ModelProcessProxyMessages.h" // NOLINT
#if PLATFORM(VISION) && ENABLE(GPU_PROCESS)
#include "SharedFileHandle.h" // NOLINT
#endif
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
#include "WebPageProxyIdentifier.h" // NOLINT
#endif
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
#include <WebCore/PageIdentifier.h> // NOLINT
#endif
#include <WebCore/ProcessIdentifier.h> // NOLINT
#if PLATFORM(VISION) && ENABLE(GPU_PROCESS)
#include <optional> // NOLINT
#endif

#if ENABLE(IPC_TESTING_API)
#include "JSIPCBinding.h"
#endif

namespace WebKit {

void ModelProcessProxy::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    Ref protectedThis { *this };
    if (decoder.messageName() == Messages::ModelProcessProxy::TerminateWebProcess::name())
        return IPC::handleMessage<Messages::ModelProcessProxy::TerminateWebProcess>(connection, decoder, this, &ModelProcessProxy::terminateWebProcess);
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    if (decoder.messageName() == Messages::ModelProcessProxy::DidCreateContextForVisibilityPropagation::name())
        return IPC::handleMessage<Messages::ModelProcessProxy::DidCreateContextForVisibilityPropagation>(connection, decoder, this, &ModelProcessProxy::didCreateContextForVisibilityPropagation);
#endif
    if (decoder.messageName() == Messages::ModelProcessProxy::ProcessIsReadyToExit::name())
        return IPC::handleMessage<Messages::ModelProcessProxy::ProcessIsReadyToExit>(connection, decoder, this, &ModelProcessProxy::processIsReadyToExit);
#if PLATFORM(VISION) && ENABLE(GPU_PROCESS)
    if (decoder.messageName() == Messages::ModelProcessProxy::RequestSharedSimulationConnection::name())
        return IPC::handleMessageAsync<Messages::ModelProcessProxy::RequestSharedSimulationConnection>(connection, decoder, this, &ModelProcessProxy::requestSharedSimulationConnection);
#endif
    UNUSED_PARAM(connection);
    RELEASE_LOG_ERROR(IPC, "Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()).characters(), decoder.destinationID());
    decoder.markInvalid();
}

} // namespace WebKit

#if ENABLE(IPC_TESTING_API)

namespace IPC {

template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ModelProcessProxy_TerminateWebProcess>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ModelProcessProxy::TerminateWebProcess::Arguments>(globalObject, decoder);
}
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ModelProcessProxy_DidCreateContextForVisibilityPropagation>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ModelProcessProxy::DidCreateContextForVisibilityPropagation::Arguments>(globalObject, decoder);
}
#endif
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ModelProcessProxy_ProcessIsReadyToExit>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ModelProcessProxy::ProcessIsReadyToExit::Arguments>(globalObject, decoder);
}
#if PLATFORM(VISION) && ENABLE(GPU_PROCESS)
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ModelProcessProxy_RequestSharedSimulationConnection>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ModelProcessProxy::RequestSharedSimulationConnection::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessageReply<MessageName::ModelProcessProxy_RequestSharedSimulationConnection>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ModelProcessProxy::RequestSharedSimulationConnection::ReplyArguments>(globalObject, decoder);
}
#endif

}

#endif


#endif // ENABLE(MODEL_PROCESS)
