/** @file
 * VirtualBox API class wrapper code for IUnattended.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_UNATTENDED

#include "UnattendedWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(UnattendedWrap)

//
// IUnattended properties
//

STDMETHODIMP UnattendedWrap::COMGETTER(IsoPath)(BSTR *aIsoPath)
{
    LogRelFlow(("{%p} %s: enter aIsoPath=%p\n", this, "Unattended::getIsoPath", aIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsoPath);
        BSTROutConverter TmpIsoPath(aIsoPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISOPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsoPath(TmpIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsoPath=%ls hrc=%Rhrc\n", this, "Unattended::getIsoPath", *aIsoPath, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(IsoPath)(IN_BSTR aIsoPath)
{
    LogRelFlow(("{%p} %s: enter aIsoPath=%ls\n", this, "Unattended::setIsoPath", aIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpIsoPath(aIsoPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ISOPATH_ENTER(this, TmpIsoPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIsoPath(TmpIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setIsoPath", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(Machine)(IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p\n", this, "Unattended::getMachine", aMachine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_MACHINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachine(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_MACHINE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_MACHINE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_MACHINE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachine=%p hrc=%Rhrc\n", this, "Unattended::getMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(Machine)(IMachine *aMachine)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p\n", this, "Unattended::setMachine", aMachine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ComTypeInConverter<IMachine> TmpMachine(aMachine);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_MACHINE_ENTER(this, (void *)TmpMachine.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMachine(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_MACHINE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_MACHINE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_MACHINE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setMachine", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(User)(BSTR *aUser)
{
    LogRelFlow(("{%p} %s: enter aUser=%p\n", this, "Unattended::getUser", aUser));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUser);
        BSTROutConverter TmpUser(aUser);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUser(TmpUser.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USER_RETURN(this, hrc, 0 /*normal*/,TmpUser.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUser=%ls hrc=%Rhrc\n", this, "Unattended::getUser", *aUser, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(User)(IN_BSTR aUser)
{
    LogRelFlow(("{%p} %s: enter aUser=%ls\n", this, "Unattended::setUser", aUser));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpUser(aUser);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USER_ENTER(this, TmpUser.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setUser(TmpUser.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USER_RETURN(this, hrc, 0 /*normal*/,TmpUser.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setUser", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(UserPassword)(BSTR *aUserPassword)
{
    LogRelFlow(("{%p} %s: enter aUserPassword=%p\n", this, "Unattended::getUserPassword", aUserPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUserPassword);
        BSTROutConverter TmpUserPassword(aUserPassword);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPASSWORD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUserPassword(TmpUserPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPASSWORD_RETURN(this, hrc, 0 /*normal*/,TmpUserPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUserPassword=%ls hrc=%Rhrc\n", this, "Unattended::getUserPassword", *aUserPassword, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(UserPassword)(IN_BSTR aUserPassword)
{
    LogRelFlow(("{%p} %s: enter aUserPassword=%ls\n", this, "Unattended::setUserPassword", aUserPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpUserPassword(aUserPassword);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPASSWORD_ENTER(this, TmpUserPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setUserPassword(TmpUserPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPASSWORD_RETURN(this, hrc, 0 /*normal*/,TmpUserPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setUserPassword", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(AdminPassword)(BSTR *aAdminPassword)
{
    LogRelFlow(("{%p} %s: enter aAdminPassword=%p\n", this, "Unattended::getAdminPassword", aAdminPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdminPassword);
        BSTROutConverter TmpAdminPassword(aAdminPassword);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADMINPASSWORD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdminPassword(TmpAdminPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADMINPASSWORD_RETURN(this, hrc, 0 /*normal*/,TmpAdminPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADMINPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADMINPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdminPassword=%ls hrc=%Rhrc\n", this, "Unattended::getAdminPassword", *aAdminPassword, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(AdminPassword)(IN_BSTR aAdminPassword)
{
    LogRelFlow(("{%p} %s: enter aAdminPassword=%ls\n", this, "Unattended::setAdminPassword", aAdminPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpAdminPassword(aAdminPassword);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADMINPASSWORD_ENTER(this, TmpAdminPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAdminPassword(TmpAdminPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADMINPASSWORD_RETURN(this, hrc, 0 /*normal*/,TmpAdminPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADMINPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADMINPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setAdminPassword", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(FullUserName)(BSTR *aFullUserName)
{
    LogRelFlow(("{%p} %s: enter aFullUserName=%p\n", this, "Unattended::getFullUserName", aFullUserName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFullUserName);
        BSTROutConverter TmpFullUserName(aFullUserName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_FULLUSERNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFullUserName(TmpFullUserName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_FULLUSERNAME_RETURN(this, hrc, 0 /*normal*/,TmpFullUserName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_FULLUSERNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_FULLUSERNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFullUserName=%ls hrc=%Rhrc\n", this, "Unattended::getFullUserName", *aFullUserName, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(FullUserName)(IN_BSTR aFullUserName)
{
    LogRelFlow(("{%p} %s: enter aFullUserName=%ls\n", this, "Unattended::setFullUserName", aFullUserName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpFullUserName(aFullUserName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_FULLUSERNAME_ENTER(this, TmpFullUserName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFullUserName(TmpFullUserName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_FULLUSERNAME_RETURN(this, hrc, 0 /*normal*/,TmpFullUserName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_FULLUSERNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_FULLUSERNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setFullUserName", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(ProductKey)(BSTR *aProductKey)
{
    LogRelFlow(("{%p} %s: enter aProductKey=%p\n", this, "Unattended::getProductKey", aProductKey));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProductKey);
        BSTROutConverter TmpProductKey(aProductKey);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProductKey(TmpProductKey.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEY_RETURN(this, hrc, 0 /*normal*/,TmpProductKey.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProductKey=%ls hrc=%Rhrc\n", this, "Unattended::getProductKey", *aProductKey, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(ProductKey)(IN_BSTR aProductKey)
{
    LogRelFlow(("{%p} %s: enter aProductKey=%ls\n", this, "Unattended::setProductKey", aProductKey));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpProductKey(aProductKey);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PRODUCTKEY_ENTER(this, TmpProductKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProductKey(TmpProductKey.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PRODUCTKEY_RETURN(this, hrc, 0 /*normal*/,TmpProductKey.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PRODUCTKEY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PRODUCTKEY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setProductKey", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(AdditionsIsoPath)(BSTR *aAdditionsIsoPath)
{
    LogRelFlow(("{%p} %s: enter aAdditionsIsoPath=%p\n", this, "Unattended::getAdditionsIsoPath", aAdditionsIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdditionsIsoPath);
        BSTROutConverter TmpAdditionsIsoPath(aAdditionsIsoPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADDITIONSISOPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdditionsIsoPath(TmpAdditionsIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADDITIONSISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpAdditionsIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADDITIONSISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ADDITIONSISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdditionsIsoPath=%ls hrc=%Rhrc\n", this, "Unattended::getAdditionsIsoPath", *aAdditionsIsoPath, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(AdditionsIsoPath)(IN_BSTR aAdditionsIsoPath)
{
    LogRelFlow(("{%p} %s: enter aAdditionsIsoPath=%ls\n", this, "Unattended::setAdditionsIsoPath", aAdditionsIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpAdditionsIsoPath(aAdditionsIsoPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADDITIONSISOPATH_ENTER(this, TmpAdditionsIsoPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAdditionsIsoPath(TmpAdditionsIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADDITIONSISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpAdditionsIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADDITIONSISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_ADDITIONSISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setAdditionsIsoPath", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InstallGuestAdditions)(BOOL *aInstallGuestAdditions)
{
    LogRelFlow(("{%p} %s: enter aInstallGuestAdditions=%p\n", this, "Unattended::getInstallGuestAdditions", aInstallGuestAdditions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInstallGuestAdditions);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLGUESTADDITIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInstallGuestAdditions(aInstallGuestAdditions);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLGUESTADDITIONS_RETURN(this, hrc, 0 /*normal*/,*aInstallGuestAdditions != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLGUESTADDITIONS_RETURN(this, hrc, 1 /*hrc exception*/,*aInstallGuestAdditions != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLGUESTADDITIONS_RETURN(this, hrc, 9 /*unhandled exception*/,*aInstallGuestAdditions != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInstallGuestAdditions=%RTbool hrc=%Rhrc\n", this, "Unattended::getInstallGuestAdditions", *aInstallGuestAdditions, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(InstallGuestAdditions)(BOOL aInstallGuestAdditions)
{
    LogRelFlow(("{%p} %s: enter aInstallGuestAdditions=%RTbool\n", this, "Unattended::setInstallGuestAdditions", aInstallGuestAdditions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLGUESTADDITIONS_ENTER(this, aInstallGuestAdditions != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setInstallGuestAdditions(aInstallGuestAdditions != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLGUESTADDITIONS_RETURN(this, hrc, 0 /*normal*/,aInstallGuestAdditions != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLGUESTADDITIONS_RETURN(this, hrc, 1 /*hrc exception*/,aInstallGuestAdditions != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLGUESTADDITIONS_RETURN(this, hrc, 9 /*unhandled exception*/,aInstallGuestAdditions != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setInstallGuestAdditions", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(ProductKeyRequired)(BOOL *aProductKeyRequired)
{
    LogRelFlow(("{%p} %s: enter aProductKeyRequired=%p\n", this, "Unattended::getProductKeyRequired", aProductKeyRequired));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProductKeyRequired);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEYREQUIRED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProductKeyRequired(aProductKeyRequired);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEYREQUIRED_RETURN(this, hrc, 0 /*normal*/,*aProductKeyRequired != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEYREQUIRED_RETURN(this, hrc, 1 /*hrc exception*/,*aProductKeyRequired != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PRODUCTKEYREQUIRED_RETURN(this, hrc, 9 /*unhandled exception*/,*aProductKeyRequired != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProductKeyRequired=%RTbool hrc=%Rhrc\n", this, "Unattended::getProductKeyRequired", *aProductKeyRequired, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(ValidationKitIsoPath)(BSTR *aValidationKitIsoPath)
{
    LogRelFlow(("{%p} %s: enter aValidationKitIsoPath=%p\n", this, "Unattended::getValidationKitIsoPath", aValidationKitIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValidationKitIsoPath);
        BSTROutConverter TmpValidationKitIsoPath(aValidationKitIsoPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_VALIDATIONKITISOPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValidationKitIsoPath(TmpValidationKitIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_VALIDATIONKITISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpValidationKitIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_VALIDATIONKITISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_VALIDATIONKITISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValidationKitIsoPath=%ls hrc=%Rhrc\n", this, "Unattended::getValidationKitIsoPath", *aValidationKitIsoPath, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(ValidationKitIsoPath)(IN_BSTR aValidationKitIsoPath)
{
    LogRelFlow(("{%p} %s: enter aValidationKitIsoPath=%ls\n", this, "Unattended::setValidationKitIsoPath", aValidationKitIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpValidationKitIsoPath(aValidationKitIsoPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_VALIDATIONKITISOPATH_ENTER(this, TmpValidationKitIsoPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setValidationKitIsoPath(TmpValidationKitIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_VALIDATIONKITISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpValidationKitIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_VALIDATIONKITISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_VALIDATIONKITISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setValidationKitIsoPath", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InstallTestExecService)(BOOL *aInstallTestExecService)
{
    LogRelFlow(("{%p} %s: enter aInstallTestExecService=%p\n", this, "Unattended::getInstallTestExecService", aInstallTestExecService));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInstallTestExecService);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLTESTEXECSERVICE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInstallTestExecService(aInstallTestExecService);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLTESTEXECSERVICE_RETURN(this, hrc, 0 /*normal*/,*aInstallTestExecService != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLTESTEXECSERVICE_RETURN(this, hrc, 1 /*hrc exception*/,*aInstallTestExecService != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLTESTEXECSERVICE_RETURN(this, hrc, 9 /*unhandled exception*/,*aInstallTestExecService != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInstallTestExecService=%RTbool hrc=%Rhrc\n", this, "Unattended::getInstallTestExecService", *aInstallTestExecService, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(InstallTestExecService)(BOOL aInstallTestExecService)
{
    LogRelFlow(("{%p} %s: enter aInstallTestExecService=%RTbool\n", this, "Unattended::setInstallTestExecService", aInstallTestExecService));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLTESTEXECSERVICE_ENTER(this, aInstallTestExecService != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setInstallTestExecService(aInstallTestExecService != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLTESTEXECSERVICE_RETURN(this, hrc, 0 /*normal*/,aInstallTestExecService != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLTESTEXECSERVICE_RETURN(this, hrc, 1 /*hrc exception*/,aInstallTestExecService != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLTESTEXECSERVICE_RETURN(this, hrc, 9 /*unhandled exception*/,aInstallTestExecService != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setInstallTestExecService", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(UserPayloadIsoPath)(BSTR *aUserPayloadIsoPath)
{
    LogRelFlow(("{%p} %s: enter aUserPayloadIsoPath=%p\n", this, "Unattended::getUserPayloadIsoPath", aUserPayloadIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUserPayloadIsoPath);
        BSTROutConverter TmpUserPayloadIsoPath(aUserPayloadIsoPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPAYLOADISOPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUserPayloadIsoPath(TmpUserPayloadIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPAYLOADISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpUserPayloadIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPAYLOADISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_USERPAYLOADISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUserPayloadIsoPath=%ls hrc=%Rhrc\n", this, "Unattended::getUserPayloadIsoPath", *aUserPayloadIsoPath, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(UserPayloadIsoPath)(IN_BSTR aUserPayloadIsoPath)
{
    LogRelFlow(("{%p} %s: enter aUserPayloadIsoPath=%ls\n", this, "Unattended::setUserPayloadIsoPath", aUserPayloadIsoPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpUserPayloadIsoPath(aUserPayloadIsoPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPAYLOADISOPATH_ENTER(this, TmpUserPayloadIsoPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setUserPayloadIsoPath(TmpUserPayloadIsoPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPAYLOADISOPATH_RETURN(this, hrc, 0 /*normal*/,TmpUserPayloadIsoPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPAYLOADISOPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_USERPAYLOADISOPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setUserPayloadIsoPath", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InstallUserPayload)(BOOL *aInstallUserPayload)
{
    LogRelFlow(("{%p} %s: enter aInstallUserPayload=%p\n", this, "Unattended::getInstallUserPayload", aInstallUserPayload));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInstallUserPayload);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLUSERPAYLOAD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInstallUserPayload(aInstallUserPayload);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLUSERPAYLOAD_RETURN(this, hrc, 0 /*normal*/,*aInstallUserPayload != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLUSERPAYLOAD_RETURN(this, hrc, 1 /*hrc exception*/,*aInstallUserPayload != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_INSTALLUSERPAYLOAD_RETURN(this, hrc, 9 /*unhandled exception*/,*aInstallUserPayload != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInstallUserPayload=%RTbool hrc=%Rhrc\n", this, "Unattended::getInstallUserPayload", *aInstallUserPayload, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(InstallUserPayload)(BOOL aInstallUserPayload)
{
    LogRelFlow(("{%p} %s: enter aInstallUserPayload=%RTbool\n", this, "Unattended::setInstallUserPayload", aInstallUserPayload));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLUSERPAYLOAD_ENTER(this, aInstallUserPayload != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setInstallUserPayload(aInstallUserPayload != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLUSERPAYLOAD_RETURN(this, hrc, 0 /*normal*/,aInstallUserPayload != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLUSERPAYLOAD_RETURN(this, hrc, 1 /*hrc exception*/,aInstallUserPayload != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_INSTALLUSERPAYLOAD_RETURN(this, hrc, 9 /*unhandled exception*/,aInstallUserPayload != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setInstallUserPayload", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(TimeZone)(BSTR *aTimeZone)
{
    LogRelFlow(("{%p} %s: enter aTimeZone=%p\n", this, "Unattended::getTimeZone", aTimeZone));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimeZone);
        BSTROutConverter TmpTimeZone(aTimeZone);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_TIMEZONE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTimeZone(TmpTimeZone.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_TIMEZONE_RETURN(this, hrc, 0 /*normal*/,TmpTimeZone.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_TIMEZONE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_TIMEZONE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimeZone=%ls hrc=%Rhrc\n", this, "Unattended::getTimeZone", *aTimeZone, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(TimeZone)(IN_BSTR aTimeZone)
{
    LogRelFlow(("{%p} %s: enter aTimeZone=%ls\n", this, "Unattended::setTimeZone", aTimeZone));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTimeZone(aTimeZone);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_TIMEZONE_ENTER(this, TmpTimeZone.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTimeZone(TmpTimeZone.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_TIMEZONE_RETURN(this, hrc, 0 /*normal*/,TmpTimeZone.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_TIMEZONE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_TIMEZONE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setTimeZone", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(KeyboardLayout)(BSTR *aKeyboardLayout)
{
    LogRelFlow(("{%p} %s: enter aKeyboardLayout=%p\n", this, "Unattended::getKeyboardLayout", aKeyboardLayout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyboardLayout);
        BSTROutConverter TmpKeyboardLayout(aKeyboardLayout);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDLAYOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyboardLayout(TmpKeyboardLayout.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDLAYOUT_RETURN(this, hrc, 0 /*normal*/,TmpKeyboardLayout.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDLAYOUT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDLAYOUT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyboardLayout=%ls hrc=%Rhrc\n", this, "Unattended::getKeyboardLayout", *aKeyboardLayout, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(KeyboardLayout)(IN_BSTR aKeyboardLayout)
{
    LogRelFlow(("{%p} %s: enter aKeyboardLayout=%ls\n", this, "Unattended::setKeyboardLayout", aKeyboardLayout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpKeyboardLayout(aKeyboardLayout);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDLAYOUT_ENTER(this, TmpKeyboardLayout.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setKeyboardLayout(TmpKeyboardLayout.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDLAYOUT_RETURN(this, hrc, 0 /*normal*/,TmpKeyboardLayout.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDLAYOUT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDLAYOUT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setKeyboardLayout", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(KeyboardVariant)(BSTR *aKeyboardVariant)
{
    LogRelFlow(("{%p} %s: enter aKeyboardVariant=%p\n", this, "Unattended::getKeyboardVariant", aKeyboardVariant));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyboardVariant);
        BSTROutConverter TmpKeyboardVariant(aKeyboardVariant);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDVARIANT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyboardVariant(TmpKeyboardVariant.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDVARIANT_RETURN(this, hrc, 0 /*normal*/,TmpKeyboardVariant.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDVARIANT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_KEYBOARDVARIANT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyboardVariant=%ls hrc=%Rhrc\n", this, "Unattended::getKeyboardVariant", *aKeyboardVariant, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(KeyboardVariant)(IN_BSTR aKeyboardVariant)
{
    LogRelFlow(("{%p} %s: enter aKeyboardVariant=%ls\n", this, "Unattended::setKeyboardVariant", aKeyboardVariant));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpKeyboardVariant(aKeyboardVariant);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDVARIANT_ENTER(this, TmpKeyboardVariant.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setKeyboardVariant(TmpKeyboardVariant.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDVARIANT_RETURN(this, hrc, 0 /*normal*/,TmpKeyboardVariant.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDVARIANT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_KEYBOARDVARIANT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setKeyboardVariant", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(Locale)(BSTR *aLocale)
{
    LogRelFlow(("{%p} %s: enter aLocale=%p\n", this, "Unattended::getLocale", aLocale));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLocale);
        BSTROutConverter TmpLocale(aLocale);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LOCALE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLocale(TmpLocale.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LOCALE_RETURN(this, hrc, 0 /*normal*/,TmpLocale.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LOCALE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LOCALE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLocale=%ls hrc=%Rhrc\n", this, "Unattended::getLocale", *aLocale, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(Locale)(IN_BSTR aLocale)
{
    LogRelFlow(("{%p} %s: enter aLocale=%ls\n", this, "Unattended::setLocale", aLocale));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLocale(aLocale);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LOCALE_ENTER(this, TmpLocale.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLocale(TmpLocale.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LOCALE_RETURN(this, hrc, 0 /*normal*/,TmpLocale.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LOCALE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LOCALE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setLocale", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(Language)(BSTR *aLanguage)
{
    LogRelFlow(("{%p} %s: enter aLanguage=%p\n", this, "Unattended::getLanguage", aLanguage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLanguage);
        BSTROutConverter TmpLanguage(aLanguage);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LANGUAGE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLanguage(TmpLanguage.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LANGUAGE_RETURN(this, hrc, 0 /*normal*/,TmpLanguage.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LANGUAGE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_LANGUAGE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLanguage=%ls hrc=%Rhrc\n", this, "Unattended::getLanguage", *aLanguage, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(Language)(IN_BSTR aLanguage)
{
    LogRelFlow(("{%p} %s: enter aLanguage=%ls\n", this, "Unattended::setLanguage", aLanguage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLanguage(aLanguage);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LANGUAGE_ENTER(this, TmpLanguage.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLanguage(TmpLanguage.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LANGUAGE_RETURN(this, hrc, 0 /*normal*/,TmpLanguage.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LANGUAGE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_LANGUAGE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setLanguage", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(Country)(BSTR *aCountry)
{
    LogRelFlow(("{%p} %s: enter aCountry=%p\n", this, "Unattended::getCountry", aCountry));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCountry);
        BSTROutConverter TmpCountry(aCountry);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_COUNTRY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCountry(TmpCountry.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_COUNTRY_RETURN(this, hrc, 0 /*normal*/,TmpCountry.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_COUNTRY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_COUNTRY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCountry=%ls hrc=%Rhrc\n", this, "Unattended::getCountry", *aCountry, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(Country)(IN_BSTR aCountry)
{
    LogRelFlow(("{%p} %s: enter aCountry=%ls\n", this, "Unattended::setCountry", aCountry));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpCountry(aCountry);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_COUNTRY_ENTER(this, TmpCountry.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCountry(TmpCountry.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_COUNTRY_RETURN(this, hrc, 0 /*normal*/,TmpCountry.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_COUNTRY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_COUNTRY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setCountry", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(Proxy)(BSTR *aProxy)
{
    LogRelFlow(("{%p} %s: enter aProxy=%p\n", this, "Unattended::getProxy", aProxy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProxy);
        BSTROutConverter TmpProxy(aProxy);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PROXY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProxy(TmpProxy.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PROXY_RETURN(this, hrc, 0 /*normal*/,TmpProxy.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PROXY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PROXY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProxy=%ls hrc=%Rhrc\n", this, "Unattended::getProxy", *aProxy, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(Proxy)(IN_BSTR aProxy)
{
    LogRelFlow(("{%p} %s: enter aProxy=%ls\n", this, "Unattended::setProxy", aProxy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpProxy(aProxy);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PROXY_ENTER(this, TmpProxy.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProxy(TmpProxy.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PROXY_RETURN(this, hrc, 0 /*normal*/,TmpProxy.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PROXY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PROXY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setProxy", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(PackageSelectionAdjustments)(BSTR *aPackageSelectionAdjustments)
{
    LogRelFlow(("{%p} %s: enter aPackageSelectionAdjustments=%p\n", this, "Unattended::getPackageSelectionAdjustments", aPackageSelectionAdjustments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPackageSelectionAdjustments);
        BSTROutConverter TmpPackageSelectionAdjustments(aPackageSelectionAdjustments);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PACKAGESELECTIONADJUSTMENTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPackageSelectionAdjustments(TmpPackageSelectionAdjustments.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PACKAGESELECTIONADJUSTMENTS_RETURN(this, hrc, 0 /*normal*/,TmpPackageSelectionAdjustments.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PACKAGESELECTIONADJUSTMENTS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_PACKAGESELECTIONADJUSTMENTS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPackageSelectionAdjustments=%ls hrc=%Rhrc\n", this, "Unattended::getPackageSelectionAdjustments", *aPackageSelectionAdjustments, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(PackageSelectionAdjustments)(IN_BSTR aPackageSelectionAdjustments)
{
    LogRelFlow(("{%p} %s: enter aPackageSelectionAdjustments=%ls\n", this, "Unattended::setPackageSelectionAdjustments", aPackageSelectionAdjustments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpPackageSelectionAdjustments(aPackageSelectionAdjustments);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PACKAGESELECTIONADJUSTMENTS_ENTER(this, TmpPackageSelectionAdjustments.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPackageSelectionAdjustments(TmpPackageSelectionAdjustments.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PACKAGESELECTIONADJUSTMENTS_RETURN(this, hrc, 0 /*normal*/,TmpPackageSelectionAdjustments.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PACKAGESELECTIONADJUSTMENTS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_PACKAGESELECTIONADJUSTMENTS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setPackageSelectionAdjustments", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(Hostname)(BSTR *aHostname)
{
    LogRelFlow(("{%p} %s: enter aHostname=%p\n", this, "Unattended::getHostname", aHostname));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostname);
        BSTROutConverter TmpHostname(aHostname);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_HOSTNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostname(TmpHostname.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_HOSTNAME_RETURN(this, hrc, 0 /*normal*/,TmpHostname.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_HOSTNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_HOSTNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostname=%ls hrc=%Rhrc\n", this, "Unattended::getHostname", *aHostname, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(Hostname)(IN_BSTR aHostname)
{
    LogRelFlow(("{%p} %s: enter aHostname=%ls\n", this, "Unattended::setHostname", aHostname));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpHostname(aHostname);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_HOSTNAME_ENTER(this, TmpHostname.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHostname(TmpHostname.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_HOSTNAME_RETURN(this, hrc, 0 /*normal*/,TmpHostname.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_HOSTNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_HOSTNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setHostname", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(AuxiliaryBasePath)(BSTR *aAuxiliaryBasePath)
{
    LogRelFlow(("{%p} %s: enter aAuxiliaryBasePath=%p\n", this, "Unattended::getAuxiliaryBasePath", aAuxiliaryBasePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAuxiliaryBasePath);
        BSTROutConverter TmpAuxiliaryBasePath(aAuxiliaryBasePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AUXILIARYBASEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAuxiliaryBasePath(TmpAuxiliaryBasePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AUXILIARYBASEPATH_RETURN(this, hrc, 0 /*normal*/,TmpAuxiliaryBasePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AUXILIARYBASEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AUXILIARYBASEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAuxiliaryBasePath=%ls hrc=%Rhrc\n", this, "Unattended::getAuxiliaryBasePath", *aAuxiliaryBasePath, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(AuxiliaryBasePath)(IN_BSTR aAuxiliaryBasePath)
{
    LogRelFlow(("{%p} %s: enter aAuxiliaryBasePath=%ls\n", this, "Unattended::setAuxiliaryBasePath", aAuxiliaryBasePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpAuxiliaryBasePath(aAuxiliaryBasePath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AUXILIARYBASEPATH_ENTER(this, TmpAuxiliaryBasePath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAuxiliaryBasePath(TmpAuxiliaryBasePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AUXILIARYBASEPATH_RETURN(this, hrc, 0 /*normal*/,TmpAuxiliaryBasePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AUXILIARYBASEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AUXILIARYBASEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setAuxiliaryBasePath", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(ImageIndex)(ULONG *aImageIndex)
{
    LogRelFlow(("{%p} %s: enter aImageIndex=%p\n", this, "Unattended::getImageIndex", aImageIndex));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aImageIndex);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_IMAGEINDEX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getImageIndex(aImageIndex);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_IMAGEINDEX_RETURN(this, hrc, 0 /*normal*/,*aImageIndex);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_IMAGEINDEX_RETURN(this, hrc, 1 /*hrc exception*/,*aImageIndex);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_IMAGEINDEX_RETURN(this, hrc, 9 /*unhandled exception*/,*aImageIndex);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aImageIndex=%RU32 hrc=%Rhrc\n", this, "Unattended::getImageIndex", *aImageIndex, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(ImageIndex)(ULONG aImageIndex)
{
    LogRelFlow(("{%p} %s: enter aImageIndex=%RU32\n", this, "Unattended::setImageIndex", aImageIndex));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_IMAGEINDEX_ENTER(this, aImageIndex);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setImageIndex(aImageIndex);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_IMAGEINDEX_RETURN(this, hrc, 0 /*normal*/,aImageIndex);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_IMAGEINDEX_RETURN(this, hrc, 1 /*hrc exception*/,aImageIndex);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_IMAGEINDEX_RETURN(this, hrc, 9 /*unhandled exception*/,aImageIndex);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setImageIndex", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(ScriptTemplatePath)(BSTR *aScriptTemplatePath)
{
    LogRelFlow(("{%p} %s: enter aScriptTemplatePath=%p\n", this, "Unattended::getScriptTemplatePath", aScriptTemplatePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScriptTemplatePath);
        BSTROutConverter TmpScriptTemplatePath(aScriptTemplatePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_SCRIPTTEMPLATEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScriptTemplatePath(TmpScriptTemplatePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_SCRIPTTEMPLATEPATH_RETURN(this, hrc, 0 /*normal*/,TmpScriptTemplatePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_SCRIPTTEMPLATEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_SCRIPTTEMPLATEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScriptTemplatePath=%ls hrc=%Rhrc\n", this, "Unattended::getScriptTemplatePath", *aScriptTemplatePath, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(ScriptTemplatePath)(IN_BSTR aScriptTemplatePath)
{
    LogRelFlow(("{%p} %s: enter aScriptTemplatePath=%ls\n", this, "Unattended::setScriptTemplatePath", aScriptTemplatePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpScriptTemplatePath(aScriptTemplatePath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_SCRIPTTEMPLATEPATH_ENTER(this, TmpScriptTemplatePath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setScriptTemplatePath(TmpScriptTemplatePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_SCRIPTTEMPLATEPATH_RETURN(this, hrc, 0 /*normal*/,TmpScriptTemplatePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_SCRIPTTEMPLATEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_SCRIPTTEMPLATEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setScriptTemplatePath", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(PostInstallScriptTemplatePath)(BSTR *aPostInstallScriptTemplatePath)
{
    LogRelFlow(("{%p} %s: enter aPostInstallScriptTemplatePath=%p\n", this, "Unattended::getPostInstallScriptTemplatePath", aPostInstallScriptTemplatePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPostInstallScriptTemplatePath);
        BSTROutConverter TmpPostInstallScriptTemplatePath(aPostInstallScriptTemplatePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLSCRIPTTEMPLATEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPostInstallScriptTemplatePath(TmpPostInstallScriptTemplatePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLSCRIPTTEMPLATEPATH_RETURN(this, hrc, 0 /*normal*/,TmpPostInstallScriptTemplatePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLSCRIPTTEMPLATEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLSCRIPTTEMPLATEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPostInstallScriptTemplatePath=%ls hrc=%Rhrc\n", this, "Unattended::getPostInstallScriptTemplatePath", *aPostInstallScriptTemplatePath, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(PostInstallScriptTemplatePath)(IN_BSTR aPostInstallScriptTemplatePath)
{
    LogRelFlow(("{%p} %s: enter aPostInstallScriptTemplatePath=%ls\n", this, "Unattended::setPostInstallScriptTemplatePath", aPostInstallScriptTemplatePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpPostInstallScriptTemplatePath(aPostInstallScriptTemplatePath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLSCRIPTTEMPLATEPATH_ENTER(this, TmpPostInstallScriptTemplatePath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPostInstallScriptTemplatePath(TmpPostInstallScriptTemplatePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLSCRIPTTEMPLATEPATH_RETURN(this, hrc, 0 /*normal*/,TmpPostInstallScriptTemplatePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLSCRIPTTEMPLATEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLSCRIPTTEMPLATEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setPostInstallScriptTemplatePath", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(PostInstallCommand)(BSTR *aPostInstallCommand)
{
    LogRelFlow(("{%p} %s: enter aPostInstallCommand=%p\n", this, "Unattended::getPostInstallCommand", aPostInstallCommand));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPostInstallCommand);
        BSTROutConverter TmpPostInstallCommand(aPostInstallCommand);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLCOMMAND_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPostInstallCommand(TmpPostInstallCommand.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLCOMMAND_RETURN(this, hrc, 0 /*normal*/,TmpPostInstallCommand.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLCOMMAND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_POSTINSTALLCOMMAND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPostInstallCommand=%ls hrc=%Rhrc\n", this, "Unattended::getPostInstallCommand", *aPostInstallCommand, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(PostInstallCommand)(IN_BSTR aPostInstallCommand)
{
    LogRelFlow(("{%p} %s: enter aPostInstallCommand=%ls\n", this, "Unattended::setPostInstallCommand", aPostInstallCommand));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpPostInstallCommand(aPostInstallCommand);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLCOMMAND_ENTER(this, TmpPostInstallCommand.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPostInstallCommand(TmpPostInstallCommand.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLCOMMAND_RETURN(this, hrc, 0 /*normal*/,TmpPostInstallCommand.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLCOMMAND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_POSTINSTALLCOMMAND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setPostInstallCommand", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(ExtraInstallKernelParameters)(BSTR *aExtraInstallKernelParameters)
{
    LogRelFlow(("{%p} %s: enter aExtraInstallKernelParameters=%p\n", this, "Unattended::getExtraInstallKernelParameters", aExtraInstallKernelParameters));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExtraInstallKernelParameters);
        BSTROutConverter TmpExtraInstallKernelParameters(aExtraInstallKernelParameters);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_EXTRAINSTALLKERNELPARAMETERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtraInstallKernelParameters(TmpExtraInstallKernelParameters.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_EXTRAINSTALLKERNELPARAMETERS_RETURN(this, hrc, 0 /*normal*/,TmpExtraInstallKernelParameters.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_EXTRAINSTALLKERNELPARAMETERS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_EXTRAINSTALLKERNELPARAMETERS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExtraInstallKernelParameters=%ls hrc=%Rhrc\n", this, "Unattended::getExtraInstallKernelParameters", *aExtraInstallKernelParameters, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(ExtraInstallKernelParameters)(IN_BSTR aExtraInstallKernelParameters)
{
    LogRelFlow(("{%p} %s: enter aExtraInstallKernelParameters=%ls\n", this, "Unattended::setExtraInstallKernelParameters", aExtraInstallKernelParameters));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpExtraInstallKernelParameters(aExtraInstallKernelParameters);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_EXTRAINSTALLKERNELPARAMETERS_ENTER(this, TmpExtraInstallKernelParameters.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setExtraInstallKernelParameters(TmpExtraInstallKernelParameters.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_EXTRAINSTALLKERNELPARAMETERS_RETURN(this, hrc, 0 /*normal*/,TmpExtraInstallKernelParameters.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_EXTRAINSTALLKERNELPARAMETERS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_EXTRAINSTALLKERNELPARAMETERS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setExtraInstallKernelParameters", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(DetectedOSTypeId)(BSTR *aDetectedOSTypeId)
{
    LogRelFlow(("{%p} %s: enter aDetectedOSTypeId=%p\n", this, "Unattended::getDetectedOSTypeId", aDetectedOSTypeId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDetectedOSTypeId);
        BSTROutConverter TmpDetectedOSTypeId(aDetectedOSTypeId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSTYPEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDetectedOSTypeId(TmpDetectedOSTypeId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSTYPEID_RETURN(this, hrc, 0 /*normal*/,TmpDetectedOSTypeId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSTYPEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSTYPEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDetectedOSTypeId=%ls hrc=%Rhrc\n", this, "Unattended::getDetectedOSTypeId", *aDetectedOSTypeId, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(DetectedOSVersion)(BSTR *aDetectedOSVersion)
{
    LogRelFlow(("{%p} %s: enter aDetectedOSVersion=%p\n", this, "Unattended::getDetectedOSVersion", aDetectedOSVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDetectedOSVersion);
        BSTROutConverter TmpDetectedOSVersion(aDetectedOSVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDetectedOSVersion(TmpDetectedOSVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSVERSION_RETURN(this, hrc, 0 /*normal*/,TmpDetectedOSVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSVERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDetectedOSVersion=%ls hrc=%Rhrc\n", this, "Unattended::getDetectedOSVersion", *aDetectedOSVersion, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(DetectedOSFlavor)(BSTR *aDetectedOSFlavor)
{
    LogRelFlow(("{%p} %s: enter aDetectedOSFlavor=%p\n", this, "Unattended::getDetectedOSFlavor", aDetectedOSFlavor));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDetectedOSFlavor);
        BSTROutConverter TmpDetectedOSFlavor(aDetectedOSFlavor);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSFLAVOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDetectedOSFlavor(TmpDetectedOSFlavor.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSFLAVOR_RETURN(this, hrc, 0 /*normal*/,TmpDetectedOSFlavor.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSFLAVOR_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSFLAVOR_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDetectedOSFlavor=%ls hrc=%Rhrc\n", this, "Unattended::getDetectedOSFlavor", *aDetectedOSFlavor, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(DetectedOSLanguages)(BSTR *aDetectedOSLanguages)
{
    LogRelFlow(("{%p} %s: enter aDetectedOSLanguages=%p\n", this, "Unattended::getDetectedOSLanguages", aDetectedOSLanguages));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDetectedOSLanguages);
        BSTROutConverter TmpDetectedOSLanguages(aDetectedOSLanguages);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSLANGUAGES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDetectedOSLanguages(TmpDetectedOSLanguages.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSLANGUAGES_RETURN(this, hrc, 0 /*normal*/,TmpDetectedOSLanguages.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSLANGUAGES_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSLANGUAGES_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDetectedOSLanguages=%ls hrc=%Rhrc\n", this, "Unattended::getDetectedOSLanguages", *aDetectedOSLanguages, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(DetectedOSHints)(BSTR *aDetectedOSHints)
{
    LogRelFlow(("{%p} %s: enter aDetectedOSHints=%p\n", this, "Unattended::getDetectedOSHints", aDetectedOSHints));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDetectedOSHints);
        BSTROutConverter TmpDetectedOSHints(aDetectedOSHints);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSHINTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDetectedOSHints(TmpDetectedOSHints.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSHINTS_RETURN(this, hrc, 0 /*normal*/,TmpDetectedOSHints.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSHINTS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDOSHINTS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDetectedOSHints=%ls hrc=%Rhrc\n", this, "Unattended::getDetectedOSHints", *aDetectedOSHints, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(DetectedImageNames)(ComSafeArrayOut(BSTR, aDetectedImageNames))
{
    LogRelFlow(("{%p} %s: enter aDetectedImageNames=%p\n", this, "Unattended::getDetectedImageNames", aDetectedImageNames));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDetectedImageNames);
        ArrayBSTROutConverter TmpDetectedImageNames(ComSafeArrayOutArg(aDetectedImageNames));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGENAMES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDetectedImageNames(TmpDetectedImageNames.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGENAMES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDetectedImageNames.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGENAMES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGENAMES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDetectedImageNames=%zu hrc=%Rhrc\n", this, "Unattended::getDetectedImageNames", ComSafeArraySize(*aDetectedImageNames), hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(DetectedImageIndices)(ComSafeArrayOut(ULONG, aDetectedImageIndices))
{
    LogRelFlow(("{%p} %s: enter aDetectedImageIndices=%p\n", this, "Unattended::getDetectedImageIndices", aDetectedImageIndices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDetectedImageIndices);
        ArrayOutConverter<ULONG> TmpDetectedImageIndices(ComSafeArrayOutArg(aDetectedImageIndices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGEINDICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDetectedImageIndices(TmpDetectedImageIndices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGEINDICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDetectedImageIndices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGEINDICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_DETECTEDIMAGEINDICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDetectedImageIndices=%zu hrc=%Rhrc\n", this, "Unattended::getDetectedImageIndices", ComSafeArraySize(*aDetectedImageIndices), hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(IsUnattendedInstallSupported)(BOOL *aIsUnattendedInstallSupported)
{
    LogRelFlow(("{%p} %s: enter aIsUnattendedInstallSupported=%p\n", this, "Unattended::getIsUnattendedInstallSupported", aIsUnattendedInstallSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsUnattendedInstallSupported);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISUNATTENDEDINSTALLSUPPORTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsUnattendedInstallSupported(aIsUnattendedInstallSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISUNATTENDEDINSTALLSUPPORTED_RETURN(this, hrc, 0 /*normal*/,*aIsUnattendedInstallSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISUNATTENDEDINSTALLSUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/,*aIsUnattendedInstallSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_ISUNATTENDEDINSTALLSUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsUnattendedInstallSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsUnattendedInstallSupported=%RTbool hrc=%Rhrc\n", this, "Unattended::getIsUnattendedInstallSupported", *aIsUnattendedInstallSupported, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(AvoidUpdatesOverNetwork)(BOOL *aAvoidUpdatesOverNetwork)
{
    LogRelFlow(("{%p} %s: enter aAvoidUpdatesOverNetwork=%p\n", this, "Unattended::getAvoidUpdatesOverNetwork", aAvoidUpdatesOverNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAvoidUpdatesOverNetwork);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AVOIDUPDATESOVERNETWORK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAvoidUpdatesOverNetwork(aAvoidUpdatesOverNetwork);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AVOIDUPDATESOVERNETWORK_RETURN(this, hrc, 0 /*normal*/,*aAvoidUpdatesOverNetwork != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AVOIDUPDATESOVERNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,*aAvoidUpdatesOverNetwork != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_GET_AVOIDUPDATESOVERNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,*aAvoidUpdatesOverNetwork != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAvoidUpdatesOverNetwork=%RTbool hrc=%Rhrc\n", this, "Unattended::getAvoidUpdatesOverNetwork", *aAvoidUpdatesOverNetwork, hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMSETTER(AvoidUpdatesOverNetwork)(BOOL aAvoidUpdatesOverNetwork)
{
    LogRelFlow(("{%p} %s: enter aAvoidUpdatesOverNetwork=%RTbool\n", this, "Unattended::setAvoidUpdatesOverNetwork", aAvoidUpdatesOverNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AVOIDUPDATESOVERNETWORK_ENTER(this, aAvoidUpdatesOverNetwork != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAvoidUpdatesOverNetwork(aAvoidUpdatesOverNetwork != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AVOIDUPDATESOVERNETWORK_RETURN(this, hrc, 0 /*normal*/,aAvoidUpdatesOverNetwork != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AVOIDUPDATESOVERNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,aAvoidUpdatesOverNetwork != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_SET_AVOIDUPDATESOVERNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,aAvoidUpdatesOverNetwork != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::setAvoidUpdatesOverNetwork", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute1IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute2IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute3IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute4IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute5IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute6IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute7IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute8IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute9IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute10IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute11IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute12IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute13IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute14IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute15IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::COMGETTER(InternalAndReservedAttribute16IUnattended)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUnattended methods
//

STDMETHODIMP UnattendedWrap::DetectIsoOS()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Unattended::detectIsoOS"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DETECTISOOS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = detectIsoOS();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DETECTISOOS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DETECTISOOS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DETECTISOOS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::detectIsoOS", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::Prepare()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Unattended::prepare"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_PREPARE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = prepare();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_PREPARE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_PREPARE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_PREPARE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::prepare", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::ConstructMedia()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Unattended::constructMedia"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_CONSTRUCTMEDIA_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = constructMedia();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_CONSTRUCTMEDIA_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_CONSTRUCTMEDIA_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_CONSTRUCTMEDIA_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::constructMedia", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::ReconfigureVM()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Unattended::reconfigureVM"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_RECONFIGUREVM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = reconfigureVM();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_RECONFIGUREVM_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_RECONFIGUREVM_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_RECONFIGUREVM_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::reconfigureVM", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::Done()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Unattended::done"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DONE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = done();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DONE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DONE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UNATTENDED_DONE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Unattended::done", hrc));
    return hrc;
}

STDMETHODIMP UnattendedWrap::InternalAndReservedMethod1IUnattended()
{
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::InternalAndReservedMethod2IUnattended()
{
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::InternalAndReservedMethod3IUnattended()
{
    return E_NOTIMPL;
}

STDMETHODIMP UnattendedWrap::InternalAndReservedMethod4IUnattended()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(UnattendedWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(UnattendedWrap, IUnattended)
#endif // VBOX_WITH_XPCOM
