// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewDeletePluginParams creates a new DeletePluginParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeletePluginParams() *DeletePluginParams {
	return &DeletePluginParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeletePluginParamsWithTimeout creates a new DeletePluginParams object
// with the ability to set a timeout on a request.
func NewDeletePluginParamsWithTimeout(timeout time.Duration) *DeletePluginParams {
	return &DeletePluginParams{
		timeout: timeout,
	}
}

// NewDeletePluginParamsWithContext creates a new DeletePluginParams object
// with the ability to set a context for a request.
func NewDeletePluginParamsWithContext(ctx context.Context) *DeletePluginParams {
	return &DeletePluginParams{
		Context: ctx,
	}
}

// NewDeletePluginParamsWithHTTPClient creates a new DeletePluginParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeletePluginParamsWithHTTPClient(client *http.Client) *DeletePluginParams {
	return &DeletePluginParams{
		HTTPClient: client,
	}
}

/*
DeletePluginParams contains all the parameters to send to the API endpoint

	for the delete plugin operation.

	Typically these are written to a http.Request.
*/
type DeletePluginParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125DeletePluginRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete plugin params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePluginParams) WithDefaults() *DeletePluginParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete plugin params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePluginParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete plugin params
func (o *DeletePluginParams) WithTimeout(timeout time.Duration) *DeletePluginParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete plugin params
func (o *DeletePluginParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete plugin params
func (o *DeletePluginParams) WithContext(ctx context.Context) *DeletePluginParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete plugin params
func (o *DeletePluginParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete plugin params
func (o *DeletePluginParams) WithHTTPClient(client *http.Client) *DeletePluginParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete plugin params
func (o *DeletePluginParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the delete plugin params
func (o *DeletePluginParams) WithBody(body *models.HashicorpCloudVault20201125DeletePluginRequest) *DeletePluginParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the delete plugin params
func (o *DeletePluginParams) SetBody(body *models.HashicorpCloudVault20201125DeletePluginRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the delete plugin params
func (o *DeletePluginParams) WithClusterID(clusterID string) *DeletePluginParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the delete plugin params
func (o *DeletePluginParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the delete plugin params
func (o *DeletePluginParams) WithLocationOrganizationID(locationOrganizationID string) *DeletePluginParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the delete plugin params
func (o *DeletePluginParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the delete plugin params
func (o *DeletePluginParams) WithLocationProjectID(locationProjectID string) *DeletePluginParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the delete plugin params
func (o *DeletePluginParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *DeletePluginParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
