// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// GetClientCountsReader is a Reader for the GetClientCounts structure.
type GetClientCountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetClientCountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetClientCountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetClientCountsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetClientCountsOK creates a GetClientCountsOK with default headers values
func NewGetClientCountsOK() *GetClientCountsOK {
	return &GetClientCountsOK{}
}

/*
GetClientCountsOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetClientCountsOK struct {
	Payload *models.HashicorpCloudVault20201125GetClientCountsResponse
}

// IsSuccess returns true when this get client counts o k response has a 2xx status code
func (o *GetClientCountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get client counts o k response has a 3xx status code
func (o *GetClientCountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get client counts o k response has a 4xx status code
func (o *GetClientCountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get client counts o k response has a 5xx status code
func (o *GetClientCountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get client counts o k response a status code equal to that given
func (o *GetClientCountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get client counts o k response
func (o *GetClientCountsOK) Code() int {
	return 200
}

func (o *GetClientCountsOK) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/clients][%d] getClientCountsOK  %+v", 200, o.Payload)
}

func (o *GetClientCountsOK) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/clients][%d] getClientCountsOK  %+v", 200, o.Payload)
}

func (o *GetClientCountsOK) GetPayload() *models.HashicorpCloudVault20201125GetClientCountsResponse {
	return o.Payload
}

func (o *GetClientCountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125GetClientCountsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClientCountsDefault creates a GetClientCountsDefault with default headers values
func NewGetClientCountsDefault(code int) *GetClientCountsDefault {
	return &GetClientCountsDefault{
		_statusCode: code,
	}
}

/*
GetClientCountsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetClientCountsDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this get client counts default response has a 2xx status code
func (o *GetClientCountsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get client counts default response has a 3xx status code
func (o *GetClientCountsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get client counts default response has a 4xx status code
func (o *GetClientCountsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get client counts default response has a 5xx status code
func (o *GetClientCountsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get client counts default response a status code equal to that given
func (o *GetClientCountsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get client counts default response
func (o *GetClientCountsDefault) Code() int {
	return o._statusCode
}

func (o *GetClientCountsDefault) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/clients][%d] GetClientCounts default  %+v", o._statusCode, o.Payload)
}

func (o *GetClientCountsDefault) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/clients][%d] GetClientCounts default  %+v", o._statusCode, o.Payload)
}

func (o *GetClientCountsDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *GetClientCountsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
