//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
#include "pxr/usd/usdRender/tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

UsdRenderTokensType::UsdRenderTokensType() :
    adjustApertureHeight("adjustApertureHeight", TfToken::Immortal),
    adjustApertureWidth("adjustApertureWidth", TfToken::Immortal),
    adjustPixelAspectRatio("adjustPixelAspectRatio", TfToken::Immortal),
    aspectRatioConformPolicy("aspectRatioConformPolicy", TfToken::Immortal),
    camera("camera", TfToken::Immortal),
    collectionCameraVisibilityIncludeRoot("collection:cameraVisibility:includeRoot", TfToken::Immortal),
    collectionRenderVisibilityIncludeRoot("collection:renderVisibility:includeRoot", TfToken::Immortal),
    color3f("color3f", TfToken::Immortal),
    command("command", TfToken::Immortal),
    cropAperture("cropAperture", TfToken::Immortal),
    dataType("dataType", TfToken::Immortal),
    dataWindowNDC("dataWindowNDC", TfToken::Immortal),
    deepRaster("deepRaster", TfToken::Immortal),
    disableDepthOfField("disableDepthOfField", TfToken::Immortal),
    disableMotionBlur("disableMotionBlur", TfToken::Immortal),
    expandAperture("expandAperture", TfToken::Immortal),
    fileName("fileName", TfToken::Immortal),
    full("full", TfToken::Immortal),
    includedPurposes("includedPurposes", TfToken::Immortal),
    inputPasses("inputPasses", TfToken::Immortal),
    instantaneousShutter("instantaneousShutter", TfToken::Immortal),
    intrinsic("intrinsic", TfToken::Immortal),
    lpe("lpe", TfToken::Immortal),
    materialBindingPurposes("materialBindingPurposes", TfToken::Immortal),
    orderedVars("orderedVars", TfToken::Immortal),
    passType("passType", TfToken::Immortal),
    pixelAspectRatio("pixelAspectRatio", TfToken::Immortal),
    preview("preview", TfToken::Immortal),
    primvar("primvar", TfToken::Immortal),
    productName("productName", TfToken::Immortal),
    products("products", TfToken::Immortal),
    productType("productType", TfToken::Immortal),
    raster("raster", TfToken::Immortal),
    raw("raw", TfToken::Immortal),
    renderingColorSpace("renderingColorSpace", TfToken::Immortal),
    renderSettingsPrimPath("renderSettingsPrimPath", TfToken::Immortal),
    renderSource("renderSource", TfToken::Immortal),
    renderVisibility("renderVisibility", TfToken::Immortal),
    resolution("resolution", TfToken::Immortal),
    sourceName("sourceName", TfToken::Immortal),
    sourceType("sourceType", TfToken::Immortal),
    RenderPass("RenderPass", TfToken::Immortal),
    RenderProduct("RenderProduct", TfToken::Immortal),
    RenderSettings("RenderSettings", TfToken::Immortal),
    RenderSettingsBase("RenderSettingsBase", TfToken::Immortal),
    RenderVar("RenderVar", TfToken::Immortal),
    allTokens({
        adjustApertureHeight,
        adjustApertureWidth,
        adjustPixelAspectRatio,
        aspectRatioConformPolicy,
        camera,
        collectionCameraVisibilityIncludeRoot,
        collectionRenderVisibilityIncludeRoot,
        color3f,
        command,
        cropAperture,
        dataType,
        dataWindowNDC,
        deepRaster,
        disableDepthOfField,
        disableMotionBlur,
        expandAperture,
        fileName,
        full,
        includedPurposes,
        inputPasses,
        instantaneousShutter,
        intrinsic,
        lpe,
        materialBindingPurposes,
        orderedVars,
        passType,
        pixelAspectRatio,
        preview,
        primvar,
        productName,
        products,
        productType,
        raster,
        raw,
        renderingColorSpace,
        renderSettingsPrimPath,
        renderSource,
        renderVisibility,
        resolution,
        sourceName,
        sourceType,
        RenderPass,
        RenderProduct,
        RenderSettings,
        RenderSettingsBase,
        RenderVar
    })
{
}

TfStaticData<UsdRenderTokensType> UsdRenderTokens;

PXR_NAMESPACE_CLOSE_SCOPE
