//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/geomSubsetSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdGeomSubsetSchemaTokens,
    HD_GEOM_SUBSET_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenDataSourceHandle
HdGeomSubsetSchema::GetType() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdGeomSubsetSchemaTokens->type);
}

HdIntArrayDataSourceHandle
HdGeomSubsetSchema::GetIndices() const
{
    return _GetTypedDataSource<HdIntArrayDataSource>(
        HdGeomSubsetSchemaTokens->indices);
}

/*static*/
HdContainerDataSourceHandle
HdGeomSubsetSchema::BuildRetained(
        const HdTokenDataSourceHandle &type,
        const HdIntArrayDataSourceHandle &indices
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (type) {
        _names[_count] = HdGeomSubsetSchemaTokens->type;
        _values[_count++] = type;
    }

    if (indices) {
        _names[_count] = HdGeomSubsetSchemaTokens->indices;
        _values[_count++] = indices;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdGeomSubsetSchema::Builder &
HdGeomSubsetSchema::Builder::SetType(
    const HdTokenDataSourceHandle &type)
{
    _type = type;
    return *this;
}

HdGeomSubsetSchema::Builder &
HdGeomSubsetSchema::Builder::SetIndices(
    const HdIntArrayDataSourceHandle &indices)
{
    _indices = indices;
    return *this;
}

HdContainerDataSourceHandle
HdGeomSubsetSchema::Builder::Build()
{
    return HdGeomSubsetSchema::BuildRetained(
        _type,
        _indices
    );
}

/*static*/
HdGeomSubsetSchema
HdGeomSubsetSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdGeomSubsetSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdGeomSubsetSchemaTokens->geomSubset))
        : nullptr);
}

/*static*/
const TfToken &
HdGeomSubsetSchema::GetSchemaToken()
{
    return HdGeomSubsetSchemaTokens->geomSubset;
}

/*static*/
const HdDataSourceLocator &
HdGeomSubsetSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/*static*/
HdTokenDataSourceHandle
HdGeomSubsetSchema::BuildTypeDataSource(
    const TfToken &type)
{

    if (type == HdGeomSubsetSchemaTokens->typeFaceSet) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(type);
        return ds;
    }
    if (type == HdGeomSubsetSchemaTokens->typePointSet) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(type);
        return ds;
    }
    if (type == HdGeomSubsetSchemaTokens->typeCurveSet) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(type);
        return ds;
    }
    // fallback for unknown token
    return HdRetainedTypedSampledDataSource<TfToken>::New(type);
} 

PXR_NAMESPACE_CLOSE_SCOPE